/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.formplugin.edit;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.ImageList;
import kd.bos.form.control.Label;
import kd.bos.form.control.Rate;
import kd.bos.form.control.events.RateEvent;
import kd.bos.form.control.events.RateListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.Border;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.orm.query.QFilter;
import kd.scm.malcore.domain.ProdCommentContentDetail;
import kd.scm.malcore.domain.ProdCommentLabel;
import kd.scm.malcore.enums.ProdCommentTypeEnum;

public final class PbdProdCommentEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
UploadListener,
RateListener {
    private static Log log = LogFactory.getLog(PbdProdCommentEdit.class);
    private static final String LEVEL = "level";
    private static final String STARS = "stars";
    private static final String SCORE = "score";
    private static final String TEXT = "text";
    private static final String LABEL = "label";
    private static final String PICTURE = "picture";
    private static final String ADD = "add";
    private static final String INPUT = "input";
    private static final String SHOW = "show";
    private static final String MUSTINPUT = "mustinput";
    private static final String SPLIT = "_";
    private static final String CONTAINER = "container";
    private static final String OPENSTYLE_VIEW = "view";
    private static final String OPENSTYLE_NEW = "new";
    private static final String PICTURE_URL_SPLIT = " ";

    public void afterCreateNewData(EventObject e) {
        this.commentInfoView();
    }

    private void commentInfoView() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams.get("commentDetails") == null) {
            return;
        }
        String openStyle = (String)customParams.get("openStyle");
        List<ProdCommentContentDetail> commentDetails = this.getProdCommentContentDetail();
        this.commentInfoShow(commentDetails, openStyle);
    }

    private List<ProdCommentContentDetail> getProdCommentContentDetail() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        return SerializationUtils.fromJsonStringToList((String)((String)customParams.get("commentDetails")), ProdCommentContentDetail.class);
    }

    private void commentInfoShow(List<ProdCommentContentDetail> commentDetails, String openStyle) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"picturecontainer", "labelcontainer"});
        Map<String, Integer> typeNum = this.initCommentTypeNum();
        ArrayList<Long> labelIds = new ArrayList<Long>(commentDetails.size());
        for (ProdCommentContentDetail commentDetail : commentDetails) {
            this.commentCommonDeal(commentDetail, openStyle, typeNum);
            if (ProdCommentTypeEnum.LABEL.getVal().equals(commentDetail.getModuleType())) {
                labelIds.add(Long.valueOf(commentDetail.getValue()));
                continue;
            }
            this.commentDealFactory(commentDetail, openStyle, typeNum);
        }
        this.labelViewDeal(labelIds, openStyle);
        this.hideExtraControl(typeNum);
    }

    private Map<String, Integer> initCommentTypeNum() {
        HashMap<String, Integer> typeAndNumMap = new HashMap<String, Integer>(8);
        typeAndNumMap.put(ProdCommentTypeEnum.STARS.getVal(), 1);
        typeAndNumMap.put(ProdCommentTypeEnum.SCORE.getVal(), 1);
        typeAndNumMap.put(ProdCommentTypeEnum.TEXT.getVal(), 1);
        return typeAndNumMap;
    }

    private void commentCommonDeal(ProdCommentContentDetail commentDetail, String openStyle, Map<String, Integer> typeNum) {
        String index = "";
        Integer integer = typeNum.get(commentDetail.getModuleType());
        if (integer != null) {
            index = String.valueOf(integer);
        }
        String moduleName = ProdCommentTypeEnum.getEnumKey((String)commentDetail.getModuleType()).toLowerCase();
        String commentTitle = commentDetail.getCommentTitle();
        Label label = (Label)this.getControl(moduleName + LABEL + index);
        label.setText(commentTitle);
        if (OPENSTYLE_VIEW.equals(openStyle) || !commentDetail.getMustInput().booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{moduleName + MUSTINPUT + index});
        }
    }

    private void commentDealFactory(ProdCommentContentDetail commentDetail, String openStyle, Map<String, Integer> typeNum) {
        String type = commentDetail.getModuleType();
        switch (ProdCommentTypeEnum.fromVal((String)type)) {
            case LEVEL: {
                this.levelViewDeal(commentDetail, openStyle);
                break;
            }
            case STARS: {
                this.starsViewDeal(commentDetail, openStyle, typeNum);
                break;
            }
            case SCORE: {
                this.scoreViewDeal(commentDetail, openStyle, typeNum);
                break;
            }
            case TEXT: {
                this.textViewDeal(commentDetail, openStyle, typeNum);
                break;
            }
            case PICTURE: {
                this.pictureViewDeal(commentDetail, openStyle);
                break;
            }
        }
    }

    private void levelViewDeal(ProdCommentContentDetail commentDetail, String openStyle) {
        String value = commentDetail.getValue();
        if (OPENSTYLE_VIEW.equals(openStyle)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"positiveradio", "moderateradio", "negativeradio"});
            String msg = "";
            if ("A".equals(value)) {
                msg = ResManager.loadKDString((String)"\u597d\u8bc4", (String)"PbdProdCommentEdit_0", (String)"scm-pbd-formplugin", (Object[])new Object[0]);
            } else if ("B".equals(value)) {
                msg = ResManager.loadKDString((String)"\u4e2d\u8bc4", (String)"PbdProdCommentEdit_1", (String)"scm-pbd-formplugin", (Object[])new Object[0]);
            } else if ("C".equals(value)) {
                msg = ResManager.loadKDString((String)"\u5dee\u8bc4", (String)"PbdProdCommentEdit_2", (String)"scm-pbd-formplugin", (Object[])new Object[0]);
            }
            this.getModel().setValue(LEVEL, (Object)msg);
        } else if (OPENSTYLE_NEW.equals(openStyle)) {
            String[] split = value.split(",");
            HashSet<String> levels = new HashSet<String>(8);
            levels.add("A");
            levels.add("B");
            levels.add("C");
            for (String level : split) {
                levels.remove(level);
            }
            for (String level : levels) {
                if ("A".equals(level)) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"positiveradio"});
                    continue;
                }
                if ("B".equals(level)) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"moderateradio"});
                    continue;
                }
                if (!"C".equals(level)) continue;
                this.getView().setVisible(Boolean.FALSE, new String[]{"negativeradio"});
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{LEVEL});
        }
    }

    private void starsViewDeal(ProdCommentContentDetail commentDetail, String openStyle, Map<String, Integer> typeNum) {
        Integer index = typeNum.get(ProdCommentTypeEnum.STARS.getVal());
        if (OPENSTYLE_VIEW.equals(openStyle)) {
            Rate stars = (Rate)this.getControl(STARS + index);
            stars.setRateScore((Number)new BigDecimal(commentDetail.getValue()));
            this.getView().setEnable(Boolean.FALSE, new String[]{STARS + index});
        }
        typeNum.put(ProdCommentTypeEnum.STARS.getVal(), index + 1);
    }

    private void scoreViewDeal(ProdCommentContentDetail commentDetail, String openStyle, Map<String, Integer> typeNum) {
        Integer index = typeNum.get(ProdCommentTypeEnum.SCORE.getVal());
        String value = commentDetail.getValue();
        if (OPENSTYLE_VIEW.equals(openStyle)) {
            value = ResManager.loadKDString((String)"{0}\u5206", (String)"PbdProdCommentEdit_6", (String)"scm-pbd-formplugin", (Object[])new Object[]{value});
            this.getModel().setValue(SCORE + index, (Object)value);
            this.getView().setVisible(Boolean.FALSE, new String[]{"scoreadd" + index});
        } else if (OPENSTYLE_NEW.equals(openStyle)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{SCORE + index});
            this.getModel().setValue("scoreadd" + index, (Object)this.getScore(value));
            this.getPageCache().put("scoreadd" + index, this.getScore(value).toString());
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", "scorecontainer" + index);
            map.put("cstyles", "eyJ0eXBlIjowLCJjb250ZW50IjoiwqAvKiogXG4qIOagt+S+i1xuKiDmlK/mjIHljp/nlJ9jc3PmoLflvI/lhpnms5Vcbiog5b2T5YmN5YWD57Sg55qEY2xhc3NOYW1l5L2/55SoIFwiJFwiIOS7o+abv++8jOS4jeaUr+aMgeiHquWumuS5ieWFg+e0oGNsYXNzTmFtZVxuKiDnm67liY3mj5DkvpvkuInkuKrmoLfmnb/vvIzmiZPlvIDms6jph4rljbPlj6/kvb/nlKhcbiog5rOo6YeK5YaF5a655Lya6KKr6L+H5ruk5LiN5bGV56S6XG4qIOWmgumcgOS9v+eUqOW5s+WPsOS4u+mimOiJsu+8jOWPr+S7peS9v+eUqCd0aGVtZUNvbG9yJ+adpeS7o+aMh1xuICovXG4vKipcbiog5b2T5YmN5YWD57Sg6IOM5pmv6aKc6Imy6Lef6ZqP5Li76aKY6ImyXG4qL1xuLyoqXG4kIHtcbsKgwqBiYWNrZ3JvdW5kOid0aGVtZUNvbG9yJztcbsKgfVxuKi9cbsKgLyoqXG4qIOS/ruaUueW9k+WJjeWFg+e0oOiDjOaZr+minOiJslxuKi9cbi8qKlxuJCB7XG7CoMKgYmFja2dyb3VuZDpyZWQ7XG7CoH1cbiovXG7CoC8qKlxuKiDkv67mlLnlvZPliY3lhYPntKBob3ZlcuaViOaenFxuwqAgKi9cbi8qKlxuJDpob3ZlciB7XG7CoMKgYmFja2dyb3VuZDpyZWQ7XG7CoH1cbiovXG4vKipcbiAqIOS/ruaUueW9k+WJjeWFg+e0oOS4umRpduagh+etvuWtkOWFg+e0oFxuKi9cbi8qKlxuJCA+IGRpdiB7XG7CoGJhY2tncm91bmQ6cmVkO1xuwqB9XG4gKi9cbiQge1xuwqDCoGhlaWdodDozNXB4O1xuwqB9In0=");
            this.getView().updateControlMetadata("scorecontainer" + index, map);
        }
        typeNum.put(ProdCommentTypeEnum.SCORE.getVal(), index + 1);
    }

    private BigDecimal getScore(String value) {
        BigDecimal bigDecimal = new BigDecimal(0);
        switch (value) {
            case "A": {
                bigDecimal = new BigDecimal(100);
                break;
            }
            case "B": {
                bigDecimal = new BigDecimal(50);
                break;
            }
            case "C": {
                bigDecimal = new BigDecimal(10);
                break;
            }
            case "D": {
                bigDecimal = new BigDecimal(5);
                break;
            }
        }
        return bigDecimal;
    }

    private void textViewDeal(ProdCommentContentDetail contentDetail, String openStyle, Map<String, Integer> typeNum) {
        Integer index = typeNum.get(ProdCommentTypeEnum.TEXT.getVal());
        String value = contentDetail.getValue();
        if (OPENSTYLE_VIEW.equals(openStyle)) {
            this.getModel().setValue(TEXT + index, (Object)value);
            this.getView().setVisible(Boolean.FALSE, new String[]{"textinput" + index});
        } else if (OPENSTYLE_NEW.equals(openStyle)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{TEXT + index});
            this.setTextEmptyTip("textinput" + index, value);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", "textcontainer" + index);
            map.put("cstyles", "eyJ0eXBlIjowLCJjb250ZW50IjoiwqAvKiogXG4qIOagt+S+i1xuKiDmlK/mjIHljp/nlJ9jc3PmoLflvI/lhpnms5Vcbiog5b2T5YmN5YWD57Sg55qEY2xhc3NOYW1l5L2/55SoIFwiJFwiIOS7o+abv++8jOS4jeaUr+aMgeiHquWumuS5ieWFg+e0oGNsYXNzTmFtZVxuKiDnm67liY3mj5DkvpvkuInkuKrmoLfmnb/vvIzmiZPlvIDms6jph4rljbPlj6/kvb/nlKhcbiog5rOo6YeK5YaF5a655Lya6KKr6L+H5ruk5LiN5bGV56S6XG4qIOWmgumcgOS9v+eUqOW5s+WPsOS4u+mimOiJsu+8jOWPr+S7peS9v+eUqCd0aGVtZUNvbG9yJ+adpeS7o+aMh1xuICovXG4vKipcbiog5b2T5YmN5YWD57Sg6IOM5pmv6aKc6Imy6Lef6ZqP5Li76aKY6ImyXG4qL1xuLyoqXG4kIHtcbsKgwqBiYWNrZ3JvdW5kOid0aGVtZUNvbG9yJztcbsKgfVxuKi9cbsKgLyoqXG4qIOS/ruaUueW9k+WJjeWFg+e0oOiDjOaZr+minOiJslxuKi9cbi8qKlxuJCB7XG7CoMKgYmFja2dyb3VuZDpyZWQ7XG7CoH1cbiovXG7CoC8qKlxuKiDkv67mlLnlvZPliY3lhYPntKBob3ZlcuaViOaenFxuwqAgKi9cbi8qKlxuJDpob3ZlciB7XG7CoMKgYmFja2dyb3VuZDpyZWQ7XG7CoH1cbiovXG4vKipcbiAqIOS/ruaUueW9k+WJjeWFg+e0oOS4umRpduagh+etvuWtkOWFg+e0oFxuKi9cbi8qKlxuJCA+IGRpdiB7XG7CoGJhY2tncm91bmQ6cmVkO1xuwqB9XG4gKi9cbiQge1xuwqDCoGhlaWdodDo0MHB4O1xuwqB9In0=");
            this.getView().updateControlMetadata("textcontainer" + index, map);
        }
        typeNum.put(ProdCommentTypeEnum.TEXT.getVal(), index + 1);
    }

    private void setTextEmptyTip(String fieldName, String tip) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap mapItem = new HashMap();
        HashMap<String, String> mapTip = new HashMap<String, String>();
        mapTip.put(RequestContext.get().getLang().name(), tip);
        mapItem.put("emptytip", mapTip);
        map.put("id", fieldName);
        map.put("item", mapItem);
        this.getView().updateControlMetadata(fieldName, map);
    }

    private void labelViewDeal(List<Long> labelIds, String openStyle) {
        if (labelIds.isEmpty()) {
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"labelcontainer"});
        if (OPENSTYLE_NEW.equals(openStyle)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"labelshowcontainer"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"labelbasedata"});
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            if (StringUtils.isBlank(customParams.get("prodCommentLabels"))) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"labelcontainer"});
                return;
            }
            Container labelShowContainer = (Container)this.getControl("labelshowcontainer");
            ArrayList<Map> labelControl = new ArrayList<Map>();
            List ProdCommentLabels = SerializationUtils.fromJsonStringToList((String)((String)customParams.get("prodCommentLabels")), ProdCommentLabel.class);
            Map<Long, ProdCommentLabel> idAndLabels = ProdCommentLabels.stream().collect(Collectors.toMap(ProdCommentLabel::getId, k -> k));
            for (int index = 0; index < labelIds.size(); ++index) {
                Long labelId = labelIds.get(index);
                ProdCommentLabel prodCommentLabel = idAndLabels.get(labelId);
                if (prodCommentLabel == null) continue;
                FlexPanelAp flexPanelAp = this.createFlexPanelAp(index, prodCommentLabel);
                labelControl.add(flexPanelAp.createControl());
            }
            labelShowContainer.addControls(labelControl);
        }
    }

    private LabelAp createLabelText(int index, ProdCommentLabel prodCommentLabel) {
        String color = this.getColor(prodCommentLabel);
        LabelAp labelAp = new LabelAp();
        labelAp.setId("labelshow" + index);
        labelAp.setKey("labelshow" + index);
        labelAp.setLabelStyle("1");
        labelAp.setShrink(0);
        labelAp.setForeColor(color);
        labelAp.setFontSize(14);
        labelAp.setName(new LocaleString(prodCommentLabel.getName()));
        return labelAp;
    }

    private FlexPanelAp createFlexPanelAp(int index, ProdCommentLabel prodCommentLabel) {
        String color = this.getColor(prodCommentLabel);
        FlexPanelAp res = new FlexPanelAp();
        res.setId(index + SPLIT + TEXT + SPLIT + CONTAINER);
        res.setKey(index + SPLIT + TEXT + SPLIT + CONTAINER);
        res.setRadius("5px");
        res.setHeight(new LocaleString("25px"));
        res.setGrow(0);
        res.setAlignItems("center");
        res.setShrink(0);
        res.setIndex(1);
        res.setJustifyContent("center");
        res.setWrap(false);
        res.setWidth(new LocaleString("95px"));
        res.setName(new LocaleString(index + SPLIT + TEXT + SPLIT + CONTAINER));
        Border border = new Border();
        border.setTop("1px_solid_" + color);
        border.setLeft("1px_solid_" + color);
        border.setBottom("1px_solid_" + color);
        border.setRight("1px_solid_" + color);
        Margin margin = new Margin();
        margin.setRight("10px");
        margin.setBottom("10px");
        Style style = new Style();
        style.setBorder(border);
        style.setMargin(margin);
        res.setStyle(style);
        LabelAp labelAp = this.createLabelText(index, prodCommentLabel);
        res.getItems().add(labelAp);
        return res;
    }

    private String getColor(ProdCommentLabel prodCommentLabel) {
        String labelType = prodCommentLabel.getLabelType();
        String color = "";
        color = "1".equals(labelType) ? "#666666" : "#999999";
        return color;
    }

    private void pictureViewDeal(ProdCommentContentDetail contentDetail, String openStyle) {
        this.getView().setVisible(Boolean.TRUE, new String[]{"picturecontainer"});
        if (OPENSTYLE_VIEW.equals(openStyle)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{PICTURE});
            String urls = contentDetail.getValue();
            ImageList imageList = (ImageList)this.getView().getControl(PICTURE);
            if (StringUtils.isNotBlank((CharSequence)urls)) {
                String[] imageUrls = urls.split(PICTURE_URL_SPLIT);
                imageList.setImageUrls(imageUrls);
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"picturecontainer"});
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{"picturetitlecontainer"});
        } else if (OPENSTYLE_NEW.equals(openStyle)) {
            String num = contentDetail.getValue();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", PICTURE);
            map.put("maximgsize", num);
            this.getView().updateControlMetadata(PICTURE, map);
        }
    }

    private void hideExtraControl(Map<String, Integer> typeNum) {
        for (Map.Entry<String, Integer> entry : typeNum.entrySet()) {
            String moduleType = entry.getKey();
            Integer index = entry.getValue();
            for (int i = index.intValue(); i < 6; ++i) {
                this.getView().setVisible(Boolean.FALSE, new String[]{ProdCommentTypeEnum.getEnumKey((String)moduleType).toLowerCase() + CONTAINER + i});
            }
        }
    }

    public void update(RateEvent e) {
        Number rateScore = e.getRateScore();
        Rate source = (Rate)e.getSource();
        String key = source.getKey();
        this.getModel().setValue(key + "value", (Object)rateScore);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ImageList imageList = (ImageList)this.getControl(PICTURE);
        imageList.addUploadListener((UploadListener)this);
        MulBasedataEdit label = (MulBasedataEdit)this.getControl("labelbasedata");
        label.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        for (int index = 1; index < 6; ++index) {
            Rate stars = (Rate)this.getControl(STARS + index);
            stars.addRateListener((RateListener)this);
        }
    }

    public void upload(UploadEvent evt) {
        String fileUrls = this.parseFileUrls(evt);
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)PICTURE)) {
            String reurl = (String)this.getModel().getValue("pictureurl");
            log.info("\u4e0a\u4f20\u56fe\u7247url\uff1a" + fileUrls);
            if (StringUtils.isNotBlank((CharSequence)fileUrls)) {
                reurl = reurl + fileUrls;
            }
            this.getModel().setValue("pictureurl", (Object)reurl);
            log.info("\u4e0a\u4f20\u540e\u56fe\u7247\u5927\u6587\u672c\uff1a" + reurl);
        }
    }

    private String parseFileUrls(UploadEvent evt) {
        Object[] urls = evt.getUrls();
        if (urls == null) {
            return null;
        }
        StringBuilder urlsbuf = new StringBuilder();
        for (Object url : urls) {
            urlsbuf.append(url);
            urlsbuf.append(PICTURE_URL_SPLIT);
        }
        return urlsbuf.toString();
    }

    public void remove(UploadEvent evt) {
        super.remove(evt);
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)PICTURE)) {
            Object[] dele = evt.getIndexes();
            Integer delenumber = (Integer)dele[0];
            String fileUrls = (String)this.getModel().getValue("pictureurl");
            String[] reurllist = fileUrls.split(PICTURE_URL_SPLIT);
            for (int i = delenumber.intValue(); i < reurllist.length - delenumber - 1; ++i) {
                reurllist[i] = reurllist[i + 1];
            }
            reurllist[reurllist.length - 1] = "";
            StringBuffer reurl = new StringBuffer();
            for (int i = 0; i < reurllist.length - 1; ++i) {
                reurl.append(reurllist[i]);
                reurl.append(PICTURE_URL_SPLIT);
            }
            log.info("\u5220\u9664\u56fe\u7247\u540e\u56fe\u7247\u5927\u6587\u672c\uff1a" + fileUrls);
            this.getModel().setValue("pictureurl", (Object)reurl);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        String name = property.getName();
        if (name.startsWith("scoreadd")) {
            String max = this.getPageCache().get(name);
            ChangeData changeData = e.getChangeSet()[0];
            BigDecimal newValue = (BigDecimal)changeData.getNewValue();
            if (newValue.compareTo(new BigDecimal(max)) > 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u503c\u4e0d\u80fd\u5927\u4e8e{0}\u3002", (String)"PbdProdCommentEdit_4", (String)"scm-pbd-formplugin", (Object[])new Object[]{max}));
                this.getModel().setValue(name, changeData.getOldValue());
            }
            if (newValue.compareTo(BigDecimal.ZERO) < 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u503c\u4e0d\u80fd\u5c0f\u4e8e0\u3002", (String)"PbdProdCommentEdit_5", (String)"scm-pbd-formplugin", (Object[])new Object[]{max}));
                this.getModel().setValue(name, changeData.getOldValue());
            }
        } else if ("radiogroup".equals(name)) {
            ChangeData changeData = e.getChangeSet()[0];
            String newValue = (String)changeData.getNewValue();
            this.getModel().setValue(LEVEL, (Object)newValue);
        } else if ("labelbasedata".equals(name)) {
            StringBuilder labelIds = new StringBuilder();
            ChangeData changeData = e.getChangeSet()[0];
            MulBasedataDynamicObjectCollection newValue = (MulBasedataDynamicObjectCollection)changeData.getNewValue();
            MulBasedataDynamicObjectCollection oldValue = (MulBasedataDynamicObjectCollection)changeData.getOldValue();
            if (newValue.size() > 10) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6807\u7b7e\u4e0d\u80fd\u591a\u4e8e10\u4e2a\u3002", (String)"PbdProdCommentEdit_7", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("labelbasedata", (Object)oldValue);
            }
            for (DynamicObject dynamicObject : newValue) {
                labelIds.append(dynamicObject.getLong("fbasedataid_id")).append(',');
            }
            this.getModel().setValue("labelid", (Object)labelIds.toString());
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key;
        switch (key = evt.getProperty().getName()) {
            case "labelbasedata": {
                Map customParams = this.getView().getFormShowParameter().getCustomParams();
                List ProdCommentLabels = new ArrayList();
                if (StringUtils.isNotBlank(customParams.get("prodCommentLabels"))) {
                    ProdCommentLabels = SerializationUtils.fromJsonStringToList((String)((String)customParams.get("prodCommentLabels")), ProdCommentLabel.class);
                }
                ArrayList<Long> ids = new ArrayList<Long>(ProdCommentLabels.size());
                for (ProdCommentLabel prodCommentLabel : ProdCommentLabels) {
                    ids.add(prodCommentLabel.getId());
                }
                QFilter qFilter = new QFilter("id", "in", ids);
                ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().setFilter(qFilter);
                break;
            }
        }
    }
}

