/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.formplugin.edit;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.IBillView;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.ISVInfo;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.servicehelper.ISVServiceHelper;

public class PbdScDataServiceEdit
extends AbstractBillPlugIn {
    private static final String CONFIG_ENTITY = "configentity";

    public void afterCreateNewData(EventObject e) {
        this.setIsvInfo();
    }

    public void afterLoadData(EventObject e) {
        this.initHandleProperty();
    }

    private void setIsvInfo() {
        ISVInfo isvInfo = ISVServiceHelper.getISVInfo();
        if (isvInfo != null && isvInfo.getId() != null) {
            this.getModel().beginInit();
            this.getModel().setValue("isv", (Object)isvInfo.getId());
            this.getModel().endInit();
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (this.handleDataCheck()) {
            ((IBillView)this.getView()).setBillStatus(BillOperationStatus.ADDNEW);
        } else {
            ((IBillView)this.getView()).setBillStatus(BillOperationStatus.EDIT);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (StringUtils.equals((CharSequence)e.getProperty().getName(), (CharSequence)"entity")) {
            this.initHandleProperty();
        }
        if (StringUtils.equals((CharSequence)e.getProperty().getName(), (CharSequence)"serviceclass")) {
            try {
                TypesContainer.createInstance((String)e.getChangeSet()[0].getNewValue().toString());
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u63d2\u4ef6\u90e8\u7f72\u68c0\u67e5\u6210\u529f\u3002", (String)"PbdScDataServiceEdit_3", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
            }
            catch (Exception ex) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u63d2\u4ef6\u90e8\u7f72\u68c0\u67e5\u5931\u8d25\uff0c{0}", (String)"PbdScDataServiceEdit_2", (String)"scm-pbd-formplugin", (Object[])new Object[]{ex.getLocalizedMessage()}));
            }
        }
    }

    private boolean handleDataCheck() {
        boolean checkFlag = true;
        ISVInfo isvInfo = ISVServiceHelper.getISVInfo();
        if (isvInfo != null && isvInfo.getId() != null) {
            String isv = this.getModel().getDataEntity().getString("isv");
            if (isv != null && !isv.equals(isvInfo.getId())) {
                String message = ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5c5e\u4e8e\u5f53\u524d\u5f00\u53d1\u5546\uff0c\u6682\u4e0d\u652f\u6301\u8c03\u6574\u3002", (String)"PbdScDataServiceEdit_0", (String)"scm-pbd-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(message);
                checkFlag = false;
            }
        } else {
            String message = ResManager.loadKDString((String)"\u5f53\u524d\u73af\u5883\u6682\u672a\u8bbe\u7f6e\u5f00\u53d1\u5546\uff0c\u6682\u4e0d\u652f\u6301\u8c03\u6574\u3002", (String)"PbdScDataServiceEdit_1", (String)"scm-pbd-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(message);
            checkFlag = false;
        }
        return checkFlag;
    }

    private void initHandleProperty() {
        ComboEdit refproperty = (ComboEdit)this.getControl("handleproperty");
        DynamicObject entity = this.getModel().getDataEntity().getDynamicObject("entity");
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entity.getString("id"));
        refproperty.setComboItems(this.assembleProperty(mainEntityType, ""));
    }

    private List<ComboItem> assembleProperty(MainEntityType mainEntityType, String suffix) {
        ComboItem property = null;
        Map typeAllFields = mainEntityType.getAllFields();
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(typeAllFields.size());
        for (Map.Entry entry : typeAllFields.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.endsWith(suffix)) continue;
            IDataEntityProperty value = (IDataEntityProperty)entry.getValue();
            if (value.getParent() instanceof EntryType) {
                key = value.getParent().getName() + "." + key;
            }
            property = new ComboItem(new LocaleString(value.getDisplayName() + "(" + key + ")"), key);
            comboItems.add(property);
        }
        return comboItems;
    }
}

