/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.formplugin.edit;

import java.util.Comparator;
import java.util.EventObject;
import java.util.Iterator;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.helper.apiconnector.api.util.Parser;
import kd.scm.common.helper.datahandle.PurDataHandleArgs;
import kd.scm.common.helper.datahandle.TaskStatusEnum;
import kd.scm.pbd.business.PurDataHandleServiceHelper;

public class PdbDataHandleTaskRunningEdit
extends AbstractFormPlugin
implements ProgresssListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar progressBar = (ProgressBar)this.getView().getControl("progressbarap");
        progressBar.addProgressListener((ProgresssListener)this);
    }

    public void onProgress(ProgressEvent e) {
        PurDataHandleArgs args = this.getArgs();
        DynamicObject[] resultObjs = this.getResultObj(args);
        if (resultObjs != null && resultObjs.length > 0) {
            String status = resultObjs[0].getString("status");
            this.initSubTaskEntry();
            if (status.equals(TaskStatusEnum.TASK_FAIL.getValue()) || status.equals(TaskStatusEnum.TASK_SUCCESS.getValue())) {
                this.stopBar();
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"progressbarap"});
        this.initArgs();
        this.initSubTaskEntry();
        this.startBar();
    }

    private DynamicObject[] getResultObj(PurDataHandleArgs args) {
        String sourceBillId = args.getSourceBillId();
        String sourceBillType = args.getSourceBillType();
        QFilter qf = new QFilter("sourcebillid", "=", (Object)sourceBillId);
        if (StringUtils.isNotBlank((CharSequence)sourceBillType)) {
            qf.and("sourcebilltype", "=", (Object)sourceBillType);
        }
        if (StringUtils.isNotBlank((CharSequence)sourceBillId)) {
            return BusinessDataServiceHelper.load((String)"pbd_schandleresult", (String)"id,status,context,entryentity.subtask,entryentity.substatus,entryentity.detail", (QFilter[])new QFilter[]{qf}, (String)"createtime desc", (int)1);
        }
        return null;
    }

    private void initArgs() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        this.getView().getPageCache().put("abstractdatahandleargs", Parser.toString(customParams.get("abstractdatahandleargs")));
    }

    private PurDataHandleArgs getArgs() {
        PurDataHandleArgs args = (PurDataHandleArgs)SerializationUtils.fromJsonString((String)Parser.toString((Object)this.getView().getPageCache().get("abstractdatahandleargs")), PurDataHandleArgs.class);
        return args;
    }

    private void initSubTaskEntry() {
        PurDataHandleArgs args = this.getArgs();
        DynamicObject[] resultObjs = this.getResultObj(args);
        if (resultObjs != null && resultObjs.length > 0) {
            DynamicObject resultObj = resultObjs[0];
            this.getView().getPageCache().put("resultid", resultObj.getPkValue().toString());
            String status = resultObj.getString("status");
            DynamicObject pbd_schandleresult = QueryServiceHelper.queryOne((String)"pbd_schandleresult", (String)"id,entryentity.subtask.canskip", (QFilter[])new QFilter[]{new QFilter("id", "=", resultObj.getPkValue()).and("entryentity.substatus", "=", (Object)"3")});
            boolean canskip = false;
            if (pbd_schandleresult != null) {
                canskip = pbd_schandleresult.getBoolean("entryentity.subtask.canskip");
            }
            this.updateBtVisible(status, canskip);
            DynamicObjectCollection entryEntity = resultObj.getDynamicObjectCollection("entryentity");
            DynamicObjectCollection curRunningEntryEntity = this.getModel().getEntryEntity("entryentity");
            Iterator iterator = entryEntity.iterator();
            while (iterator.hasNext()) {
                DynamicObject next = (DynamicObject)iterator.next();
                boolean isdisplay = next.getBoolean("subtask.isdisplay");
                if (isdisplay) continue;
                iterator.remove();
            }
            while (entryEntity.size() != curRunningEntryEntity.size()) {
                curRunningEntryEntity.addNew();
            }
            for (int i = 0; i < entryEntity.size(); ++i) {
                DynamicObject entryRow = (DynamicObject)entryEntity.get(i);
                DynamicObject subtask = entryRow.getDynamicObject("subtask");
                String substatus = entryRow.getString("substatus");
                String detail = entryRow.getString("detail");
                this.getModel().setValue("subtask", (Object)subtask, i);
                this.getModel().setValue("substatus", (Object)substatus, i);
                this.getModel().setValue("detail", (Object)detail, i);
            }
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_retry", "bar_skip", "bar_close"});
            Long taskConfigId = args.getTaskConfigId();
            if (taskConfigId == null || taskConfigId.equals(0L)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6e90\u5355\u4e0d\u5b58\u5728\u76f8\u5e94\u4e1a\u52a1\u7684\u4efb\u52a1\u8bb0\u5f55\u3002", (String)"PdbDataHandleTaskRunningEdit_2", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_retry", "bar_skip", "bar_back"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"bar_close"});
                this.getModel().getEntryEntity("entryentity").clear();
                this.getView().updateView("entryentity");
                return;
            }
            DynamicObject config = BusinessDataServiceHelper.loadSingle((Object)taskConfigId, (String)"pbd_srmdatasetting");
            if (null != config) {
                DynamicObjectCollection col = config.getDynamicObjectCollection("entryentity");
                col.sort((Comparator)new Comparator<DynamicObject>(){

                    @Override
                    public int compare(DynamicObject o1, DynamicObject o2) {
                        return o1.getInt("subsort") - o2.getInt("subsort");
                    }
                });
                DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
                entryentity.clear();
                for (DynamicObject entry : col) {
                    boolean valid = entry.getBoolean("valid");
                    String className = entry.getString("task.classname");
                    boolean isdisplay = entry.getBoolean("task.isdisplay");
                    if (!valid || StringUtils.isBlank((CharSequence)className) || !isdisplay) continue;
                    DynamicObject entryRow = entryentity.addNew();
                    entryRow.set("subtask", entry.get("task"));
                    entryRow.set("substatus", (Object)"1");
                }
            }
        }
        this.getView().updateView("entryentity");
    }

    private void updateSubTaskEntry() {
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
        for (DynamicObject entryRow : entryentity) {
            String substatus = entryRow.getString("substatus");
            if (!substatus.equals(TaskStatusEnum.TASK_FAIL.getValue())) continue;
            entryRow.set("substatus", (Object)TaskStatusEnum.TASK_DOING.getValue());
            break;
        }
        this.getView().updateView("entryentity");
    }

    private void updateResult(Long resultId) {
        DynamicObject pbd_schandleresult = BusinessDataServiceHelper.loadSingle((String)"pbd_schandleresult", (String)"entryentity,entryentity.substatus", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)resultId)});
        if (pbd_schandleresult == null) {
            return;
        }
        DynamicObjectCollection entryentity = pbd_schandleresult.getDynamicObjectCollection("entryentity");
        int index = 1;
        for (DynamicObject entryRow : entryentity) {
            String substatus = entryRow.getString("substatus");
            if (substatus.equals(TaskStatusEnum.TASK_FAIL.getValue())) {
                entryRow.set("substatus", (Object)"5");
                if (index >= entryentity.size()) break;
                ((DynamicObject)entryentity.get(index)).set("substatus", (Object)TaskStatusEnum.TASK_DOING.getValue());
                break;
            }
            ++index;
        }
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{pbd_schandleresult});
    }

    private void updateSubTaskSkipEntry() {
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
        int index = 1;
        for (DynamicObject entryRow : entryentity) {
            String substatus = entryRow.getString("substatus");
            if (substatus.equals(TaskStatusEnum.TASK_FAIL.getValue())) {
                entryRow.set("substatus", (Object)"5");
                if (index >= entryentity.size()) break;
                ((DynamicObject)entryentity.get(index)).set("substatus", (Object)TaskStatusEnum.TASK_DOING.getValue());
                break;
            }
            ++index;
        }
        this.getView().updateView("entryentity");
    }

    private void updateBtVisible(String status, boolean canskip) {
        if (status.equals(TaskStatusEnum.TASK_SUCCESS.getValue())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_retry", "bar_skip", "bar_back"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"bar_close"});
        } else if (status.equals(TaskStatusEnum.TASK_FAIL.getValue())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_back"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"bar_retry", "bar_close"});
            this.getView().setVisible(Boolean.valueOf(canskip), new String[]{"bar_skip"});
        } else if (status.equals(TaskStatusEnum.TASK_DOING.getValue())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_retry", "bar_skip", "bar_close"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"bar_back"});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (operateKey.equals("retry")) {
            String resultStrId = this.getView().getPageCache().get("resultid");
            Long resultId = Long.parseLong(resultStrId);
            if (resultId != null && resultId != 0L) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_retry", "bar_skip", "bar_close"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"bar_back"});
                PurDataHandleServiceHelper.retryPurDataHandle((Long)resultId);
                this.updateSubTaskEntry();
                this.startBar();
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u6267\u884c\u7ed3\u679c\u5355\u3002", (String)"PdbDataHandleTaskRunningEdit_1", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
            }
        } else if (operateKey.equals("skip")) {
            String resultStrId = this.getView().getPageCache().get("resultid");
            Long resultId = Long.parseLong(resultStrId);
            if (resultId != null && resultId != 0L) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_retry", "bar_close", "bar_skip"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"bar_back"});
                PurDataHandleServiceHelper.skipPurDataHandle((Long)resultId);
                this.updateResult(resultId);
                this.updateSubTaskSkipEntry();
                this.startBar();
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u6267\u884c\u7ed3\u679c\u5355\u3002", (String)"PdbDataHandleTaskRunningEdit_1", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void startBar() {
        ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
        bar.start();
    }

    private void stopBar() {
        ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
        bar.stop();
    }
}

