/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.formplugin.edit;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.IFormView;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.metadata.treebuilder.FilterFieldBuildOption;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.scm.common.util.MetaDataUtil;

public class SrmControlSchemeEditPlugIn
extends AbstractBillPlugIn {
    public void afterBindData(EventObject e) {
        this.setBillOprationItemsandFilter(false);
        this.setFilterGridvalue();
        super.afterBindData(e);
    }

    private void setBillOprationItemsandFilter(boolean ischange) {
        DynamicObject data = this.getModel().getDataEntity(true);
        DynamicObject billentity = data.getDynamicObject("billentity");
        if (null == billentity || billentity.getDynamicObject("billentity") == null) {
            return;
        }
        String entityName = billentity.getDynamicObject("billentity").getString("number");
        this.setOpertionCombListValue(entityName, "operationfield");
        this.setFilterGrid(entityName);
    }

    private void setFilterGrid(String entityNumber) {
        if (StringUtils.isNotBlank((CharSequence)entityNumber)) {
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            FilterFieldBuildOption option = new FilterFieldBuildOption();
            List cols = FormTreeBuilder.buildFilterColumns((MainEntityType)entityType, (FilterFieldBuildOption)option);
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergrid");
            this.clearFilterGrid();
            filterGrid.setEntityNumber(entityNumber);
            filterGrid.setFilterColumns(cols);
            this.getView().updateView("filtergrid");
        }
    }

    private void clearFilterGrid() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergrid");
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        FilterCondition condition = filterGridState.getFilterCondition();
        condition.getFilterRow().clear();
        filterGrid.SetValue(condition);
        filterGrid.getFieldColumns().clear();
        filterGrid.getFilterFieldKeys().clear();
    }

    private void setFilterGridvalue() {
        Object filterObj = this.getModel().getValue("filtergridtext_tag");
        FilterCondition filterCondition = null;
        if (!StringUtils.isBlank((Object)filterObj)) {
            filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterObj.toString(), FilterCondition.class);
        }
        if (filterCondition != null) {
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergrid");
            filterGrid.SetValue(filterCondition);
        }
    }

    public void setOpertionCombListValue(String entityName, String controlName) {
        ComboEdit fieldsCombo;
        IFormView view = this.getView();
        List combList = MetaDataUtil.getOpreateComboItemList((String)entityName);
        if (null != combList && combList.size() != 0 && null != (fieldsCombo = (ComboEdit)view.getControl(controlName))) {
            fieldsCombo.setComboItems(combList);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        ChangeData[] changedData = e.getChangeSet();
        Object newValue = changedData[0].getNewValue();
        if ("billentity".equals(propertyName)) {
            this.getModel().setValue("operationfield", null);
            if (null == newValue) {
                this.clearFilterGrid();
                return;
            }
            this.setBillOprationItemsandFilter(true);
        }
    }

    public void setCombListValue(String entityName, String controlName) {
        ComboEdit fieldsCombo;
        List combList;
        IFormView view = this.getView();
        Map propetiesMap = MetaDataUtil.getProMap((String)entityName, (boolean)true);
        if (null != propetiesMap && propetiesMap.size() != 0 && null != (combList = MetaDataUtil.buildPropComboItems((Map)propetiesMap)) && combList.size() != 0 && null != (fieldsCombo = (ComboEdit)view.getControl(controlName))) {
            fieldsCombo.setComboItems(combList);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        FormOperate oprate = (FormOperate)evt.getSource();
        String operationKey = oprate.getOperateKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)"save", (CharSequence)operationKey) || StringUtils.equalsIgnoreCase((CharSequence)"submit", (CharSequence)operationKey)) {
            FilterCondition filterCondition = this.getFilter();
            this.saveFilterToText(filterCondition);
        }
        super.beforeDoOperation(evt);
    }

    private FilterCondition getFilter() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergrid");
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        FilterCondition condition = filterGridState.getFilterCondition();
        return condition;
    }

    private String saveFilterToText(FilterCondition filterCondition) {
        String filter = null;
        if (filterCondition != null) {
            filter = SerializationUtils.toJsonString((Object)filterCondition);
        }
        this.getModel().setValue("filtergridtext_tag", (Object)filter);
        return filter;
    }
}

