/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.formplugin.multijoint;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.IBillView;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.OperationTypeCache;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.ISVServiceHelper;

public final class PbdDataExecuteSchemeEdit
extends AbstractBillPlugIn {
    private static final String ENTRYENTITY = "entryentity";
    private static final String SERVICECONFIGACTION = "serviceconfigaction";
    private String[] lockFileds = new String[]{"number", "entity", "executescene", "executechannel", "executetype", "preset", "operatekey", "executeinterface"};
    private String[] lockEntryFileds = new String[]{"executeservice", "executeserviceconfig", "executeplugin"};

    public void registerListener(EventObject e) {
        TextEdit executeplugin;
        super.registerListener(e);
        TextEdit serviceconfig = (TextEdit)this.getControl("executeserviceconfig");
        if (serviceconfig != null) {
            serviceconfig.addClickListener((ClickListener)this);
        }
        if ((executeplugin = (TextEdit)this.getControl("executeplugin")) != null) {
            executeplugin.addClickListener((ClickListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initOperate(true);
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.initOperate(true);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        boolean isPreSet = this.getModel().getDataEntity().getBoolean("preset");
        if (isPreSet && !ISVServiceHelper.isKingdeeISV()) {
            ((IBillView)this.getView()).setBillStatus(BillOperationStatus.EDIT);
            this.setIsvViewEnable(false);
        } else {
            ((IBillView)this.getView()).setBillStatus(BillOperationStatus.ADDNEW);
            this.setIsvViewEnable(true);
        }
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String executeType = dataEntity.getString("executetype");
        this.setMustInput(executeType.equalsIgnoreCase("operateevent"));
        this.setViewEnable(executeType.equalsIgnoreCase("operateevent"));
    }

    private void setIsvViewEnable(boolean viewEnable) {
        this.getView().setEnable(Boolean.valueOf(viewEnable), this.lockFileds);
        int rowCount = this.getModel().getEntryRowCount(ENTRYENTITY);
        for (int index = 0; index < rowCount; ++index) {
            this.getView().setEnable(Boolean.valueOf(viewEnable), index, this.lockEntryFileds);
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        TextEdit evtSource;
        String key;
        super.beforeClick(evt);
        if (evt.getSource() instanceof TextEdit && StringUtils.equals((CharSequence)(key = (evtSource = (TextEdit)evt.getSource()).getKey()), (CharSequence)"executeserviceconfig")) {
            String entityName;
            StringBuilder checkMessage = new StringBuilder();
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObject executeservice = dataEntity.getDynamicObject("executeservice");
            DynamicObject executechannel = dataEntity.getDynamicObject("executechannel");
            DynamicObject executescene = dataEntity.getDynamicObject("executescene");
            DynamicObject entity = dataEntity.getDynamicObject("entity");
            if (entity == null) {
                entityName = this.getModel().getProperty("entity").getDisplayName().getLocaleValue();
                checkMessage.append('\u3010').append(entityName).append('\u3011').append(ResManager.loadKDString((String)"\u672a\u5f55\u5165\u3002", (String)"PbdDataExecuteSchemeEdit_0", (String)"scm-pbd-formplugin", (Object[])new Object[0])).append('\n');
            }
            if (executechannel == null) {
                String executechannelName = this.getModel().getProperty("executechannel").getDisplayName().getLocaleValue();
                checkMessage.append('\u3010').append(executechannelName).append('\u3011').append(ResManager.loadKDString((String)"\u672a\u5f55\u5165\u3002", (String)"PbdDataExecuteSchemeEdit_0", (String)"scm-pbd-formplugin", (Object[])new Object[0])).append('\n');
            }
            if (executeservice == null) {
                entityName = this.getModel().getProperty("entity").getDisplayName().getLocaleValue();
                checkMessage.append('\u3010').append(entityName).append('\u3011').append(ResManager.loadKDString((String)"\u672a\u5f55\u5165\u3002", (String)"PbdDataExecuteSchemeEdit_0", (String)"scm-pbd-formplugin", (Object[])new Object[0])).append('\n');
            }
            if (executescene == null) {
                String executeSceneName = this.getModel().getProperty("executescene").getDisplayName().getLocaleValue();
                checkMessage.append('\u3010').append(executeSceneName).append('\u3011').append(ResManager.loadKDString((String)"\u672a\u5f55\u5165\u3002", (String)"PbdDataExecuteSchemeEdit_0", (String)"scm-pbd-formplugin", (Object[])new Object[0])).append('\n');
            }
            if (checkMessage.length() > 0) {
                this.getView().showTipNotification(checkMessage.toString());
            }
        }
    }

    public void click(EventObject evt) {
        TextEdit evtSource;
        String key;
        super.click(evt);
        if (evt.getSource() instanceof TextEdit && StringUtils.equals((CharSequence)(key = (evtSource = (TextEdit)evt.getSource()).getKey()), (CharSequence)"executeserviceconfig")) {
            DynamicObject entity;
            int currentRowIndex = evtSource.getModel().getEntryCurrentRowIndex(evtSource.getEntryKey());
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObject rowData = this.getModel().getEntryRowEntity(evtSource.getEntryKey(), currentRowIndex);
            DynamicObject executeservice = dataEntity.getDynamicObject("executeservice");
            DynamicObject executescene = dataEntity.getDynamicObject("executescene");
            String serviceconfig = rowData.getString("executeserviceconfig");
            DynamicObject executechannel = dataEntity.getDynamicObject("executechannel");
            HashMap<String, Object> customMap = new HashMap<String, Object>();
            if (executechannel != null) {
                customMap.put("executechannel", executechannel.getString("id"));
            }
            if ((entity = dataEntity.getDynamicObject("entity")) != null) {
                customMap.put("entity", entity.getString("id"));
            }
            if (executescene != null) {
                customMap.put("scene", executescene.getString("id"));
                DynamicObject sceneEntity = executescene.getDynamicObject("entity");
                if (sceneEntity != null) {
                    customMap.put("sceneentity", sceneEntity.getString("id"));
                }
            }
            if (executeservice != null) {
                DynamicObject configform = executeservice.getDynamicObject("configform");
                String number = configform.getString("number");
                if (serviceconfig != null && !serviceconfig.trim().isEmpty()) {
                    customMap.put("serviceconfigstring", serviceconfig);
                }
                this.showParam(number, customMap);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        super.propertyChanged(e);
        switch (name = e.getProperty().getName()) {
            case "entity": {
                this.initOperate(false);
                break;
            }
            case "executetype": {
                this.setMustInput("operateevent".equals(e.getChangeSet()[0].getNewValue().toString()));
                this.setViewEnable("operateevent".equals(e.getChangeSet()[0].getNewValue().toString()));
                break;
            }
            case "executescene": {
                break;
            }
            case "executechannel": {
                break;
            }
        }
    }

    private void showParam(String formId, Map<String, Object> customMap) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(formId);
        formShowParameter.setCustomParams(customMap);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("960px");
        styleCss.setHeight("780px");
        formShowParameter.getOpenStyle().setInlineStyleCss(styleCss);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, SERVICECONFIGACTION));
        this.getView().showForm(formShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (SERVICECONFIGACTION.equals(actionId) && (returnData = closedCallBackEvent.getReturnData()) != null && !returnData.toString().isEmpty()) {
            int currentRowIndex = this.getModel().getEntryCurrentRowIndex(ENTRYENTITY);
            this.getModel().setValue("executeserviceconfig", returnData, currentRowIndex);
        }
    }

    private void setMustInput(boolean isMust) {
        FieldEdit executeinterface;
        FieldEdit operatekey = (FieldEdit)this.getView().getControl("operatekey");
        if (operatekey != null) {
            operatekey.setMustInput(isMust);
        }
        if ((executeinterface = (FieldEdit)this.getView().getControl("executeinterface")) != null) {
            executeinterface.setMustInput(isMust);
        }
    }

    private void setViewEnable(boolean viewEnable) {
        this.getView().setVisible(Boolean.valueOf(viewEnable), new String[]{"operatekey", "executeinterface"});
    }

    private void initOperate(boolean isInit) {
        ComboEdit operatekey = (ComboEdit)this.getView().getControl("operatekey");
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
        DynamicObject entity = this.getModel().getDataEntity().getDynamicObject("entity");
        ComboItem operate = null;
        if (entity != null) {
            List ops = EntityMetadataCache.getDataEntityOperate((String)entity.getString("number"));
            for (Map op : ops) {
                String opTypeId = (String)op.get("type");
                if (!OperationTypeCache.isEntityOperation((String)opTypeId)) continue;
                String opKey = (String)op.get("key");
                Map mapLocaleString = (Map)op.get("name");
                String opName = opKey;
                if (mapLocaleString != null) {
                    opName = LocaleString.fromMap((Map)mapLocaleString).toString() + "(" + opKey + ")";
                }
                operate = new ComboItem(new LocaleString(opName), opKey);
                comboItems.add(operate);
            }
        }
        operatekey.setComboItems(comboItems);
    }
}

