/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.formplugin.splitrow;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.form.BillFormAp;
import kd.bos.metadata.form.ContainerAp;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.BarItemAp;
import kd.bos.metadata.form.control.ButtonAp;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldGroupAp;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.splitrow.AbstractSplitRowParamServiceImplPlugin;
import kd.scm.common.splitrow.ISplitRowParamService;

public class PbdSplitRowEditPlugin
extends AbstractBillPlugIn {
    private static final String BILLKEY = "billkey";
    private static final String ENTRYKEY = "entrykey";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String RELATION_CONFIG = "relationconfig";
    private static final String MATERIAL_ENTRY = "materialentry";

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        if (!BILLKEY.equals(propertyName) && !ENTRYKEY.equals(propertyName)) {
            return;
        }
        IDataModel model = this.getModel();
        Object billkey = model.getValue(BILLKEY);
        if (billkey == null || billkey.toString().trim().equals("")) {
            return;
        }
        FormMetadata formmeta = PbdSplitRowEditPlugin.getFormMetaData(billkey.toString());
        if (formmeta == null) {
            this.clear(model);
            return;
        }
        List<ControlAp<?>> entry = null;
        String proEntryKey = null;
        switch (propertyName) {
            case "billkey": {
                this.clear(model);
                String entryKey = PbdSplitRowEditPlugin.getEntitykey(formmeta, null);
                if (StringUtils.isBlank((CharSequence)entryKey)) break;
                model.setValue(BILLKEY, (Object)billkey.toString());
                model.setValue(ENTRYKEY, (Object)entryKey);
                model.setValue(RELATION_CONFIG, (Object)entryKey);
                break;
            }
            case "entrykey": {
                Object entryKeyVal = model.getValue(ENTRYKEY);
                if (entryKeyVal == null || entryKeyVal.toString().trim().equals("")) break;
                model.setValue(ENTRYKEY, entryKeyVal);
                model.setValue(RELATION_CONFIG, entryKeyVal);
                model.deleteEntryData(ENTRY_ENTITY);
                proEntryKey = entryKeyVal == null || StringUtils.isBlank((CharSequence)entryKeyVal.toString()) ? MATERIAL_ENTRY : entryKeyVal.toString();
                entry = PbdSplitRowEditPlugin.getProEntitykey(formmeta, proEntryKey);
            }
        }
        if (entry == null) {
            return;
        }
        Map<String, String> proItemMap = this.getProItemMap(proEntryKey, entry);
        this.addEntryData(proItemMap, ENTRY_ENTITY);
    }

    private void clear(IDataModel model) {
        model.setValue(ENTRYKEY, (Object)"");
        model.deleteEntryData(ENTRY_ENTITY);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        String operateKey;
        super.beforeDoOperation(evt);
        switch (operateKey = ((AbstractOperate)evt.getSource()).getOperateKey()) {
            case "save": 
            case "submit": 
            case "audit": {
                String pluginName = (String)this.getModel().getValue("pluginname");
                String billKey = (String)this.getModel().getValue(BILLKEY);
                String entrykey = (String)this.getModel().getValue(ENTRYKEY);
                try {
                    this.validate(pluginName, billKey, entrykey);
                }
                catch (Exception e1) {
                    this.getModel().setValue("pluginname", (Object)pluginName);
                    this.getView().showErrorNotification(e1.getMessage());
                    evt.setCancel(true);
                }
                break;
            }
        }
    }

    private void validate(String pluginName, String billKey, String entryKey) {
        if (StringUtils.isBlank((CharSequence)billKey)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5355\u636e\u6807\u8bc6\u3002", (String)"PbdSplitRowEditPlugin_1", (String)"scm-pbd-formplugin", (Object[])new Object[0]), new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)entryKey)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5206\u5f55\u6807\u8bc6\u3002", (String)"PbdSplitRowEditPlugin_2", (String)"scm-pbd-formplugin", (Object[])new Object[0]), new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)pluginName)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u63d2\u4ef6\u540d\u79f0\u3002", (String)"PbdSplitRowEditPlugin_3", (String)"scm-pbd-formplugin", (Object[])new Object[0]), new Object[0]));
        }
        String selectFields = "billno,billstatus,billkey,entrykey,relationconfig,pluginname,entryentity.currentmetadata,entryentity.currentmetadatakey,entryentity.copyrow,entryentity.splitrow,entryentity.defaultrow,entryentity.defaultvalue";
        String PBDSPLITROW = "pbd_splitrow";
        QFilter prodfilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal());
        prodfilter.and(new QFilter(ENTRYKEY, "=", (Object)entryKey));
        prodfilter.and(new QFilter(BILLKEY, "=", (Object)billKey));
        DynamicObject[] destArray = BusinessDataServiceHelper.load((String)PBDSPLITROW, (String)selectFields, (QFilter[])new QFilter[]{prodfilter});
        if (destArray.length > 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5b58\u5728\u5df2\u5ba1\u6838\u5355\u636e\u6807\u8bc6\u548c\u5206\u5f55\u6807\u8bc6\uff0c\u5982\u679c\u9700\u8981\u4fee\u6539\u8bf7\u5148\u7981\u7528\u539f\u5355\u636e\u3002", (String)"PbdSplitRowEditPlugin_4", (String)"scm-pbd-formplugin", (Object[])new Object[0]), new Object[0]));
        }
        Class<?> pluginClass = null;
        try {
            pluginClass = Class.forName(pluginName);
        }
        catch (ClassNotFoundException e) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u63d2\u4ef6\u201c%1$s\u201d\u4e0d\u5b58\u5728\u6216\u8005\u8be5\u63d2\u4ef6\u6ca1\u6709\u5b9e\u73b0\u63a5\u53e3\u201c%2$s\u201d\u3002", (String)"PbdSplitRowEditPlugin_8", (String)"scm-pbd-formplugin", (Object[])new Object[0]), pluginName, "kd.scm.common.splitrow.ISplitRowParamService"));
        }
        ISplitRowParamService calQtyPlugin = null;
        try {
            calQtyPlugin = (ISplitRowParamService)pluginClass.newInstance();
        }
        catch (Exception e) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u63d2\u4ef6\u201c%1$s\u201d\u4e0d\u5b58\u5728\u6216\u8005\u8be5\u63d2\u4ef6\u6ca1\u6709\u5b9e\u73b0\u63a5\u53e3\u201c%2$s\u201d\u3002", (String)"PbdSplitRowEditPlugin_8", (String)"scm-pbd-formplugin", (Object[])new Object[0]), pluginName, "kd.scm.common.splitrow.ISplitRowParamService"));
        }
        FormMetadata formMetaData = PbdSplitRowEditPlugin.getFormMetaData(billKey);
        if (formMetaData == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u91d1\u8776\u5f00\u53d1\u5546\u6807\u8bc6\u83b7\u53d6\u5f02\u5e38\u3002", (String)"PbdSplitRowEditPlugin_6", (String)"scm-pbd-formplugin", (Object[])new Object[0]), new Object[0]));
        }
        String isv = formMetaData.getIsv();
        if ("kingdee".equals(isv) && !(calQtyPlugin instanceof AbstractSplitRowParamServiceImplPlugin)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u91d1\u8776\u5f00\u53d1\u5546\u6807\u8bc6:\u63d2\u4ef6\u201c%1$s\u201d\u5fc5\u987b\u7ee7\u627f\u63d2\u4ef6\u201c%2$s\u201d\u3002", (String)"PbdSplitRowEditPlugin_9", (String)"scm-pbd-formplugin", (Object[])new Object[0]), pluginName, "kd.scm.common.splitrow.AbstractSplitRowParamServiceImplPlugin"));
        }
    }

    public void addEntryData(Map<String, String> objectMap, String entryEntry) {
        this.getModel().beginInit();
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        int rowCount = 0;
        for (Map.Entry<String, String> entry : objectMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            vs.set("currentmetadatakey", (Object)key, rowCount);
            vs.set("currentmetadata", (Object)value, rowCount);
            boolean copyrowFlag = true;
            vs.set("copyrow", (Object)copyrowFlag, rowCount);
            ++rowCount;
        }
        model.batchCreateNewEntryRow(entryEntry, vs);
        this.getView().updateView(entryEntry);
        this.getModel().endInit();
    }

    public static String getEntitykey(FormMetadata formmeta, String entryKey) {
        for (ControlAp ap : formmeta.getItems()) {
            if (!(ap instanceof EntryAp)) continue;
            EntryAp entryAp = (EntryAp)ap;
            String proEntitykey = entryAp.getKey();
            if (StringUtils.isEmpty((CharSequence)entryKey)) {
                entryKey = MATERIAL_ENTRY;
                return entryKey;
            }
            if (entryKey == null || !entryKey.equals(proEntitykey)) continue;
            return entryKey;
        }
        return null;
    }

    public static List<ControlAp<?>> getProEntitykey(FormMetadata formmeta, String entryKey) {
        for (ControlAp ap : formmeta.getItems()) {
            EntryAp entryAp;
            String proEntitykey;
            if (!(ap instanceof EntryAp) || !entryKey.equals(proEntitykey = (entryAp = (EntryAp)ap).getKey())) continue;
            return entryAp.getItems();
        }
        return null;
    }

    public Map<String, String> getProItemMap(String entityKey, List<ControlAp<?>> items) {
        LinkedHashMap<String, String> proControlMap = new LinkedHashMap<String, String>(8);
        if (!CollectionUtils.isEmpty(items)) {
            for (ControlAp<?> ap : items) {
                if (ap instanceof EntryFieldGroupAp) {
                    EntryFieldGroupAp groupAp = (EntryFieldGroupAp)ap;
                    List items2 = groupAp.getItems();
                    Map<String, String> proItemMap = this.getProItemMap(entityKey, items2);
                    proControlMap.putAll(proItemMap);
                }
                if (ap instanceof BillFormAp || ap instanceof ContainerAp || ap instanceof ButtonAp || ap instanceof BarItemAp) continue;
                String proKey = ap.getKey();
                proControlMap.put(proKey, ap.getName().getLocaleValue());
            }
        }
        return proControlMap;
    }

    public static FormMetadata getFormMetaData(String entityKey) {
        String entityId = MetadataDao.getIdByNumber((String)entityKey, (MetaCategory)MetaCategory.Entity);
        if (StringUtils.isBlank((CharSequence)entityId)) {
            return null;
        }
        FormMetadata formmeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Form);
        if (formmeta == null) {
            return null;
        }
        EntityMetadata entitymeta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
        if (entitymeta == null) {
            return null;
        }
        formmeta.bindEntityMetadata(entitymeta);
        return formmeta;
    }
}

