/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.formplugin.task;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.logorm.LogORM;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.common.util.DateUtil;

public class ScDataHandleLogCleanTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(ScDataHandleLogCleanTask.class);

    public void execute(RequestContext request, Map<String, Object> params) throws KDException {
        log.info("kd.scm.common.helper.scdatahandle.task.ScDataHandleTask execute begin ---------");
        Date now = TimeServiceHelper.now();
        Object successduring = params.get("successduring");
        Object faillogduring = params.get("faillogduring");
        Object exceptionduring = params.get("exceptionduring");
        Integer successCount = 20;
        Integer failCount = 22;
        Integer exceptionCount = 77;
        try {
            if (successduring != null) {
                successCount = Math.max(successCount, Integer.parseInt(String.valueOf(successduring)));
                log.info("successduring:{}", successduring);
            }
            if (faillogduring != null) {
                failCount = Math.max(failCount, Integer.parseInt(String.valueOf(faillogduring)));
                log.info("faillogduring:{}", faillogduring);
            }
            if (exceptionduring != null) {
                exceptionCount = Math.max(exceptionCount, Integer.parseInt(String.valueOf(exceptionduring)));
                log.info("exceptionduring:{}", exceptionduring);
            }
        }
        catch (Exception e) {
            successCount = 20;
            failCount = 22;
            exceptionCount = 77;
        }
        log.info("successCount:{},failCount:{},exceptionCount:{}", new Object[]{successCount, failCount, exceptionCount});
        LocalDate localDate = now.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        ArrayList<String> failPKIds = new ArrayList<String>(10240);
        LocalDate fail = localDate.minusDays(failCount.intValue());
        LocalDate success = localDate.minusDays(successCount.intValue());
        LocalDate exception = localDate.minusDays(exceptionCount.intValue());
        LocalDateTime faillocalDateTime = fail.atTime(23, 59, 59);
        LocalDateTime successlocalDateTime = success.atTime(23, 59, 59);
        LocalDateTime exceptionlocalDateTime = exception.atTime(23, 59, 59);
        Date failDate = Date.from(faillocalDateTime.atZone(ZoneId.systemDefault()).toInstant());
        Date successDate = Date.from(successlocalDateTime.atZone(ZoneId.systemDefault()).toInstant());
        Date exceptionDate = Date.from(exceptionlocalDateTime.atZone(ZoneId.systemDefault()).toInstant());
        log.info("failDate:{},successDate:{},exceptionDate:{}", new Object[]{DateUtil.date2str((Date)failDate, null), DateUtil.date2str((Date)successDate, null), DateUtil.date2str((Date)exceptionDate, null)});
        QFilter stateQfilter = new QFilter("state", "=", (Object)"success");
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)request.getTraceId(), (String)"pbd_scdatahandlefail", (String)"id,createtime", (QFilter[])new QFilter[]{stateQfilter}, (String)"id");){
            while (dataSet.hasNext()) {
                Row row2 = dataSet.next();
                String scDataLogId = row2.getString("id");
                Date createtime = row2.getDate("createtime");
                if (createtime == null || !createtime.before(failDate)) continue;
                failPKIds.add(scDataLogId);
            }
        }
        if (!failPKIds.isEmpty()) {
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"delete", (String)"pbd_scdatahandlefail", (Object[])failPKIds.toArray(), (OperateOption)OperateOption.create());
            if (!(operationResult == null || operationResult.isSuccess() && operationResult.getSuccessPkIds().size() > 0)) {
                StringBuilder message = new StringBuilder();
                message.append(operationResult.getMessage());
                operationResult.getAllErrorOrValidateInfo().forEach(row -> message.append("Title").append(row.getTitle()).append("Message:").append(row.getMessage()).append("\t\n"));
                log.warn(message.toString());
            }
            if (operationResult != null && operationResult.getSuccessPkIds().size() > 0) {
                log.info("\u672c\u6b21\u5904\u7406\u6570\u636e:SuccessPkIds" + operationResult.getSuccessPkIds() + "BillNos:" + operationResult.getBillNos());
            }
        }
        var23_24 = null;
        try (TXHandle txHandle = TX.requiresNew();){
            QFilter failIdQfilter = new QFilter("datahandlefailid", "in", failPKIds).or(new QFilter("datahandlefailid", "=", (Object)" ").and(new QFilter("logdim", "!=", (Object)"storeexception").and(new QFilter("opdate", "<=", (Object)successDate)).or(new QFilter("opdate", "<=", (Object)exceptionDate).and(new QFilter("logdim", "=", (Object)"storeexception")))));
            LogORM logORM = LogORM.create();
            logORM.delete("pbd_scdatahandlelog", new QFilter[]{failIdQfilter});
        }
        catch (Throwable throwable) {
            var23_24 = throwable;
            throw throwable;
        }
        log.info("kd.scm.common.helper.scdatahandle.task.ScDataHandleTask execute end ----------");
    }
}

