/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.formplugin.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.field.ComboItem;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.LargeTextField;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.BillFormAp;
import kd.bos.metadata.form.ContainerAp;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.container.FieldsetPanelAp;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.BarItemAp;
import kd.bos.metadata.form.control.ButtonAp;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.metadata.form.control.VectorAp;
import kd.bos.metadata.treebuilder.EntityFieldTreeBuildOption;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.orm.util.CollectionUtils;
import kd.scm.pbd.common.entity.FieldProp;
import kd.scm.pbd.common.utils.FieldTypeUtil;

public class MetadataUtils {
    private static final String BILL = "bill";

    public static Map<String, List<ControlAp<?>>> getProEntitykey(FormMetadata formmeta, List<String> entryKey) {
        HashMap map = new HashMap(8);
        for (ControlAp ap : formmeta.getItems()) {
            EntryAp entryAp;
            String proEntitykey;
            if (!(ap instanceof EntryAp) || !entryKey.contains(proEntitykey = (entryAp = (EntryAp)ap).getKey())) continue;
            map.put(proEntitykey, entryAp.getItems());
        }
        if (entryKey.contains(BILL)) {
            ArrayList<ControlAp> list = new ArrayList<ControlAp>(8);
            for (ControlAp ap : formmeta.getItems()) {
                if (!(ap instanceof FieldAp) || ap instanceof EntryFieldAp) continue;
                list.add(ap);
            }
            map.put(BILL, list);
        }
        return map;
    }

    public static Map<String, List<ControlAp<?>>> getFieldSetPanelAp(FormMetadata formmeta, String fieldSetPanelAp) {
        HashMap map = new HashMap(8);
        for (ControlAp ap : formmeta.getItems()) {
            FieldsetPanelAp entryAp;
            String proEntitykey;
            if (!(ap instanceof FieldsetPanelAp) || !fieldSetPanelAp.equals(proEntitykey = (entryAp = (FieldsetPanelAp)ap).getKey())) continue;
            map.put(BILL, entryAp.getItems());
        }
        return map;
    }

    public static List<FieldProp> getProItemMap(Map<String, List<ControlAp<?>>> map) {
        ArrayList<FieldProp> list = new ArrayList<FieldProp>(8);
        for (Map.Entry<String, List<ControlAp<?>>> entry : map.entrySet()) {
            List<ControlAp<?>> items = entry.getValue();
            String entryKey = entry.getKey();
            for (ControlAp<?> ap : items) {
                if (!(ap instanceof FieldAp)) continue;
                FieldAp ap1 = (FieldAp)ap;
                Field field = ap1.getField();
                if (ap instanceof BillFormAp || ap instanceof ContainerAp || ap instanceof ButtonAp || ap instanceof BarItemAp || ap instanceof FlexPanelAp || ap instanceof VectorAp) continue;
                String propType = FieldTypeUtil.getPropType((Field)field);
                String proKey = ap.getKey();
                String parentId = ap.getParentId();
                list.add(new FieldProp(ap.getId(), parentId, entryKey, proKey, ap.getName().getLocaleValue(), propType));
            }
        }
        return list;
    }

    public static List<FieldProp> getEntityAp(FormMetadata formmeta) {
        ArrayList<FieldProp> list = new ArrayList<FieldProp>(8);
        List items = formmeta.getItems();
        for (ControlAp ap : items) {
            if (!(ap instanceof EntryAp)) continue;
            EntryAp entryAp = (EntryAp)ap;
            String proEntitykey = entryAp.getKey();
            String name = entryAp.getName().getLocaleValue();
            EntryEntity entry = entryAp.getEntry();
            if (entry == null) continue;
            String parentId = entry.getParentId();
            String parentKey = "";
            if (StringUtils.isNotBlank((CharSequence)parentId)) {
                ControlAp controlAp = items.stream().filter(e -> e.getId().equals(parentId)).findFirst().get();
                parentKey = controlAp.getKey();
            }
            String id = entry.getId();
            list.add(new FieldProp(id, parentId, parentKey, proEntitykey, name, "STRUCT"));
        }
        return list;
    }

    public static FormMetadata getFormMetaData(String entityKey) {
        String entityId = MetadataDao.getIdByNumber((String)entityKey, (MetaCategory)MetaCategory.Entity);
        if (StringUtils.isBlank((CharSequence)entityId)) {
            return null;
        }
        FormMetadata formmeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Form);
        if (formmeta == null) {
            return null;
        }
        EntityMetadata entitymeta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
        if (entitymeta == null) {
            return null;
        }
        formmeta.bindEntityMetadata(entitymeta);
        return formmeta;
    }

    public static List<ComboItem> getOpreateComboItemList(String entityNumber, Boolean isAppendKey) {
        ArrayList<ComboItem> comboList = new ArrayList<ComboItem>(16);
        List dataEntityOperate = EntityMetadataCache.getDataEntityOperate((String)entityNumber);
        if (CollectionUtils.isEmpty((Collection)dataEntityOperate)) {
            return comboList;
        }
        LocaleString localeString = null;
        for (Map operate : dataEntityOperate) {
            String key = (String)operate.get("key");
            Object name = operate.get("name");
            if (name == null) continue;
            localeString = MetadataUtils.getName(localeString, key, name, isAppendKey);
            comboList.add(new ComboItem(localeString, key));
        }
        return comboList;
    }

    public static LocaleString getName(LocaleString localeString, String key, Object name, Boolean isAppendKey) {
        localeString = new LocaleString(ResManager.loadKDString((String)"\u672a\u547d\u540d\u64cd\u4f5c", (String)"MetadataUtils_0", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
        if (name == null) {
            return localeString;
        }
        localeString = name instanceof Map ? (isAppendKey.booleanValue() ? MetadataUtils.fromMap((Map)name, key) : LocaleString.fromMap((Map)((Map)name))) : new LocaleString(name.toString());
        return localeString;
    }

    private static LocaleString fromMap(Map<String, String> values, String key) {
        LocaleString val = new LocaleString();
        for (Map.Entry<String, String> o : values.entrySet()) {
            val.setItem(o.getKey(), (Object)(o.getValue() + "(" + key + ")"));
        }
        return val;
    }

    public static String bulidNodesJson(DynamicObject dy, String fieldId, Boolean idInclideKeyPrefix, Class<?> propertiesClass) {
        EntityMetadata entitymeta = MetadataUtils.getEntityMetadata(dy, fieldId);
        if (entitymeta != null) {
            EntityFieldTreeBuildOption ops = new EntityFieldTreeBuildOption();
            ops.setIncludeBDRefProp(false);
            ops.setIncludeEntryEntityAsKeyPrefix(idInclideKeyPrefix.booleanValue());
            if (propertiesClass != null) {
                ops.addMatchedClassTypes(propertiesClass);
                if (propertiesClass.equals(LargeTextField.class)) {
                    ops.addMatchedClassTypes(TextField.class);
                }
            }
            TreeNode srcBillNode = FormTreeBuilder.buildEntityFieldsTree((EntityMetadata)entitymeta, (EntityFieldTreeBuildOption)ops);
            String nodesJson = SerializationUtils.toJsonString((Object)srcBillNode);
            return nodesJson;
        }
        return null;
    }

    public static EntityMetadata getEntityMetadata(DynamicObject dy, String billEntity) {
        DynamicObject entity = dy.getDynamicObject(billEntity);
        if (entity == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u914d\u7f6e\u5143\u6570\u636e\u3002", (String)"MetadataUtils_1", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
        }
        String entityKey = entity.getString("number");
        String entityId = MetadataDao.getIdByNumber((String)entityKey, (MetaCategory)MetaCategory.Entity);
        EntityMetadata entitymeta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
        if (entitymeta == null) {
            throw new KDBizException(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u5143\u6570\u636e%1\u5b9e\u4f53\u4e0d\u5b58\u5728\u3002", (String)"MetadataUtils_3", (String)"scm-pbd-formplugin", (Object[])new Object[0]), (String)"MetadataUtils_2", (String)"scm-pbd-formplugin", (Object[])new Object[]{billEntity}));
        }
        return entitymeta;
    }
}

