/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.formplugin.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.login.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.pbd.common.entity.FieldProp;
import kd.scm.pbd.common.utils.FieldPropUtils;
import kd.scm.pbd.common.utils.PbdCreditUtils;
import kd.scm.pbd.formplugin.util.MetadataUtils;

public class PbdCreditPluginUtils {
    private static final String BILL = "bill";

    public static DynamicObject getLinkSource(DynamicObject source) {
        if (source == null) {
            return null;
        }
        Long pkValue = (Long)source.getPkValue();
        DynamicObject loadSingle = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"pbd_credit_link");
        if (loadSingle == null) {
            return null;
        }
        return loadSingle;
    }

    public static Set<Long> getProgrammeCompanyOrgIds(DynamicObject loadSingleLink) {
        HashSet<Long> entrySubordinateOrgsLink = new HashSet(8);
        HashMap<Long, Boolean> entryOrgIdIncludeSubOrgMapLink = new HashMap<Long, Boolean>(8);
        DynamicObjectCollection companyorgDys = loadSingleLink.getDynamicObjectCollection("orgentity");
        if (!CollectionUtils.isEmpty((Collection)companyorgDys)) {
            for (DynamicObject companyorgDy : companyorgDys) {
                Boolean linkIncludeSubOrg = companyorgDy.getBoolean("includesuborg");
                DynamicObject linkCompanyOrgDy = companyorgDy.getDynamicObject("companyorg");
                if (linkCompanyOrgDy == null) continue;
                entryOrgIdIncludeSubOrgMapLink.put((Long)linkCompanyOrgDy.getPkValue(), linkIncludeSubOrg);
            }
        }
        entrySubordinateOrgsLink = PbdCreditUtils.getAllSubordinateOrgs(entryOrgIdIncludeSubOrgMapLink, (Boolean)Boolean.FALSE);
        return entrySubordinateOrgsLink;
    }

    public static void toServiceRule(IFormView view, List<Object> billids, DynamicObject entityDy, CloseCallBack callBack) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setCustomParam("billid", billids);
        if (entityDy != null) {
            Object entityId = entityDy.getPkValue();
            fsp.setCustomParam("entryid", entityId);
        }
        fsp.setFormId("pbd_service_rule");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(callBack);
        view.showForm(fsp);
    }

    public static void setBillOpratorItems(IFormView view, IDataModel model, DynamicObject dy, String operator) {
        String entityName = "";
        DynamicObject billentity = dy.getDynamicObject("billentity");
        if (null == billentity) {
            return;
        }
        entityName = billentity.getString("number");
        List<ComboItem> combList = PbdCreditPluginUtils.getOpertorConList(dy, entityName);
        PbdCreditPluginUtils.loadOpertorCombList(view, combList, "operator");
        model.setValue("operator", (Object)operator);
    }

    public static List<ComboItem> getOpertorConList(DynamicObject dy, String entityName) {
        String triggertype = dy.getString("triggertype");
        List<ComboItem> combList = PbdCreditPluginUtils.getOpertorCombList(entityName, "operator", triggertype);
        return combList;
    }

    public static List<ComboItem> getOpertorCombList(String entityName, String controlName, String triggertype) {
        if ("B".equals(triggertype)) {
            QFilter qf = new QFilter("1", "=", (Object)1);
            DynamicObject[] loads = BusinessDataServiceHelper.load((String)"pbd_service_op_scene", (String)"id,number,name", (QFilter[])new QFilter[]{qf});
            ArrayList<ComboItem> combList = new ArrayList<ComboItem>(8);
            for (DynamicObject dy : loads) {
                Object name = dy.get("name");
                String number = dy.getString("number");
                LocaleString localeString = null;
                LocaleString nameLS = MetadataUtils.getName(localeString, number, name, Boolean.TRUE);
                ComboItem comboItem = new ComboItem(nameLS, number);
                combList.add(comboItem);
            }
            return combList;
        }
        List<ComboItem> combList = MetadataUtils.getOpreateComboItemList(entityName, Boolean.TRUE);
        if (!CollectionUtils.isEmpty(combList)) {
            return combList;
        }
        return null;
    }

    private static void loadOpertorCombList(IFormView view, List<ComboItem> combList, String controlName) {
        ComboEdit fieldsCombo = (ComboEdit)view.getControl(controlName);
        fieldsCombo.setComboItems(combList);
    }

    public static String bulidNodesJson(List<FieldProp> fieldProps, String title, List<String> excludeKeys, String key) {
        TreeNode treeNode = new TreeNode("", BILL, title, true);
        ArrayList<Object> pkIds = new ArrayList<Object>(8);
        for (FieldProp prop : fieldProps) {
            if (!CollectionUtils.isEmpty(excludeKeys) && excludeKeys.contains(prop.getKey())) continue;
            PbdCreditPluginUtils.buildTree(fieldProps, excludeKeys, treeNode, pkIds, prop, key);
        }
        String nodesJson = SerializationUtils.toJsonString((Object)treeNode);
        return nodesJson;
    }

    public static List<String> getCurFieldIds(IDataModel model, String entityKey, String fieldId) {
        ArrayList<String> curFieldId = new ArrayList<String>(8);
        DynamicObjectCollection entryEntity2 = model.getEntryEntity(entityKey);
        if (!CollectionUtils.isEmpty((Collection)entryEntity2)) {
            for (DynamicObject dy : entryEntity2) {
                String fieldKey = dy.getString(fieldId);
                curFieldId.add(fieldKey);
            }
        }
        return curFieldId;
    }

    private static void buildTree(List<FieldProp> fieldProps, List<String> excludeKeys, TreeNode treeNode, List<Object> pkIds, FieldProp prop, String key) {
        String id = prop.getId();
        String pid = prop.getParentId();
        String parentKey = prop.getParentKey();
        Boolean flag = false;
        flag = "id".equals(key) ? Boolean.valueOf(!"0".equals(pid)) : Boolean.valueOf(!"".equals(pid) && !BILL.equals(parentKey));
        if (flag.booleanValue()) {
            FieldProp parent = null;
            parent = "id".equals(key) ? FieldPropUtils.findCheckedField((String)prop.getParentId(), null, fieldProps) : FieldPropUtils.findCheckedField(null, (Object)prop.getParentKey(), fieldProps);
            if (parent == null) {
                return;
            }
            if (!pkIds.contains(pid)) {
                PbdCreditPluginUtils.buildTree(fieldProps, excludeKeys, treeNode, pkIds, parent, key);
            }
            TreeNode parentNode = treeNode.getTreeNode(parent.getKey());
            String nodeId = prop.getKey();
            TreeNode childNode = new TreeNode(parent.getKey(), nodeId, prop.getName() + "(" + prop.getKey() + ")");
            parentNode.addChild(childNode);
            pkIds.add(id);
        } else {
            if (pkIds.contains(id)) {
                return;
            }
            TreeNode parentNode = new TreeNode(BILL, prop.getKey(), prop.getName() + "(" + prop.getKey() + ")");
            treeNode.addChild(parentNode);
            pkIds.add(id);
        }
    }

    public static void doClearFieldValue(IDataModel model, String key, ChangeData[] changeDatas) {
        for (ChangeData changeData : changeDatas) {
            Object newValue = changeData.getNewValue();
            if (newValue != null && !StringUtils.isEmpty((String)changeData.getNewValue().toString())) continue;
            model.setValue(key, null, changeData.getRowIndex());
        }
    }
}

