/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.opplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.JacksonJsonUtil;
import kd.scm.pbd.common.constant.PbdTYCContants;
import kd.scm.pbd.common.enums.DigitalCreditPlatformEnum;

public class PbdDigitalCreditLinkSaveOp
extends AbstractOperationServicePlugIn {
    private static Log log = LogFactory.getLog(PbdDigitalCreditLinkSaveOp.class);
    private static final String ISC_CONNECTION_TYPE = "isc_connection_type";
    private static final String CLIENTID = "clientid";
    private static final String CLIENTSECRET = "clientsecret";
    private static final String TOKEN = "token";
    private static final String PUBLICKEY = "publickey";
    private static final String JINGWEIPUBLICKEY = "jingweipublickey";
    private static final String ISC_DATA_SOURCE = "isc_data_source";
    private static final String ISC_DATABASE_LINK = "isc_database_link";
    private static final String PLATFORM = "platform";
    private static final String TENANTID = "tenantid";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("syssource");
        fieldKeys.add("id");
        fieldKeys.add(PLATFORM);
        fieldKeys.add(CLIENTID);
        fieldKeys.add(CLIENTSECRET);
        fieldKeys.add(TOKEN);
        fieldKeys.add(PUBLICKEY);
        fieldKeys.add(JINGWEIPUBLICKEY);
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs args) {
        super.beforeExecuteOperationTransaction(args);
        String operationKey = args.getOperationKey();
        if ("save".equalsIgnoreCase(operationKey)) {
            for (DynamicObject data : args.getDataEntities()) {
                Object linkpkValue = data.getPkValue();
                QFilter qFilter = new QFilter("enable", "=", (Object)"1");
                qFilter.and("link", "=", linkpkValue);
                DynamicObject[] dataEntitys = BusinessDataServiceHelper.load((String)"pbd_service_programme", (String)"id,name", (QFilter[])new QFilter[]{qFilter});
                if (dataEntitys == null || dataEntitys.length <= 0) continue;
                String msg = ResManager.loadKDString((String)"\u8fde\u63a5\u914d\u7f6e\u5df2\u7ecf\u88ab\u53ef\u7528\u7684\u4e1a\u52a1\u8c03\u7528\u65b9\u6848\u5f15\u7528\uff0c\u8bf7\u5148\u7981\u7528\u518d\u4fee\u6539\u3002", (String)"PbdDigitalCreditLinkSaveOp_5", (String)"scm-pbd-opplugin", (Object[])new Object[0]);
                args.setCancelMessage(msg);
                args.setCancel(true);
                return;
            }
            for (DynamicObject data : args.getDataEntities()) {
                this.handleBeforeSave(data, args);
            }
        }
    }

    private void handleBeforeSave(DynamicObject data, BeforeOperationArgs args) {
        DynamicObject platform = data.getDynamicObject(PLATFORM);
        if (platform != null) {
            this.updateIscDatabaseLink(data, args, platform);
        }
        data.set(TENANTID, (Object)RequestContext.getOrCreate().getTenantId());
    }

    public void updateIscDatabaseLink(DynamicObject data, BeforeOperationArgs args, DynamicObject platform) {
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", String.valueOf(true));
        option.setVariableValue("isStrict", String.valueOf(false));
        String linkNumber = data.getString("number");
        String name = data.getString("name");
        String iscNumber = "SCM-" + linkNumber;
        QFilter filter = new QFilter("number", "=", (Object)iscNumber);
        DynamicObject linkDyo = BusinessDataServiceHelper.loadSingle((String)ISC_DATABASE_LINK, (String)"appid,tenant,appsecret, appsecret_new, dum_link, database_type,server_ip,http_protocal,max_tps,isv,user, password, newpwd,attr_e1,attr5", (QFilter[])new QFilter[]{filter});
        try {
            if (linkDyo == null) {
                linkDyo = BusinessDataServiceHelper.newDynamicObject((String)ISC_DATABASE_LINK);
                linkDyo.set("number", (Object)iscNumber);
                linkDyo.set("name", (Object)name);
                linkDyo.set("status", (Object)"C");
                linkDyo.set("enable", (Object)"1");
                linkDyo.set("http_protocal", (Object)"https");
                linkDyo.set("max_tps", (Object)PbdTYCContants.max_tps);
                linkDyo.set("isv", (Object)"kingdee.SCM");
            }
            this.initLinkByPlatform(platform, linkDyo);
            DynamicObject iscConnectionType = this.getAndEnableConnectionType(option, platform);
            this.buildLinkDy(linkDyo, data, name, iscNumber, iscConnectionType, platform);
        }
        catch (Exception e) {
            String msg = ResManager.loadKDString((String)"\u4fdd\u5b58\u96c6\u6210\u4e91\u8fde\u63a5\u914d\u7f6e\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PbdDigitalCreditLinkSaveOp_7", (String)"scm-pbd-opplugin", (Object[])new Object[0]);
            this.setCancel(args, e.getMessage(), msg);
            return;
        }
        OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)ISC_DATABASE_LINK, (DynamicObject[])new DynamicObject[]{linkDyo}, (OperateOption)option);
        if (!saveResult.isSuccess()) {
            String msg = ResManager.loadKDString((String)"\u4fdd\u5b58\u96c6\u6210\u4e91\u8fde\u63a5\u914d\u7f6e\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PbdDigitalCreditLinkSaveOp_7", (String)"scm-pbd-opplugin", (Object[])new Object[0]);
            String errorInfoDetails = ExceptionUtil.getErrorInfoDetails((List)saveResult.getAllErrorOrValidateInfo());
            this.setCancel(args, errorInfoDetails, msg);
            return;
        }
        QFilter database = new QFilter("number", "=", (Object)iscNumber);
        DynamicObject databaseDyo = BusinessDataServiceHelper.loadSingle((String)ISC_DATA_SOURCE, (String)"id,dblink, connection_type, number, name,isv, remark,status,enable", (QFilter[])new QFilter[]{database});
        List sysSourceSuccPkIds = new ArrayList(8);
        if (databaseDyo == null) {
            databaseDyo = BusinessDataServiceHelper.newDynamicObject((String)ISC_DATA_SOURCE);
        }
        this.buildDataBaseDy(linkDyo, saveResult, databaseDyo);
        OperationResult databaseSaveResult = OperationServiceHelper.executeOperate((String)"save", (String)ISC_DATA_SOURCE, (DynamicObject[])new DynamicObject[]{databaseDyo}, (OperateOption)option);
        if (!databaseSaveResult.isSuccess()) {
            DeleteServiceHelper.delete((IDataEntityType)linkDyo.getDataEntityType(), (Object[])new Object[]{linkDyo.getPkValue()});
            String msg = ResManager.loadKDString((String)"\u4fdd\u5b58\u96c6\u6210\u4e91\u6570\u636e\u6e90\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PbdDigitalCreditLinkSaveOp_9", (String)"scm-pbd-opplugin", (Object[])new Object[0]);
            String errorInfoDetails = ExceptionUtil.getErrorInfoDetails((List)saveResult.getAllErrorOrValidateInfo());
            this.setCancel(args, errorInfoDetails, msg);
            return;
        }
        sysSourceSuccPkIds = databaseSaveResult.getSuccessPkIds();
        if (!CollectionUtils.isEmpty(sysSourceSuccPkIds)) {
            data.set("syssource", sysSourceSuccPkIds.get(0));
        } else {
            Object syssourceid = databaseDyo.getPkValue();
            data.set("syssource", syssourceid);
        }
        data.set(CLIENTID, (Object)"");
        data.set(CLIENTSECRET, (Object)"");
        data.set(TOKEN, (Object)"");
    }

    private void initLinkByPlatform(DynamicObject platform, DynamicObject linkDyo) {
        String platformSystype = platform.getString("systype");
        String defaultLinkNumber = DigitalCreditPlatformEnum.fromVal((String)platformSystype).getCode();
        if (DigitalCreditPlatformEnum.CREDITPLATFORM_TYC.getCode().equals(defaultLinkNumber)) {
            linkDyo.set("database_type", (Object)"TianYanCha");
            linkDyo.set("server_ip", (Object)"open.api.tianyancha.com");
        } else if (DigitalCreditPlatformEnum.CREDITPLATFORM_TYCMONITOR.getCode().equals(defaultLinkNumber)) {
            linkDyo.set("database_type", (Object)"KD_TYC_MONITOR");
            linkDyo.set("server_ip", (Object)"pro.tianyancha.com");
        } else if (DigitalCreditPlatformEnum.CREDITPLATFORM_KDCLOUD.getCode().equals(defaultLinkNumber)) {
            linkDyo.set("database_type", (Object)"KD_KingdeeCloud");
            linkDyo.set("server_ip", (Object)"bj2-api.kingdee.com");
        } else if (DigitalCreditPlatformEnum.CREDITPLATFORM_QCC.getCode().equals(defaultLinkNumber)) {
            linkDyo.set("database_type", (Object)"QiChaCha");
            linkDyo.set("server_ip", (Object)"api.qichacha.com");
        } else if (DigitalCreditPlatformEnum.CREDITPLATFORM_QIXINBAO.getCode().equals(defaultLinkNumber)) {
            linkDyo.set("database_type", (Object)"QiXinBao");
            linkDyo.set("server_ip", (Object)"api.qixin.com");
        } else {
            linkDyo.set("database_type", (Object)defaultLinkNumber);
        }
    }

    private void setCancel(BeforeOperationArgs args, String errorMsg, String msg) {
        log.info("@@@kd.scm.pbd.formplugin.digitalcredit.PbdDigitalCreditLinkPlugin.updateIscDatabaseLink:" + msg + errorMsg);
        args.setCancelMessage(msg + errorMsg);
        args.setCancel(true);
    }

    private void buildDataBaseDy(DynamicObject linkDyo, OperationResult saveResult, DynamicObject databaseDyo) {
        Object pkValue = this.getSuccessLinkId(linkDyo, saveResult);
        databaseDyo.set("dblink", pkValue);
        String number = linkDyo.getString("number");
        if (number.endsWith("KD_KingdeeCloud")) {
            databaseDyo.set("id", (Object)PbdTYCContants.database_id_kd_cloud);
        } else if (number.endsWith("QiChaCha")) {
            databaseDyo.set("id", (Object)PbdTYCContants.database_id_qichacha);
        } else if (number.endsWith("QiXinBao")) {
            databaseDyo.set("id", (Object)PbdTYCContants.database_id_qixinbao);
        } else if (number.endsWith("TianYanCha")) {
            databaseDyo.set("id", (Object)PbdTYCContants.database_id_tyc);
        } else if (number.endsWith("TYC_MONITOR")) {
            databaseDyo.set("id", (Object)PbdTYCContants.database_id_tycmonitor);
        }
        databaseDyo.set("connection_type", linkDyo.get("database_type"));
        databaseDyo.set("number", linkDyo.get("number"));
        databaseDyo.set("name", linkDyo.get("name"));
        databaseDyo.set("status", (Object)"C");
        databaseDyo.set("enable", (Object)"1");
        databaseDyo.set("isv", (Object)"kingdee.SCM");
        databaseDyo.set("remark", (Object)ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u534f\u540c\u4e91\u81ea\u52a8\u751f\u6210\u3002", (String)"PbdDigitalCreditLinkSaveOp_8", (String)"scm-pbd-opplugin", (Object[])new Object[0]));
    }

    private void buildLinkDy(DynamicObject linkDyo, DynamicObject data, String name, String iscNumber, DynamicObject iscConnectionType, DynamicObject platform) throws Exception {
        String jingweiPublickey;
        String publickey;
        String jsonstr;
        HashMap<String, String> configData;
        if (iscConnectionType != null) {
            linkDyo.set("dum_link", iscConnectionType.getPkValue());
        }
        String appid = data.getString(CLIENTID);
        String appsecret = data.getString(CLIENTSECRET);
        String appsecret_new = data.getString(TOKEN);
        String user = data.getString("user");
        String platformSystype = platform.getString("systype");
        String defaultLinkNumber = DigitalCreditPlatformEnum.fromVal((String)platformSystype).getCode();
        if (DigitalCreditPlatformEnum.CREDITPLATFORM_TYCMONITOR.getCode().equals(defaultLinkNumber)) {
            if (StringUtils.isNotBlank((CharSequence)appid)) {
                linkDyo.set("tenant", (Object)appid);
            }
        } else if (StringUtils.isNotBlank((CharSequence)appid)) {
            linkDyo.set("appid", (Object)appid);
        }
        if (StringUtils.isNotBlank((CharSequence)user)) {
            linkDyo.set("user", (Object)user);
        }
        if (DigitalCreditPlatformEnum.CREDITPLATFORM_TYCMONITOR.getCode().equals(defaultLinkNumber) || DigitalCreditPlatformEnum.CREDITPLATFORM_TYC.getCode().equals(defaultLinkNumber)) {
            if (StringUtils.isNotBlank((CharSequence)appsecret)) {
                linkDyo.set("appsecret", (Object)appsecret);
            }
            if (StringUtils.isNotBlank((CharSequence)appsecret_new)) {
                linkDyo.set("appsecret_new", (Object)appsecret_new);
            }
        } else if (DigitalCreditPlatformEnum.CREDITPLATFORM_QCC.getCode().equals(defaultLinkNumber)) {
            configData = new HashMap<String, String>(8);
            if (StringUtils.isNotBlank((CharSequence)appid)) {
                configData.put("key", appid);
            }
            if (StringUtils.isNotBlank((CharSequence)appsecret)) {
                configData.put("secretkey", appsecret);
            }
            if (!CollectionUtils.isEmpty(configData)) {
                jsonstr = JacksonJsonUtil.toJSON(configData);
                linkDyo.set("attr_e1", (Object)jsonstr);
                linkDyo.set("attr5", (Object)"@#is_custom_page");
            }
        } else {
            configData = new HashMap(8);
            if (StringUtils.isNotBlank((CharSequence)appid)) {
                configData.put("client_id", appid);
            }
            if (StringUtils.isNotBlank((CharSequence)appsecret)) {
                configData.put("client_secret", appsecret);
            }
            if (!CollectionUtils.isEmpty(configData)) {
                jsonstr = JacksonJsonUtil.toJSON(configData);
                linkDyo.set("attr_e1", (Object)jsonstr);
                linkDyo.set("attr5", (Object)"@#is_custom_page");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(publickey = data.getString(PUBLICKEY)))) {
            // empty if block
        }
        if (StringUtils.isNotBlank((CharSequence)(jingweiPublickey = data.getString(JINGWEIPUBLICKEY)))) {
            // empty if block
        }
        if (StringUtils.isNotBlank((CharSequence)name)) {
            linkDyo.set("name", (Object)name);
        }
    }

    private DynamicObject getAndEnableConnectionType(OperateOption option, DynamicObject platform) {
        DynamicObject iscConnectionType = null;
        String platformNumber = platform.getString("number");
        String platformSystype = platform.getString("systype");
        String defaultLinkNumber = DigitalCreditPlatformEnum.fromVal((String)platformSystype).getCode();
        String number = "";
        number = DigitalCreditPlatformEnum.CREDITPLATFORM_TYC.getCode().equals(defaultLinkNumber) ? "TianYanCha" : (DigitalCreditPlatformEnum.CREDITPLATFORM_TYCMONITOR.getCode().equals(defaultLinkNumber) ? "KD_TYC_MONITOR" : (DigitalCreditPlatformEnum.CREDITPLATFORM_KDCLOUD.getCode().equals(defaultLinkNumber) ? "KD_KingdeeCloud" : (DigitalCreditPlatformEnum.CREDITPLATFORM_QCC.getCode().equals(defaultLinkNumber) ? "QiChaCha" : (DigitalCreditPlatformEnum.CREDITPLATFORM_QIXINBAO.getCode().equals(defaultLinkNumber) ? "QiXinBao" : platformNumber))));
        QFilter qf = new QFilter("number", "=", (Object)number);
        DynamicObject[] load = BusinessDataServiceHelper.load((String)ISC_CONNECTION_TYPE, (String)"id,name,enable", (QFilter[])new QFilter[]{qf});
        if (load != null && load.length > 0) {
            iscConnectionType = load[0];
            String connectTypeId = (String)iscConnectionType.getPkValue();
            boolean enable = iscConnectionType.getBoolean("enable");
            if (!enable) {
                this.doOperationByIds(ISC_CONNECTION_TYPE, "enable", new Object[]{connectTypeId}, option);
                this.doOperationByIds(ISC_CONNECTION_TYPE, "refresh_env", new Object[]{connectTypeId}, option);
            }
        }
        return iscConnectionType;
    }

    public OperationResult doOperationByIds(String entity, String opKey, Object[] ids, OperateOption option) {
        OperationResult opResult = OperationServiceHelper.executeOperate((String)opKey, (String)entity, (Object[])ids, (OperateOption)option);
        if (null != opResult && !opResult.isSuccess()) {
            String err = ExceptionUtil.getErrorInfoDetails((List)opResult.getAllErrorOrValidateInfo());
            log.info("PbdDigitalCreditLinkSaveOp.doOperationByIds\u6267\u884c\u64cd\u4f5c\uff1a" + opKey + "\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a" + err);
        }
        return opResult;
    }

    private Object getSuccessLinkId(DynamicObject linkDyo, OperationResult saveResult) {
        List successPkIds = saveResult.getSuccessPkIds();
        Object pkValue = linkDyo.getPkValue();
        if (!CollectionUtils.isEmpty((Collection)successPkIds)) {
            pkValue = successPkIds.get(0);
        }
        return pkValue;
    }
}

