/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.opplugin;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.ExceptionUtil;

public final class PbdEsDataSyncTriggerDisableOp
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog((String)PbdEsDataSyncTriggerDisableOp.class.getName());
    private static final String TRIGGER_TYPE = "trigger_type";
    private static final String TYPE_EVENT = "event";
    private static final String TYPE_AUTO = "auto";
    private static final String ENTITY_SCH_SCHEDULE = "sch_schedule";
    private static final String STATUS = "status";
    private static final String ENTITY_SCH_JOB = "sch_job";
    private static final String SUFFIX_ES = ".es";
    private static final String JOB_DEFINE = "job_define";
    private static final String EVT_EVENT = "evt_event";
    private static final String EVT_SUBSCRIPTION = "evt_subscription";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add(TRIGGER_TYPE);
        e.getFieldKeys().add(TYPE_EVENT);
        e.getFieldKeys().add(JOB_DEFINE);
        e.getFieldKeys().add("job_schedule");
        e.getFieldKeys().add("interval");
        e.getFieldKeys().add("schedule");
        e.getFieldKeys().add("expired_time");
        e.getFieldKeys().add("expired_time");
        e.getFieldKeys().add("exe_job_user");
        e.getFieldKeys().add("validated_time");
        e.getFieldKeys().add("esconfig");
        e.getFieldKeys().add("events");
        e.getFieldKeys().add("handler");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        this.cancel(e.getDataEntities());
    }

    private void cancel(DynamicObject[] triggers) {
        for (DynamicObject trigger : triggers) {
            if (TYPE_AUTO.equals(trigger.get(TRIGGER_TYPE))) {
                this.disableJobSchedule(trigger);
                continue;
            }
            if (!TYPE_EVENT.equals(trigger.get(TRIGGER_TYPE))) continue;
            this.detachEvents(trigger);
        }
    }

    private void detachEvents(DynamicObject trigger) {
        this.deleteEventSubscription(trigger);
        this.deleteEvent(trigger);
    }

    private void deleteEvent(DynamicObject trigger) {
        List<String> eventNumberViewList = this.getEventNumberViewAndSubscriptionNumberList(trigger);
        Map idToSubscriptionDynMap = BusinessDataServiceHelper.loadFromCache((String)EVT_EVENT, (String)"id", (QFilter[])new QFilter[]{new QFilter("numberview", "in", eventNumberViewList)});
        log.info("kd.scm.pbd.opplugin.PbdEsDataSyncTriggerDisableOp.deleteEvent.eventNumberViewList:" + eventNumberViewList);
        try {
            CommonUtil.check((OperationResult)OperationServiceHelper.executeOperate((String)"delete", (String)EVT_EVENT, (Object[])idToSubscriptionDynMap.keySet().toArray(new Object[0]), (OperateOption)this.getOperationOption()));
        }
        catch (KDBizException e) {
            log.warn("kd.scm.pbd.opplugin.PbdEsDataSyncTriggerDisableOp.deleteEvent:" + ExceptionUtil.getStackTrace((Throwable)e));
        }
    }

    private void deleteEventSubscription(DynamicObject trigger) {
        List<String> eventSubscriptionNumberList = this.getEventNumberViewAndSubscriptionNumberList(trigger);
        Map idToSubscriptionDynMap = BusinessDataServiceHelper.loadFromCache((String)EVT_SUBSCRIPTION, (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "in", eventSubscriptionNumberList)});
        log.info("kd.scm.pbd.opplugin.PbdEsDataSyncTriggerDisableOp.deleteEventSubscription.idToSubscriptionDynMap.keySet():" + idToSubscriptionDynMap.keySet());
        try {
            CommonUtil.check((OperationResult)OperationServiceHelper.executeOperate((String)"delete", (String)EVT_SUBSCRIPTION, (Object[])idToSubscriptionDynMap.keySet().toArray(new Object[0]), (OperateOption)this.getOperationOption()));
        }
        catch (KDBizException e) {
            log.warn("kd.scm.pbd.opplugin.PbdEsDataSyncTriggerDisableOp.deleteEventSubscription:" + ExceptionUtil.getStackTrace((Throwable)e));
        }
    }

    private List<String> getEventNumberViewAndSubscriptionNumberList(DynamicObject trigger) {
        DynamicObject esConfigDyn = trigger.getDynamicObject("esconfig");
        DynamicObject indexEntityDyn = esConfigDyn.getDynamicObject("indexentity");
        String indexEntityKey = indexEntityDyn.getString("number");
        String events = trigger.getString("events");
        ArrayList<String> eventNumberList = new ArrayList<String>();
        for (String event : events.split(",")) {
            if (!StringUtils.isNotBlank((CharSequence)event)) continue;
            eventNumberList.add(indexEntityKey + "." + event + SUFFIX_ES);
        }
        return eventNumberList;
    }

    private void disableJobSchedule(DynamicObject trigger) {
        if (TYPE_AUTO.equals(trigger.get(TRIGGER_TYPE))) {
            this.disableSchedule(trigger);
            this.disableJob(trigger);
        }
    }

    private DynamicObject disableJob(DynamicObject trigger) {
        DynamicObject job = trigger.getDynamicObject(JOB_DEFINE);
        if (job == null) {
            return null;
        }
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)job.getPkValue(), (String)ENTITY_SCH_JOB);
        obj.set(STATUS, (Object)"0");
        obj.set("runmode", (Object)"0");
        obj.set("runorder", (Object)"0");
        CommonUtil.check((OperationResult)OperationServiceHelper.executeOperate((String)"save", (String)ENTITY_SCH_JOB, (DynamicObject[])new DynamicObject[]{obj}, (OperateOption)this.getOperationOption()));
        ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        scheduleManager.disableJob((String)job.getPkValue());
        return obj;
    }

    private DynamicObject disableSchedule(DynamicObject trigger) {
        DynamicObject schedule = trigger.getDynamicObject("job_schedule");
        if (schedule == null) {
            return null;
        }
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)schedule.getPkValue(), (String)ENTITY_SCH_SCHEDULE);
        obj.set(STATUS, (Object)"0");
        obj.set("name", (Object)ResManager.loadKDString((String)"\u6b64\u4efb\u52a1\u7531SRM\u540e\u53f0\u521b\u5efa\uff0c\u4e25\u7981\u4eba\u5de5\u542f\u7528\uff0c\u5426\u5219\u540e\u679c\u81ea\u8d1f\u3002", (String)"PbdEsDataSyncTriggerDisableOp_0", (String)"scm-pbd-opplugin", (Object[])new Object[0]));
        CommonUtil.check((OperationResult)OperationServiceHelper.executeOperate((String)"save", (String)ENTITY_SCH_SCHEDULE, (DynamicObject[])new DynamicObject[]{obj}, (OperateOption)this.getOperationOption()));
        ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        scheduleManager.disableSchedule((String)schedule.getPkValue());
        return obj;
    }

    private OperateOption getOperationOption() {
        OperateOption option = OperateOption.create();
        option.setVariableValue("ignoreValidation", String.valueOf(Boolean.TRUE));
        option.setVariableValue("ishasright", String.valueOf(Boolean.TRUE));
        return option;
    }
}

