/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.opplugin;

import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.parser.CronParser;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.field.ComboItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.param.ParameterUtils;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.MetaDataUtil;
import org.quartz.CronExpression;

public final class PbdEsDataSyncTriggerEnableOp
extends AbstractOperationServicePlugIn {
    private static final long SERVICE_EXECUTE_PLUGIN = 904236026388547584L;
    private static final Log log = LogFactory.getLog((String)PbdEsDataSyncTriggerEnableOp.class.getName());
    private static final String TRIGGER_TYPE = "trigger_type";
    private static final String TYPE_EVENT = "event";
    private static final String ENTITY_SCH_SCHEDULE = "sch_schedule";
    private static final String STATUS = "status";
    private static final String ENTITY_SCH_JOB = "sch_job";
    private static final String TRIGGER = "trigger";
    private static final String NUMBER = "number";
    private static final String REPEATMODE = "repeatmode";
    private static final String JOB_DEFINE = "job_define";
    private static final String TXTDESC = "txtdesc";
    private static final String PBD_DATA_SYNC_TASK = "PBD_DATA_SYNC_TASK";
    private static final String ENTITY_SCH_TASKDEFINE = "sch_taskdefine";
    private static final String CYCLENUM = "cyclenum";
    private static final String SUFFIX_ES = ".es";
    private static final String EVT_SUBSCRIPTION = "evt_subscription";
    private static final String SPLIT = "-";
    private static final String EVT_EVENT = "evt_event";
    private static final String EXECUTE_PLUGIN = "executePlugin";
    private static final String PREFIX_PBD = "pbd_";
    private static final String BIZ = "BIZ";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add(TRIGGER_TYPE);
        e.getFieldKeys().add(TYPE_EVENT);
        e.getFieldKeys().add(JOB_DEFINE);
        e.getFieldKeys().add(NUMBER);
        e.getFieldKeys().add("job_schedule");
        e.getFieldKeys().add("interval");
        e.getFieldKeys().add("schedule");
        e.getFieldKeys().add("expired_time");
        e.getFieldKeys().add("expired_time");
        e.getFieldKeys().add("exe_job_user");
        e.getFieldKeys().add("validated_time");
        e.getFieldKeys().add("esconfig");
        e.getFieldKeys().add("events");
        e.getFieldKeys().add("handler");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        this.submit(e.getDataEntities());
    }

    private void submit(DynamicObject[] triggers) {
        for (DynamicObject trigger : triggers) {
            if ("auto".equals(trigger.get(TRIGGER_TYPE))) {
                this.createJobSchedule(trigger);
                continue;
            }
            if (!TYPE_EVENT.equals(trigger.get(TRIGGER_TYPE))) continue;
            this.attachEvents(trigger);
        }
    }

    private void attachEvents(DynamicObject trigger) {
        this.createEvent(trigger);
        this.createEventSubscription(trigger);
    }

    private void createEventSubscription(DynamicObject trigger) {
        DynamicObject esConfigDyn = trigger.getDynamicObject("esconfig");
        DynamicObject indexEntityDyn = esConfigDyn.getDynamicObject("indexentity");
        String indexEntityKey = indexEntityDyn.getString(NUMBER);
        List<String> eventNumberList = this.getEventNumberList(trigger, indexEntityKey);
        if (this.isEventSubscriptionExistAndRemove(eventNumberList)) {
            return;
        }
        List opreateComboItemList = MetaDataUtil.getOpreateComboItemList((String)indexEntityKey);
        MainEntityType eventSubscriptionEntityType = EntityMetadataCache.getDataEntityType((String)EVT_SUBSCRIPTION);
        ArrayList<DynamicObject> newEventSubscriptionDyns = new ArrayList<DynamicObject>(eventNumberList.size());
        Map<String, Long> eventNumberToEventIdMap = this.getEventNumberToEventIdMap(trigger, indexEntityKey);
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("workflow", new DistributeCacheHAPolicy());
        for (String eventNumber : eventNumberList) {
            DynamicObject newEventSubscriptionDyn = BusinessDataServiceHelper.newDynamicObject((String)EVT_SUBSCRIPTION);
            newEventSubscriptionDyn = ParameterUtils.createDefaultEntity((MainEntityType)eventSubscriptionEntityType, (DynamicObject)newEventSubscriptionDyn);
            newEventSubscriptionDyn.set(TYPE_EVENT, (Object)eventNumberToEventIdMap.get(eventNumber));
            newEventSubscriptionDyn.set("eventnumber", (Object)eventNumber);
            newEventSubscriptionDyn.set(NUMBER, (Object)(eventNumber + SUFFIX_ES));
            newEventSubscriptionDyn.set("service", (Object)904236026388547584L);
            newEventSubscriptionDyn.set("servicenumber", (Object)EXECUTE_PLUGIN);
            newEventSubscriptionDyn.set("serviceconfig", (Object)("{\"scriptid\":\"\",\"type\":\"class\",\"value\":\"{\\\"appid\\\":\\\"pbd\\\",\\\"class\\\":\\\"" + trigger.getString("handler") + "\\\"}\"}"));
            for (ComboItem comboItem : opreateComboItemList) {
                if (!comboItem.getValue().equals(eventNumber.split("\\.")[1])) continue;
                newEventSubscriptionDyn.set("name", (Object)(trigger.getString("name") + SPLIT + comboItem.getCaption().getLocaleValue()));
            }
            newEventSubscriptionDyns.add(newEventSubscriptionDyn);
            this.cache(indexEntityKey, cache, eventNumber);
        }
        CommonUtil.check((OperationResult)OperationServiceHelper.executeOperate((String)"save", (String)EVT_SUBSCRIPTION, (DynamicObject[])newEventSubscriptionDyns.toArray(new DynamicObject[0]), (OperateOption)this.getOperationOption()));
    }

    private void cache(String indexEntityKey, DistributeSessionlessCache cache, String eventNumber) {
        cache.addToSet(RequestContext.get().getAccountId() + ".evt.cacheEvent." + indexEntityKey, new String[]{eventNumber}, Integer.MAX_VALUE);
    }

    private Map<String, Long> getEventNumberToEventIdMap(DynamicObject trigger, String indexEntityKey) {
        HashMap<String, Long> res = new HashMap<String, Long>();
        List<String> eventNumberList = this.getEventNumberList(trigger, indexEntityKey);
        DynamicObjectCollection eventDyns = QueryServiceHelper.query((String)EVT_EVENT, (String)"id,number,numberview", (QFilter[])new QFilter[]{new QFilter(NUMBER, "in", eventNumberList)});
        for (DynamicObject eventDyn : eventDyns) {
            res.put(eventDyn.getString(NUMBER), eventDyn.getLong("id"));
        }
        return res;
    }

    private boolean isEventSubscriptionExistAndRemove(List<String> eventSbuscriptionNumberList) {
        ArrayList<String> esEventSbuscriptionNumberList = new ArrayList<String>(eventSbuscriptionNumberList.size());
        for (String eventSbuscriptionNumber2 : eventSbuscriptionNumberList) {
            esEventSbuscriptionNumberList.add(eventSbuscriptionNumber2 + SUFFIX_ES);
        }
        DynamicObjectCollection eventSubscriptionDyns = QueryServiceHelper.query((String)EVT_SUBSCRIPTION, (String)NUMBER, (QFilter[])new QFilter[]{new QFilter(NUMBER, "in", esEventSbuscriptionNumberList)});
        for (DynamicObject eventSubscriptionDyn : eventSubscriptionDyns) {
            eventSbuscriptionNumberList.removeIf(eventSbuscriptionNumber -> StringUtils.equals((CharSequence)(eventSbuscriptionNumber + SUFFIX_ES), (CharSequence)eventSubscriptionDyn.getString(NUMBER)));
        }
        return esEventSbuscriptionNumberList.isEmpty();
    }

    private void createEvent(DynamicObject trigger) {
        DynamicObject esConfigDyn = trigger.getDynamicObject("esconfig");
        DynamicObject indexEntityDyn = esConfigDyn.getDynamicObject("indexentity");
        String indexEntityKey = indexEntityDyn.getString(NUMBER);
        List<String> eventNumberList = this.getEventNumberList(trigger, indexEntityKey);
        if (this.isEventExist(eventNumberList)) {
            return;
        }
        List opreateComboItemList = MetaDataUtil.getOpreateComboItemList((String)indexEntityKey);
        MainEntityType eventEntityType = EntityMetadataCache.getDataEntityType((String)EVT_EVENT);
        ArrayList<DynamicObject> newEventDyns = new ArrayList<DynamicObject>(eventNumberList.size());
        indexEntityDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)indexEntityDyn.getPkValue(), (String)"bos_entityobject");
        for (String eventNumber : eventNumberList) {
            DynamicObject newEventDyn = BusinessDataServiceHelper.newDynamicObject((String)EVT_EVENT);
            newEventDyn = ParameterUtils.createDefaultEntity((MainEntityType)eventEntityType, (DynamicObject)newEventDyn);
            newEventDyn.set(NUMBER, (Object)eventNumber);
            newEventDyn.set("type", (Object)"cosmic");
            newEventDyn.set("entity", indexEntityDyn.get("id"));
            newEventDyn.set("source", indexEntityDyn.getDynamicObject("bizappid").getPkValue());
            newEventDyn.set("numberview", (Object)(eventNumber + SUFFIX_ES));
            newEventDyn.set("description", (Object)ResManager.loadKDString((String)"\u6b64\u4e8b\u4ef6\u7531SRM\u540e\u53f0\u81ea\u52a8\u521b\u5efa\uff0c\u5982\u679c\u9700\u8981\u8ba2\u9605\u8be5\u4e8b\u4ef6\uff0c\u8bf7\u5148\u5230\u5168\u6587\u68c0\u7d22\u6570\u636e\u540c\u6b65\u65b9\u6848\u7981\u7528\u5173\u8054\u65b9\u6848\u518d\u521b\u5efa\u8be5\u4e8b\u4ef6\u5b9a\u4e49\uff0c\u6ce8\u610f\u4e8b\u4ef6\u7f16\u7801\u4e0d\u8981\u548c\u81ea\u52a8\u521b\u5efa\u7684\u4e00\u6837\u3002", (String)"PbdEsDataSyncTriggerEnableOp_0", (String)"scm-pbd-opplugin", (Object[])new Object[0]));
            for (ComboItem comboItem : opreateComboItemList) {
                if (!comboItem.getValue().equals(eventNumber.split("\\.")[1])) continue;
                newEventDyn.set("operation", (Object)comboItem.getCaption().getLocaleValue());
                newEventDyn.set("name", (Object)(trigger.getString("name") + SPLIT + comboItem.getCaption().getLocaleValue()));
            }
            newEventDyns.add(newEventDyn);
        }
        CommonUtil.check((OperationResult)OperationServiceHelper.executeOperate((String)"save", (String)EVT_EVENT, (DynamicObject[])newEventDyns.toArray(new DynamicObject[0]), (OperateOption)this.getOperationOption()));
    }

    private List<String> getEventNumberList(DynamicObject trigger, String indexEntityKey) {
        String events = trigger.getString("events");
        ArrayList<String> eventNumberList = new ArrayList<String>();
        for (String event : events.split(",")) {
            if (!StringUtils.isNotBlank((CharSequence)event)) continue;
            eventNumberList.add(indexEntityKey + "." + event);
        }
        return eventNumberList;
    }

    private boolean isEventExist(List<String> eventNumberList) {
        DynamicObjectCollection eventDyns = QueryServiceHelper.query((String)EVT_EVENT, (String)"id,number,numberview", (QFilter[])new QFilter[]{new QFilter(NUMBER, "in", eventNumberList)});
        for (DynamicObject eventDyn : eventDyns) {
            eventNumberList.removeIf(eventNumber -> StringUtils.equals((CharSequence)eventNumber, (CharSequence)eventDyn.getString(NUMBER)));
        }
        return eventNumberList.isEmpty();
    }

    private void createJobSchedule(DynamicObject trigger) {
        DynamicObject job = this.createJob(trigger);
        DynamicObject schedule = this.createSchedule(trigger, job);
        ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        scheduleManager.enableJob((String)job.getPkValue());
        scheduleManager.enableSchedule((String)schedule.getPkValue());
        trigger.set(JOB_DEFINE, job.getPkValue());
        trigger.set("job_schedule", schedule.getPkValue());
    }

    private DynamicObject createSchedule(DynamicObject trigger, DynamicObject job) {
        String id = trigger.getString("job_schedule_id");
        if (StringUtils.isEmpty((CharSequence)id)) {
            id = String.valueOf(DBServiceHelper.genGlobalLongId());
        }
        DynamicObject scheduleDyn = this.getExistedObject(ENTITY_SCH_SCHEDULE, id);
        String number = PREFIX_PBD + trigger.getString(NUMBER);
        scheduleDyn.set(NUMBER, (Object)number);
        scheduleDyn.set("job", job.getPkValue());
        DynamicObjectCollection entryentity = scheduleDyn.getDynamicObjectCollection("entryentity");
        DynamicObject entry = entryentity.addNew();
        entry.set("jobnumber_id", job.getPkValue());
        scheduleDyn.set("starttime", (Object)this.getStartTime(trigger));
        scheduleDyn.set("endtime", (Object)this.getEndTime(trigger));
        String interval = trigger.getString("interval");
        if ("0".equals(interval)) {
            this.handleCron(trigger, scheduleDyn);
        } else {
            scheduleDyn.set("plan", (Object)this.buildCron(interval, trigger));
            this.setScheduleDetail(scheduleDyn, interval);
        }
        scheduleDyn.set("combdorw", (Object)"d");
        scheduleDyn.set(STATUS, (Object)"1");
        scheduleDyn.set("name", trigger.get("name"));
        CommonUtil.check((OperationResult)OperationServiceHelper.executeOperate((String)"save", (String)ENTITY_SCH_SCHEDULE, (DynamicObject[])new DynamicObject[]{scheduleDyn}, (OperateOption)this.getOperationOption()));
        return scheduleDyn;
    }

    private void setScheduleDetail(DynamicObject obj, String interval) {
        if (StringUtils.isNumeric((CharSequence)interval)) {
            int minutes = this.getMinutes(interval);
            if (minutes == 60) {
                obj.set(REPEATMODE, (Object)"h");
                obj.set(CYCLENUM, (Object)1);
                obj.set(TXTDESC, (Object)ResManager.loadKDString((String)"\u4e8b\u4ef6\u5c06\u4e8e\u6bcf1\u5c0f\u65f6\u91cd\u590d", (String)"PbdEsDataSyncTriggerEnableOp_1", (String)"scm-pbd-opplugin", (Object[])new Object[0]));
            } else {
                obj.set(REPEATMODE, (Object)"mi");
                obj.set(CYCLENUM, (Object)minutes);
                obj.set(TXTDESC, (Object)ResManager.loadKDString((String)"\u4e8b\u4ef6\u5c06\u4e8e\u6bcf{0}\u5206\u949f\u91cd\u590d", (String)"PbdEsDataSyncTriggerEnableOp_2", (String)"scm-pbd-opplugin", (Object[])new Object[]{minutes}));
            }
        } else if (!StringUtils.isEmpty((CharSequence)interval)) {
            if ("d1".equals(interval)) {
                obj.set(REPEATMODE, (Object)"def");
            } else {
                obj.set(REPEATMODE, (Object)interval);
            }
            obj.set(CYCLENUM, (Object)1);
            obj.set(TXTDESC, (Object)ResManager.loadKDString((String)"\u4e8b\u4ef6\u5c06\u4e8e{0}\u91cd\u590d", (String)"PbdEsDataSyncTriggerEnableOp_4", (String)"scm-pbd-opplugin", (Object[])new Object[]{this.getTxtdesc(obj, interval)}));
        }
    }

    private String getTxtdesc(DynamicObject schedule, String repeatMode) {
        ComboProp comboProp = (ComboProp)schedule.getDynamicObjectType().getProperty(REPEATMODE);
        List comboItems = comboProp.getComboItems();
        for (ValueMapItem item : comboItems) {
            if (!item.getValue().equalsIgnoreCase(repeatMode)) continue;
            return item.getName().toString();
        }
        return null;
    }

    private String buildCron(String interval, DynamicObject trigger) {
        if (StringUtils.isNumeric((CharSequence)interval)) {
            int minutes = this.getMinutes(interval);
            if (minutes == 60) {
                return "0 0 * * * ?";
            }
            return "0 0/" + minutes + " * * * ?";
        }
        if (!StringUtils.isEmpty((CharSequence)interval)) {
            return this.constructCron(interval, trigger);
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u672a\u77e5\u4efb\u52a1\u8c03\u5ea6\u7684\u5faa\u73af\u7c7b\u578b:{0}", (String)"PbdEsDataSyncTriggerEnableOp_14", (String)"scm-pbd-opplugin", (Object[])new Object[]{interval}));
    }

    private String constructCron(String interval, DynamicObject trigger) {
        Date date = this.getStartTime(trigger);
        int hours = Integer.parseInt(new SimpleDateFormat("HH").format(date));
        if (interval.equals("d")) {
            return "0 0 " + hours + " ? * *";
        }
        if (interval.equals("w")) {
            return "0 0 " + hours + " ? * MON";
        }
        if (interval.equals("m")) {
            return "0 0 " + hours + " 1 * ?";
        }
        if (interval.equals("d1")) {
            return "0 0 1 ? * *";
        }
        throw new IllegalArgumentException(ResManager.loadKDString((String)"\u6267\u884c\u9891\u7387\u8bbe\u7f6e\u6709\u8bef\u3002", (String)"PbdEsDataSyncTriggerEnableOp_7", (String)"scm-pbd-opplugin", (Object[])new Object[0]));
    }

    private int getMinutes(String interval) {
        if (interval.equals("0")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u81ea\u5b9a\u4e49\u3002", (String)"PbdEsDataSyncTriggerEnableOp_8", (String)"scm-pbd-opplugin", (Object[])new Object[0]));
        }
        return 60 / Integer.parseInt(interval);
    }

    private void handleCron(DynamicObject trigger, DynamicObject obj) {
        String cron = trigger.getString("schedule");
        this.checkCron(cron);
        obj.set("plan", (Object)cron);
        obj.set(REPEATMODE, (Object)"def");
        obj.set(TXTDESC, (Object)ResManager.loadKDString((String)"\u6b64\u8c03\u5ea6\u8ba1\u5212\u7531\u96c6\u6210\u4e91\u542f\u52a8\u65b9\u6848\u81ea\u52a8\u751f\u6210", (String)"PbdEsDataSyncTriggerEnableOp_9", (String)"scm-pbd-opplugin", (Object[])new Object[0]));
    }

    private void checkCron(String cron) {
        if (StringUtils.isEmpty((CharSequence)cron)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6267\u884c\u8ba1\u5212\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"PbdEsDataSyncTriggerEnableOp_10", (String)"scm-pbd-opplugin", (Object[])new Object[0]));
        }
        try {
            new CronExpression(cron);
            this.getParser().parse(cron);
        }
        catch (Exception e) {
            log.warn(ExceptionUtil.getStackTrace((Throwable)e));
            throw new KDBizException(ResManager.loadKDString((String)"\u6267\u884c\u8ba1\u5212(cron\u8868\u8fbe\u5f0f:{0})\u4e0d\u5408\u6cd5,\u8bf7\u68c0\u67e5\u662f\u5426\u7f16\u5199\u6b63\u786e\u3002", (String)"PbdEsDataSyncTriggerEnableOp_11", (String)"scm-pbd-opplugin", (Object[])new Object[]{cron}));
        }
    }

    private CronParser getParser() {
        return new CronParser(CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.QUARTZ));
    }

    private Date getStartTime(DynamicObject trigger) {
        Date start = trigger.getDate("validated_time");
        if (start == null) {
            start = new Timestamp(System.currentTimeMillis() - 86400000L);
        }
        return start;
    }

    private Date getEndTime(DynamicObject trigger) {
        Date end = trigger.getDate("expired_time");
        if (end == null) {
            end = new Timestamp(System.currentTimeMillis() + 315360000000L);
        }
        return end;
    }

    private DynamicObject createJob(DynamicObject trigger) {
        String id = trigger.getString("job_define_id");
        if (id == null) {
            id = String.valueOf(DBServiceHelper.genGlobalLongId());
        }
        DynamicObject obj = this.getExistedObject(ENTITY_SCH_JOB, id);
        String number = PREFIX_PBD + trigger.getString(NUMBER);
        obj.set(NUMBER, (Object)number);
        obj.set("jobtype", (Object)BIZ);
        obj.set("taskclassname_id", this.createDataCopyTaskDefine(trigger));
        obj.set("classname", (Object)trigger.getString("handler"));
        DynamicObject exeJobUserDyn = trigger.getDynamicObject("exe_job_user");
        if (exeJobUserDyn != null) {
            obj.set("runbyuser_id", exeJobUserDyn.getPkValue());
        } else {
            obj.set("runbyuser_id", (Object)RequestContext.get().getCurrUserId());
        }
        obj.set(STATUS, (Object)"1");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(TRIGGER, trigger.getPkValue());
        obj.set("params", (Object)SerializationUtils.toJsonString(params));
        DynamicObjectCollection entries = obj.getDynamicObjectCollection("entryentity");
        entries.clear();
        DynamicObject param = new DynamicObject(entries.getDynamicObjectType());
        param.set("paramname", (Object)TRIGGER);
        param.set("paramvalue", (Object)trigger.getPkValue().toString());
        entries.add((Object)param);
        obj.set("name", trigger.get("name"));
        obj.set("runmode", (Object)"0");
        obj.set("runorder", (Object)"0");
        CommonUtil.check((OperationResult)OperationServiceHelper.executeOperate((String)"save", (String)ENTITY_SCH_JOB, (DynamicObject[])new DynamicObject[]{obj}, (OperateOption)this.getOperationOption()));
        return obj;
    }

    private Object createDataCopyTaskDefine(DynamicObject trigger) {
        QFilter filter = new QFilter("classname", "=", (Object)trigger.getString("handler"));
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)ENTITY_SCH_TASKDEFINE, (String)"id,name,number,classname,appid,paramentry,paramentry.paramname,paramentry.paramtype", (QFilter[])new QFilter[]{filter});
        if (obj == null) {
            obj = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_SCH_TASKDEFINE);
        }
        obj.set(NUMBER, (Object)(trigger.getString(NUMBER) + "_task"));
        obj.set("name", (Object)trigger.getString("name"));
        obj.set("classname", (Object)trigger.getString("handler"));
        obj.set("appid", (Object)"pbd");
        DynamicObjectCollection params = obj.getDynamicObjectCollection("paramentry");
        DynamicObject param = new DynamicObject(params.getDynamicObjectType());
        param.set("paramname", (Object)TRIGGER);
        param.set("paramtype", (Object)"1");
        params.add((Object)param);
        CommonUtil.check((OperationResult)OperationServiceHelper.executeOperate((String)"save", (String)ENTITY_SCH_TASKDEFINE, (DynamicObject[])new DynamicObject[]{obj}, (OperateOption)this.getOperationOption()));
        return obj.getPkValue();
    }

    private DynamicObject getExistedObject(String entityName, Object id) {
        if (QueryServiceHelper.exists((String)entityName, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)String.valueOf(id))})) {
            return BusinessDataServiceHelper.loadSingle((Object)id, (String)entityName);
        }
        DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)entityName);
        obj.set("id", id);
        return obj;
    }

    private OperateOption getOperationOption() {
        OperateOption option = OperateOption.create();
        option.setVariableValue("ignoreValidation", String.valueOf(Boolean.TRUE));
        option.setVariableValue("ishasright", String.valueOf(Boolean.TRUE));
        return option;
    }
}

