/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.opplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public final class PbdMallGoodsSaveOp
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog((String)PbdMallGoodsSaveOp.class.getName());

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("ecunit");
        e.getFieldKeys().add("unitid");
        e.getFieldKeys().add("source");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String string;
        super.beginOperationTransaction(e);
        HashSet<String> ecUnitNames = new HashSet<String>(16);
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities.length > 0 && !"pbd_mallgoods".equals(string = dataEntities[0].getDataEntityType().getName())) {
            return;
        }
        for (DynamicObject goods : dataEntities) {
            if (StringUtils.isBlank((CharSequence)goods.getString("ecunit"))) continue;
            ecUnitNames.add(goods.getString("ecunit"));
        }
        OperateOption operateOption = this.getOption();
        if (operateOption.containsVariable("unitmappingdelete")) {
            return;
        }
        BusinessDataServiceHelper.removeCache((DynamicObjectType)ORM.create().newDynamicObject("pmm_unitmapping").getDynamicObjectType());
        Map<String, Long> unitMappingMap = this.getUnitMappingMap(ecUnitNames);
        Map<String, Long> bdUnitMap = this.getBdUnitgMap(ecUnitNames);
        ArrayList<DynamicObject> addUnitMappings = new ArrayList<DynamicObject>(16);
        HashSet<String> addUnitMappMapKsys = new HashSet<String>();
        log.info("$$$startunitMapping");
        log.info("unitMappingMap=" + SerializationUtils.toJsonString(unitMappingMap));
        log.info("bdUnitMap=" + SerializationUtils.toJsonString(bdUnitMap));
        for (DynamicObject goods : dataEntities) {
            String platform = goods.getString("source");
            String ecunit = goods.getString("ecunit");
            if (StringUtils.isBlank((CharSequence)ecunit)) continue;
            log.info("ecunit=" + ecunit);
            String key = platform + "_" + ecunit;
            if (null == unitMappingMap.get(key)) {
                if (null != bdUnitMap.get(ecunit)) {
                    goods.set("unitid_id", (Object)bdUnitMap.get(ecunit));
                    log.info("unitid_id=" + bdUnitMap.get(ecunit));
                }
                if (!addUnitMappMapKsys.add(key)) continue;
                DynamicObject unitMappingInfo = this.newUnitMappingInfo(goods);
                if (null != bdUnitMap.get(ecunit)) {
                    unitMappingInfo.set("unit", (Object)bdUnitMap.get(ecunit));
                    unitMappingInfo.set("mappingresult", (Object)"1");
                }
                addUnitMappings.add(unitMappingInfo);
                addUnitMappMapKsys.add(key);
                continue;
            }
            long unitId = unitMappingMap.get(key);
            if (0L == unitId) {
                if (null == bdUnitMap.get(ecunit)) continue;
                goods.set("unitid_id", (Object)bdUnitMap.get(ecunit));
                log.info("unitid_id=" + bdUnitMap.get(ecunit));
                continue;
            }
            goods.set("unitid_id", (Object)unitId);
            log.info("unitid_id=" + unitId);
        }
        if (addUnitMappings.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])addUnitMappings.toArray(new DynamicObject[0]));
        }
    }

    private DynamicObject newUnitMappingInfo(DynamicObject goods) {
        DynamicObject unitMappingInfo = ORM.create().newDynamicObject("pmm_unitmapping");
        unitMappingInfo.set("ecunit", (Object)goods.getString("ecunit"));
        unitMappingInfo.set("platform", (Object)goods.getString("source"));
        unitMappingInfo.set("name", (Object)goods.getString("ecunit"));
        unitMappingInfo.set("mappingresult", (Object)"2");
        unitMappingInfo.set("creator", (Object)RequestContext.get().getCurrUserId());
        unitMappingInfo.set("modifier", (Object)RequestContext.get().getCurrUserId());
        unitMappingInfo.set("createtime", (Object)TimeServiceHelper.now());
        unitMappingInfo.set("modifytime", (Object)TimeServiceHelper.now());
        unitMappingInfo.set("enable", (Object)"1");
        unitMappingInfo.set("status", (Object)"C");
        return unitMappingInfo;
    }

    private Map<String, Long> getBdUnitgMap(Set<String> ecUnitNames) {
        HashMap<String, Long> bdUnitMap = new HashMap<String, Long>(16);
        QFilter qFilter = new QFilter("name", "in", ecUnitNames);
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        qFilter.and(new QFilter("status", "=", (Object)"C"));
        DynamicObjectCollection pmm_unitmapping = QueryServiceHelper.query((String)"bd_measureunits", (String)"name,id", (QFilter[])qFilter.toArray());
        for (DynamicObject row : pmm_unitmapping) {
            bdUnitMap.put(row.getString("name"), row.getLong("id"));
        }
        return bdUnitMap;
    }

    private Map<String, Long> getUnitMappingMap(Set<String> ecUnitNames) {
        HashMap<String, Long> unitMappingMap = new HashMap<String, Long>(16);
        QFilter qFilter = new QFilter("ecunit", "in", ecUnitNames);
        DynamicObjectCollection pmm_unitmapping = QueryServiceHelper.query((String)"pmm_unitmapping", (String)"ecunit,platform,unit", (QFilter[])qFilter.toArray());
        for (DynamicObject row : pmm_unitmapping) {
            unitMappingMap.put(row.getString("platform") + "_" + row.getString("ecunit"), row.getLong("unit"));
        }
        return unitMappingMap;
    }
}

