/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.service;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class PdsDbUpgradeService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(PdsDbUpgradeService.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setEl("warning");
        StringBuilder pProcessInfo = new StringBuilder();
        try {
            result.setLog("start upgrade mallgoods");
            ArrayList<String> filedList3 = new ArrayList<String>(1);
            filedList3.add("fnodename");
            this.upgrade("scm", filedList3, "fentryid", "t_pds_flownode", "t_pds_flownode_l", pProcessInfo);
            ArrayList<String> filedList4 = new ArrayList<String>(1);
            filedList4.add("fnodename");
            this.upgrade("scm", filedList4, "fdetailid", "t_pds_flownodesub", "t_pds_flownodesub_l", pProcessInfo);
            ArrayList<String> filedList7 = new ArrayList<String>(1);
            filedList7.add("fname");
            this.upgrade("scm", filedList7, "fid", "t_pds_costdetailtpl", "t_pds_costdetailtpl_l", pProcessInfo);
            ArrayList<String> filedList8 = new ArrayList<String>(2);
            filedList8.add("fdescription");
            filedList8.add("fnote");
            this.upgrade("scm", filedList8, "fdetailid", "t_pds_costdetailsubentry", "t_pds_costdetailsubentry_l", pProcessInfo);
            ArrayList<String> filedList13 = new ArrayList<String>(1);
            filedList13.add("fdescription");
            this.upgrade("scm", filedList13, "fid", "t_pds_flowconfig", "t_pds_flowconfig_l", pProcessInfo);
            ArrayList<String> filedList14 = new ArrayList<String>(1);
            filedList14.add("fnote");
            this.upgrade("scm", filedList14, "fentryid", "t_pds_defaultconfigentry", "t_pds_defaultconfigentry_l", pProcessInfo);
            ArrayList<String> filedList17 = new ArrayList<String>(1);
            filedList17.add("ffieldname");
            this.upgrade("scm", filedList17, "fentryid", "t_pds_compconfigentry", "t_pds_compconfigentry_l", pProcessInfo);
            ArrayList<String> filedList18 = new ArrayList<String>(1);
            filedList18.add("fdescription");
            this.upgrade("scm", filedList18, "fid", "t_pds_extdata", "t_pds_extdata_l", pProcessInfo);
            ArrayList<String> filedList19 = new ArrayList<String>(2);
            filedList19.add("fdescription");
            filedList19.add("fnote");
            this.upgrade("scm", filedList19, "fentryid", "t_pds_costdetailentry", "t_pds_costdetailentry_l", pProcessInfo);
            result.setSuccess(true);
        }
        catch (Exception e) {
            result.setErrorInfo(pProcessInfo.append(e.getMessage()).toString());
            result.setSuccess(false);
            throw new KDBizException(result.getErrorInfo());
        }
        return result;
    }

    public boolean upgrade(String dbKey, List<String> filedList, String idFiledName, String srcTableName, String tarTablename, StringBuilder pProcessInfo) {
        int pageSize = 2000;
        StringBuilder selectSql = new StringBuilder();
        selectSql.append("select ").append(idFiledName);
        for (String string : filedList) {
            selectSql.append(", ").append(string);
        }
        selectSql.append(" from  ").append(srcTableName);
        StringBuilder updateSql = new StringBuilder();
        updateSql.append("update ").append(tarTablename).append(" set ").append(idFiledName).append(" = ? ");
        for (String filed : filedList) {
            updateSql.append(", ").append(filed).append(" = ? ");
        }
        updateSql.append(" where  ").append(idFiledName).append(" = ? ").append("and flocaleid = 'zh_CN'");
        try (DataSet dataSet = this.getDataSet(dbKey, selectSql.toString());){
            ArrayList<Object[]> allParamsList = new ArrayList<Object[]>(2048);
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                ArrayList<Object> paramsList = new ArrayList<Object>(filedList.size() + 2);
                paramsList.add(row.get(idFiledName));
                for (String filed : filedList) {
                    paramsList.add(row.get(filed));
                }
                paramsList.add(row.get(idFiledName));
                allParamsList.add(paramsList.toArray());
                if (allParamsList.size() <= pageSize) continue;
                this.updateBatch(dbKey, updateSql.toString(), allParamsList);
                allParamsList.clear();
            }
            if (allParamsList.size() > 0) {
                this.updateBatch(dbKey, updateSql.toString(), allParamsList);
            }
        }
        return true;
    }

    private void updateBatch(String dbKey, String updateSql, List<Object[]> paramsList) {
        DBRoute dbRoute = DBRoute.of((String)dbKey);
        DB.executeBatch((DBRoute)dbRoute, (String)updateSql, paramsList);
    }

    private DataSet getDataSet(String dbKey, String sql) {
        DBRoute dbRoute = DBRoute.of((String)dbKey);
        return DB.queryDataSet((String)RequestContext.get().getTraceId(), (DBRoute)dbRoute, (String)sql);
    }
}

