/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.opplugin;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.TemplateUtil;

public class PdsBillCompTplDeleteOp
extends AbstractOperationServicePlugIn {
    private static Log log = LogFactory.getLog(PdsBillCompTplDeleteOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("template");
        e.getFieldKeys().add("tmp_template.tmp_bizobject");
        e.getFieldKeys().add("tmp_template.tmp_component");
        e.getFieldKeys().add("tmp_template.tmp_template");
        e.getFieldKeys().add("tplentry.tmp_bizobject");
        e.getFieldKeys().add("tplentry.tmp_template");
        e.getFieldKeys().add("tplentry.srctplid");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        DynamicObject[] datas = e.getDataEntities();
        ArrayList<Long> parentIdList = new ArrayList<Long>(datas.length);
        HashSet compKeySet = new HashSet(16);
        for (DynamicObject data : datas) {
            parentIdList.add(PdsCommonUtils.object2Long((Object)data.getPkValue()));
            List compKeyList = TemplateUtil.getCompKeyListByTplEntry((DynamicObject)data);
            compKeySet.addAll(compKeyList);
        }
        if (parentIdList.size() == 0 || compKeySet.size() == 0) {
            return;
        }
        QFilter filter = new QFilter("parentid", "in", parentIdList.stream().map(String::valueOf).collect(Collectors.toList()));
        filter.or("id", "in", parentIdList);
        StringBuilder logMsg = new StringBuilder();
        for (String compKey : compKeySet) {
            int row = DeleteServiceHelper.delete((String)compKey, (QFilter[])new QFilter[]{filter});
            if (row <= 0) continue;
            logMsg.append("###delete ").append(compKey).append(" success,parentID:").append(parentIdList).append(';');
        }
        log.info(logMsg.length() == 0 ? "###del log" : logMsg.toString());
    }
}

