/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.opplugin;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.pds.common.util.PdsCommonUtils;

public class PdsChgCompMobileOpTpl
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("id");
        e.getFieldKeys().add("parentid");
        e.getFieldKeys().add("billstatus");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs evt) {
        String key;
        switch (key = evt.getOperationKey()) {
            case "unsubmit2": 
            case "audit2": {
                List dataEntity = evt.getValidExtDataEntities();
                for (ExtendedDataEntity extDataEntity : dataEntity) {
                    DynamicObject billObj = extDataEntity.getDataEntity();
                    String billStatus = billObj.getString("billstatus");
                    if (BillStatusEnum.SUBMIT.getVal().equals(billStatus)) continue;
                    evt.setCancel(true);
                    evt.setCancelMessage(ResManager.loadKDString((String)"\u5df2\u63d0\u4ea4\u7684\u5355\u636e\u624d\u5141\u8bb8\u8fdb\u884c\u6b64\u64cd\u4f5c\u3002", (String)"PdsChgCompMobileOpTpl_0", (String)"scm-pds-opplugin", (Object[])new Object[0]));
                }
                break;
            }
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        super.beginOperationTransaction(args);
        DynamicObject[] compObjs = args.getDataEntities();
        Map<Long, DynamicObject> billObjMap = this.getChageObjMap(compObjs);
        block8: for (DynamicObject compObj : compObjs) {
            String operationKey;
            long parentId = PdsCommonUtils.object2Long((Object)compObj.getString("parentid"));
            DynamicObject billObj = billObjMap.get(parentId);
            if (null == billObj) continue;
            String billStatus = billObj.getString("billstatus");
            switch (operationKey = args.getOperationKey()) {
                case "unsubmit2": {
                    if (!BillStatusEnum.SUBMIT.getVal().equals(billStatus)) continue block8;
                    PdsCommonUtils.doOperation((DynamicObject)billObj, (String)"unsubmit");
                    continue block8;
                }
                case "audit2": {
                    if (!BillStatusEnum.SUBMIT.getVal().equals(billStatus)) continue block8;
                    PdsCommonUtils.doOperation((DynamicObject)billObj, (String)"audit");
                    continue block8;
                }
            }
        }
    }

    public Map<Long, DynamicObject> getChageObjMap(DynamicObject[] compObjs) {
        HashSet<Long> parentIds = new HashSet<Long>(compObjs.length);
        for (DynamicObject compObj : compObjs) {
            long parentId = PdsCommonUtils.object2Long((Object)compObj.getString("parentid"));
            parentIds.add(parentId);
        }
        QFilter filter = new QFilter("id", "in", parentIds);
        DynamicObject[] billObjs = BusinessDataServiceHelper.load((String)"src_bidchange", (String)"id,billstatus", (QFilter[])filter.toArray());
        HashMap<Long, DynamicObject> billObjMap = new HashMap<Long, DynamicObject>(parentIds.size());
        for (DynamicObject obj : billObjs) {
            billObjMap.put(obj.getLong("id"), obj);
        }
        return billObjMap;
    }
}

