/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.opplugin.validator;

import java.math.BigDecimal;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.scm.pds.common.util.PdsCostDetailUtils;
import kd.scm.pds.common.util.PdsMetadataUtil;
import kd.scm.pds.common.validator.ISrcValidator;
import kd.scm.pds.common.validator.SrcValidatorData;

public class PdsCostDetailCompValidator2
implements ISrcValidator {
    private static final long serialVersionUID = 1L;

    public void validate(SrcValidatorData context) {
        DynamicObject billObj = context.getBillObj();
        DynamicObjectCollection parentRowObjs = billObj.getDynamicObjectCollection("entryentity");
        if (parentRowObjs.size() == 0 || StringUtils.isBlank((CharSequence)((DynamicObject)parentRowObjs.get(0)).getString("description"))) {
            context.setSucced(false);
            context.setMessage(ResManager.loadKDString((String)"\u6210\u672c\u660e\u7ec6\u5206\u5f55\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff0c\u8bf7\u8f93\u5165\u6570\u636e\u3002", (String)"PdsCostDetailCompValidator2_0", (String)"scm-pds-opplugin", (Object[])new Object[0]));
            return;
        }
        if (!"2".equals(billObj.getString("origin"))) {
            return;
        }
        int index = 0;
        int parentIndex = 0;
        StringBuilder message = new StringBuilder();
        Map propetiesMap = PdsMetadataUtil.getProMap((String)"pds_costdetailcomp2");
        String fileldName = (String)propetiesMap.get("entryentity." + ("2".equals(billObj.getString("taxtype")) ? "price" : "taxprice"));
        for (int parentRow = 0; parentRow < parentRowObjs.size(); ++parentRow) {
            DynamicObject parentRowObj = (DynamicObject)parentRowObjs.get(parentRow);
            DynamicObjectCollection subRowObjs = parentRowObj.getDynamicObjectCollection("subentryentity");
            for (DynamicObject subRowObj : subRowObjs) {
                if (subRowObj.getBigDecimal("2".equals(billObj.getString("taxtype")) ? "subprice" : "subtaxprice").compareTo(BigDecimal.ZERO) == 0) {
                    parentIndex = parentRow;
                    message.append((CharSequence)PdsCostDetailUtils.buildMessage((int)parentIndex, (int)index, (String)fileldName.substring(fileldName.indexOf(".") + 1)));
                }
                ++index;
            }
            index = 0;
        }
        if (StringUtils.isNotBlank((CharSequence)message.toString())) {
            context.setSucced(false);
            context.setMessage(message.toString());
        }
    }
}

