/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.archive;

import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.archive.PdsFileContext;
import kd.scm.pds.common.archive.PdsFileFacade;
import kd.scm.pds.common.extfilter.ExtFilterUtils;
import kd.scm.pds.common.task.IPdsAutoTaskExecutor;
import kd.scm.pds.common.task.PdsAutoTaskContext;
import kd.scm.pds.common.util.ExtParameterUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.validator.SrcCommonValidatorHelper;

public class PdsAutoArchiveService
implements IPdsAutoTaskExecutor {
    private static final long serialVersionUID = 1L;

    @Override
    public synchronized void execute(PdsAutoTaskContext taskContext) {
        DynamicObject[] billObjs;
        QFilter qfilters = this.buildQFilter();
        Object batchnumberObj = taskContext.getParamMap().get("batchnumber");
        int batchnumber = (int)PdsCommonUtils.object2Long(batchnumberObj);
        if (batchnumber == 0) {
            batchnumber = 10;
        }
        boolean isRecordLog = this.isRecordLog(taskContext);
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_placeonfile", (String)"id", (QFilter[])qfilters.toArray(), (String)"billdate", (int)batchnumber);
        if (rows == null || rows.size() == 0) {
            BizLog.log((String)String.format(ResManager.loadKDString((String)"%1$s--\u81ea\u52a8\u5f52\u6863\uff1a\u6ca1\u6709\u7b26\u5408\u81ea\u52a8\u5f52\u6863\u7684\u9879\u76ee\uff0c\u67e5\u8be2\u6761\u4ef6\uff1a%2$s", (String)"PdsAutoArchiveService_0", (String)"scm-pds-common", (Object[])new Object[0]), this.getClass(), qfilters.toString()));
            return;
        }
        Set projectIds = rows.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
        QFilter qfilter = new QFilter("id", "in", projectIds);
        for (DynamicObject billObj : billObjs = PdsCommonUtils.loadBillObjsByQFilter("src_placeonfile", qfilter)) {
            String message = SrcCommonValidatorHelper.validate(billObj, "src_placeonfile", "gather", null);
            if (message != null && message.length() > 0) {
                if (!isRecordLog) continue;
                StringBuilder msgBuilder = new StringBuilder();
                msgBuilder.append("billno:").append(billObj.getString("billno")).append(",exceute validate fail msg:").append(message);
                BizLog.log((String)msgBuilder.toString());
                continue;
            }
            this.gatherAndArchive(billObj, isRecordLog);
        }
        BizLog.log((String)String.format(ResManager.loadKDString((String)"%1$s--\u81ea\u52a8\u5f52\u6863\uff1a\u5df2\u5904\u7406\u5355\u636e\u6570\uff1a%2$s", (String)"PdsAutoArchiveService_1", (String)"scm-pds-common", (Object[])new Object[0]), this.getClass(), billObjs.length));
    }

    protected void gatherAndArchive(DynamicObject billObj, boolean isRecordLog) {
        QFilter qfilters = new QFilter("id", "=", (Object)SrmCommonUtil.getPkValue((DynamicObject)billObj));
        qfilters.and("isarchived", "=", (Object)false);
        if (QueryServiceHelper.exists((String)"src_placeonfile", (QFilter[])qfilters.toArray())) {
            PdsFileContext context = new PdsFileContext();
            context.setBillObj(billObj);
            PdsFileFacade.fileGather(context);
            if (!context.isSucced()) {
                this.recordLog(isRecordLog, billObj.getString("billno") + '_' + "collect error\uff1a" + context.getMessage());
            } else {
                this.recordLog(isRecordLog, billObj.getString("billno") + '_' + "collect succed\uff01");
                PdsFileFacade.fileArchive(context);
                if (!context.isSucced()) {
                    this.recordLog(isRecordLog, billObj.getString("billno") + '_' + "archive error\uff1a" + context.getMessage());
                } else {
                    this.recordLog(isRecordLog, billObj.getString("billno") + '_' + "archive succed\uff01");
                }
            }
        }
    }

    protected QFilter buildQFilter() {
        QFilter qfilters = ExtFilterUtils.getExtQFilters("pds_extfilter", "src_placeonfile", null, null);
        qfilters.and("isarchived", "=", (Object)false);
        return qfilters;
    }

    protected boolean isRecordLog(PdsAutoTaskContext taskContext) {
        Object recordLog = taskContext.getParamMap().get("recordlog");
        if (recordLog != null) {
            return ExtParameterUtils.convertToBoolen(recordLog);
        }
        return false;
    }

    protected void recordLog(boolean isRecordLog, String message) {
        if (isRecordLog) {
            BizLog.log((String)String.format(ResManager.loadKDString((String)"%1$s--\u81ea\u52a8\u5f52\u6863\uff1a\u5f52\u6863\u60c5\u51b5\uff1a%2$s", (String)"PdsAutoArchiveService_2", (String)"scm-pds-common", (Object[])new Object[0]), this.getClass(), message));
        }
    }
}

