/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.archive;

import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.scm.pds.common.archive.IPdsFileHandler;
import kd.scm.pds.common.archive.PdsFileContext;
import kd.scm.pds.common.archive.archive.IPdsFileArchive;
import kd.scm.pds.common.archive.gather.IPdsFileCommonGather;
import kd.scm.pds.common.archive.gather.IPdsFileSpecialGather;
import kd.scm.pds.common.archive.gather.PdsFileBillAttachGather;
import kd.scm.pds.common.archive.gather.PdsFileEntryAttachGather;
import kd.scm.pds.common.archive.gather.PdsFileReportGather;
import kd.scm.pds.common.archive.gather.PdsFileRichtextGather;
import kd.scm.pds.common.archive.getdata.IPdsFileGetData;
import kd.scm.pds.common.archive.getdata.PdsFileGetQFilterByFilter;
import kd.scm.pds.common.archive.getdata.PdsFileGetQFilterByKey;
import kd.scm.pds.common.archive.getdata.PdsFileGetQFilterByParent;
import kd.scm.pds.common.archive.getdata.PdsFileGetQFilterByPlugin;
import kd.scm.pds.common.archive.save.IPdsFileSaveResult;
import kd.scm.pds.common.extplugin.ExtPluginFactory;
import kd.scm.pds.common.util.MultiBasedataUtils;

public class PdsFileFacade {
    public static void fileGather(PdsFileContext context) {
        PdsFileFacade.getData(context);
        PdsFileFacade.commonGather(context);
        PdsFileFacade.specialGather(context);
        PdsFileFacade.saveResult(context);
    }

    public static void fileGatherUnsave(PdsFileContext context) {
        PdsFileFacade.getData(context);
        PdsFileFacade.commonGather(context);
        PdsFileFacade.specialGather(context);
    }

    private static void getData(PdsFileContext context) {
        List handlers = ExtPluginFactory.getInstance().getExtPluginInstancesSingle(IPdsFileGetData.class.getSimpleName(), null);
        for (IPdsFileHandler handler : handlers) {
            if (!context.isSucced()) continue;
            handler.process(context);
        }
    }

    private static void commonGather(PdsFileContext context) {
        List handlers = ExtPluginFactory.getInstance().getExtPluginInstancesSingle(IPdsFileCommonGather.class.getSimpleName(), null);
        for (IPdsFileHandler handler : handlers) {
            if (!context.isSucced()) continue;
            handler.process(context);
        }
    }

    private static void specialGather(PdsFileContext context) {
        List handlers = ExtPluginFactory.getInstance().getExtPluginInstancesSingle(IPdsFileSpecialGather.class.getSimpleName(), null);
        for (IPdsFileHandler handler : handlers) {
            if (!context.isSucced()) continue;
            handler.process(context);
        }
    }

    private static void saveResult(PdsFileContext context) {
        List handlers = ExtPluginFactory.getInstance().getExtPluginInstancesSingle(IPdsFileSaveResult.class.getSimpleName(), null);
        for (IPdsFileHandler handler : handlers) {
            if (!context.isSucced()) continue;
            handler.process(context);
        }
    }

    public static void fileArchive(PdsFileContext context) {
        List handlers = ExtPluginFactory.getInstance().getExtPluginInstancesSingle(IPdsFileArchive.class.getSimpleName(), null);
        for (IPdsFileHandler handler : handlers) {
            if (!context.isSucced()) continue;
            handler.process(context);
        }
    }

    public static void getQFilterByFilterType(PdsFileContext context) {
        String filtertype;
        IPdsFileHandler handler = null;
        switch (filtertype = context.getCurrentFileObj().getString("filtertype")) {
            case "1": {
                handler = (IPdsFileHandler)ExtPluginFactory.getInstance().getExtPluginInstanceSingle(PdsFileGetQFilterByKey.class.getSimpleName(), PdsFileGetQFilterByKey.class.getName());
                break;
            }
            case "2": {
                handler = (IPdsFileHandler)ExtPluginFactory.getInstance().getExtPluginInstanceSingle(PdsFileGetQFilterByParent.class.getSimpleName(), PdsFileGetQFilterByParent.class.getName());
                break;
            }
            case "3": {
                handler = (IPdsFileHandler)ExtPluginFactory.getInstance().getExtPluginInstanceSingle(PdsFileGetQFilterByPlugin.class.getSimpleName(), PdsFileGetQFilterByPlugin.class.getName());
                break;
            }
            case "4": {
                handler = (IPdsFileHandler)ExtPluginFactory.getInstance().getExtPluginInstanceSingle(PdsFileGetQFilterByFilter.class.getSimpleName(), PdsFileGetQFilterByFilter.class.getName());
                break;
            }
        }
        if (null != handler) {
            handler.process(context);
        }
    }

    public static void billAttachGather(PdsFileContext context) {
        List handlers = ExtPluginFactory.getInstance().getExtPluginInstancesSingle(PdsFileBillAttachGather.class.getSimpleName(), PdsFileBillAttachGather.class.getName());
        for (IPdsFileHandler handler : handlers) {
            handler.process(context);
        }
    }

    public static void entryAttachGather(PdsFileContext context) {
        List handlers = ExtPluginFactory.getInstance().getExtPluginInstancesSingle(PdsFileEntryAttachGather.class.getSimpleName(), PdsFileEntryAttachGather.class.getName());
        for (IPdsFileHandler handler : handlers) {
            handler.process(context);
        }
    }

    public static void reportAttachGather(PdsFileContext context) {
        List handlers = ExtPluginFactory.getInstance().getExtPluginInstancesSingle(PdsFileReportGather.class.getSimpleName(), PdsFileReportGather.class.getName());
        for (IPdsFileHandler handler : handlers) {
            handler.process(context);
        }
    }

    public static void richtextAttachGather(PdsFileContext context) {
        List handlers = ExtPluginFactory.getInstance().getExtPluginInstancesSingle(PdsFileRichtextGather.class.getSimpleName(), PdsFileRichtextGather.class.getName());
        for (IPdsFileHandler handler : handlers) {
            handler.process(context);
        }
    }

    public static boolean isMatchSrctypeOrSrcflow(PdsFileContext context, DynamicObject attachRow, String sourcetypeField, String sourceflowField) {
        Set<Long> sourcetypeIds = MultiBasedataUtils.getBasedataIdSet(attachRow, sourcetypeField);
        Set<Long> sourceflowIds = MultiBasedataUtils.getBasedataIdSet(attachRow, sourceflowField);
        if (!(null != sourcetypeIds && sourcetypeIds.size() != 0 || null != sourceflowIds && sourceflowIds.size() != 0)) {
            return true;
        }
        if (null != sourcetypeIds && sourcetypeIds.size() > 0 && sourcetypeIds.contains(context.getSourcetypeId())) {
            return true;
        }
        return null != sourceflowIds && sourceflowIds.size() > 0 && sourceflowIds.contains(context.getSourceflowId());
    }
}

