/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.archive.archive;

import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.attachment.AttachmentFieldServiceHelper;
import kd.bos.url.UrlService;
import kd.scm.pds.common.archive.PdsFileContext;
import kd.scm.pds.common.archive.archive.IPdsFileArchive;
import kd.scm.pds.common.attach.AttachmentUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import org.apache.commons.lang3.StringUtils;

public class PdsFileArchiveUpload
implements IPdsFileArchive {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(PdsFileContext context) {
        DynamicObject billObj = context.getBillObj();
        String filemethod = billObj.getString("filescheme.filemethod.number");
        if (!"SYS001".equals(filemethod)) {
            context.setMessage(ResManager.loadKDString((String)"\u6807\u51c6\u4ea7\u54c1\u5f52\u6863\u4ec5\u652f\u6301\u5f52\u6863\u65b9\u5f0f\u4e3a\uff1aSYS001--\u4e0a\u4f20\u5230\u91d1\u8776\u4e91\u82cd\u7a79\u6587\u4ef6\u670d\u52a1\u5668\uff0c\u8bf7\u4fee\u6539\u5f52\u6863\u65b9\u5f0f\u6216\u4e8c\u5f00\u66ff\u6362\u6b64\u63d2\u4ef6\u3002", (String)"PdsFileArchiveUpload_4", (String)"scm-pds-common", (Object[])new Object[0]));
            context.setSucced(false);
            return;
        }
        DynamicObject archiveObj = BusinessDataServiceHelper.loadSingle((Object)billObj.getPkValue(), (String)"src_archivefile");
        DynamicObjectCollection entryRows = archiveObj.getDynamicObjectCollection("entryentity");
        if (entryRows.size() == 0) {
            context.setMessage(ResManager.loadKDString((String)"\u5f52\u6863\u660e\u7ec6\u4e3a\u7a7a\uff0c\u8bf7\u5148\u6536\u96c6\u8d44\u6599\u540e\uff0c\u518d\u8fdb\u884c\u5f52\u6863\u5904\u7406\u3002", (String)"PdsFileArchiveUpload_3", (String)"scm-pds-common", (Object[])new Object[0]));
            context.setSucced(false);
            return;
        }
        boolean isAllArchived = true;
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        for (DynamicObject entryRow : entryRows) {
            DynamicObjectCollection newAttachRows = entryRow.getDynamicObjectCollection("newfileattach");
            newAttachRows.removeAll((Collection)newAttachRows);
            DynamicObjectCollection attachRows = entryRow.getDynamicObjectCollection("fileattach");
            for (DynamicObject attachRow : attachRows) {
                String newUrl = this.getUploadedUrl(attachRow);
                if (StringUtils.isBlank((CharSequence)newUrl)) {
                    newUrl = this.upLoadAttachment(context, fileService, entryRow, attachRow);
                }
                if (StringUtils.isBlank((CharSequence)newUrl)) {
                    isAllArchived = false;
                    continue;
                }
                this.updateArchiveInfo(context, entryRow, newAttachRows, attachRow.getDynamicObject("fbasedataid"), newUrl);
            }
        }
        PdsCommonUtils.saveDynamicObjects(archiveObj);
        if (isAllArchived) {
            billObj.set("isarchived", (Object)"1");
            PdsCommonUtils.saveDynamicObjects(billObj);
        } else {
            context.setMessage(ResManager.loadKDString((String)"\u8d44\u6599\u672a\u5168\u90e8\u5f52\u6863\u6210\u529f\uff0c\u8bf7\u68c0\u67e5\u5f52\u6863\u524d\u9644\u4ef6\u662f\u5426\u6709\u6548\u3002", (String)"PdsFileArchiveUpload_5", (String)"scm-pds-common", (Object[])new Object[0]));
            context.setSucced(false);
        }
    }

    protected String upLoadAttachment(PdsFileContext context, FileService fileService, DynamicObject entryRow, DynamicObject attachRow) {
        DynamicObject attachInfo = attachRow.getDynamicObject("fbasedataid");
        if (null == attachInfo) {
            return null;
        }
        String fileName = attachInfo.getString("name");
        String url = attachInfo.getString("url");
        if (StringUtils.isBlank((CharSequence)url)) {
            return null;
        }
        String fileUrl = url.replace(UrlService.getAttachmentPrefixUrl(), "");
        if (StringUtils.isBlank((CharSequence)fileUrl)) {
            return null;
        }
        String catalogue = entryRow.getString("filecatalogue.number");
        String uploadPath = context.getPath() + '/' + catalogue + '/' + fileName;
        try {
            InputStream in = fileService.getInputStream(fileUrl);
            FileItem fileItem = null;
            fileItem = new FileItem(fileName, uploadPath, in);
            fileItem.setCreateNewFileWhenExists(false);
            String newUrl = fileService.upload(fileItem);
            return newUrl;
        }
        catch (Exception e) {
            context.setMessage(String.format(ResManager.loadKDString((String)"\u5f52\u6863\u5931\u8d25\uff0c\u9519\u8bef\u539f\u56e0\uff1a%1$s", (String)"PdsFileArchiveUpload_1", (String)"scm-pds-common", (Object[])new Object[0]), e.getMessage()));
            context.setSucced(false);
            return null;
        }
    }

    protected void updateArchiveInfo(PdsFileContext context, DynamicObject entryRow, DynamicObjectCollection newAttachRows, DynamicObject attachInfo, String attachmentUrl) {
        HashMap<String, Object> attachment = new HashMap<String, Object>();
        AttachmentUtils.setAttachMapValue(attachment, attachInfo);
        String newUid = attachment.get("uid") + "_new";
        attachment.put("uid", newUid);
        attachment.put("url", UrlService.getAttachmentFullUrl((String)attachmentUrl));
        DynamicObject newAttachInfo = AttachmentFieldServiceHelper.getAttCreatorByUID((String)newUid);
        if (null == newAttachInfo) {
            newAttachInfo = AttachmentUtils.createBdAttachment(attachment);
        }
        DynamicObject newAttachRow = newAttachRows.addNew();
        newAttachRow.set("fbasedataid", newAttachInfo.getPkValue());
        if ("3".equals(context.getBelongtoType())) {
            entryRow.set("fileurl", (Object)UrlService.getAttachmentFullUrl((String)attachmentUrl));
        }
    }

    private String getUploadedUrl(DynamicObject attachRow) {
        DynamicObject attachInfo = attachRow.getDynamicObject("fbasedataid");
        if (null == attachInfo) {
            return null;
        }
        DynamicObject newAttachInfo = AttachmentFieldServiceHelper.getAttCreatorByUID((String)(attachInfo.getString("uid") + "_new"));
        if (null == newAttachInfo) {
            return null;
        }
        return newAttachInfo.getString("url");
    }
}

