/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.archive.gather;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.scm.pds.common.archive.PdsFileContext;
import kd.scm.pds.common.archive.PdsFileFacade;
import kd.scm.pds.common.archive.gather.IPdsFileCommonGather;
import org.apache.commons.lang3.StringUtils;

public class PdsFileBillAttachGather
implements IPdsFileCommonGather {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(PdsFileContext context) {
        DynamicObjectCollection billAttachRows = context.getCurrentFileObj().getDynamicObjectCollection("billattachments");
        if (null == billAttachRows || billAttachRows.size() == 0) {
            return;
        }
        ArrayList<Map> attachList = new ArrayList<Map>(16);
        for (DynamicObject billAttachRow : billAttachRows) {
            String attachKey = billAttachRow.getString("billattach");
            if (StringUtils.isBlank((CharSequence)attachKey) || !PdsFileFacade.isMatchSrctypeOrSrcflow(context, billAttachRow, "billsrctype", "billsrcflow")) continue;
            for (DynamicObject currentFileData : context.getCurrentFileDatas()) {
                List attachMaps = AttachmentServiceHelper.getAttachments((String)context.getCurrentFileObjEntity(), (Object)currentFileData.getPkValue(), (String)attachKey, (boolean)false);
                for (Map attachMap : attachMaps) {
                    attachMap.put("fileobject", context.getCurrentFileObj());
                    attachMap.put("filecatalogue", context.getCurrentFileCatalogue());
                    attachMap.put("fileobjectdata", currentFileData);
                    attachList.add(attachMap);
                }
            }
        }
        context.getAttachments().addAll(attachList);
    }
}

