/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.archive.gather;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.scm.pds.common.archive.PdsFileContext;
import kd.scm.pds.common.archive.PdsFileFacade;
import kd.scm.pds.common.archive.gather.IPdsFileCommonGather;
import kd.scm.pds.common.attach.AttachmentUtils;
import org.apache.commons.lang3.StringUtils;

public class PdsFileEntryAttachGather
implements IPdsFileCommonGather {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(PdsFileContext context) {
        DynamicObjectCollection entryAttachRows = context.getCurrentFileObj().getDynamicObjectCollection("entryattachments");
        if (null == entryAttachRows || entryAttachRows.size() == 0) {
            return;
        }
        ArrayList<Map<String, Object>> attachList = new ArrayList<Map<String, Object>>(8);
        for (DynamicObject entryAttachRow : entryAttachRows) {
            String attachKey = entryAttachRow.getString("entryattach");
            if (StringUtils.isBlank((CharSequence)attachKey) || !PdsFileFacade.isMatchSrctypeOrSrcflow(context, entryAttachRow, "entrysrctype", "entrysrcflow")) continue;
            String[] attachKeys = attachKey.split("\\.");
            if (attachKeys.length > 1) {
                for (DynamicObject currentFileData : context.getCurrentFileDatas()) {
                    this.handleEntryAttachment(context, currentFileData, attachList, attachKeys);
                }
                continue;
            }
            this.handleBillAttachment(context, context.getCurrentFileDatas(), attachList, attachKeys);
        }
        context.getAttachments().addAll(attachList);
    }

    private void handleEntryAttachment(PdsFileContext context, DynamicObject currentFileData, List<Map<String, Object>> attachList, String[] attachKeys) {
        DynamicObjectCollection entryRows = currentFileData.getDynamicObjectCollection(attachKeys[0]);
        for (DynamicObject entryRow : entryRows) {
            DynamicObjectCollection attachRows = entryRow.getDynamicObjectCollection(attachKeys[1]);
            for (DynamicObject attachRow : attachRows) {
                this.handleAttachment(context, entryRow, attachRow, attachList);
            }
        }
    }

    private void handleBillAttachment(PdsFileContext context, DynamicObject[] entryRows, List<Map<String, Object>> attachList, String[] attachKeys) {
        for (DynamicObject entryRow : entryRows) {
            DynamicObjectCollection attachRows = entryRow.getDynamicObjectCollection(attachKeys[0]);
            for (DynamicObject attachRow : attachRows) {
                this.handleAttachment(context, entryRow, attachRow, attachList);
            }
        }
    }

    private void handleAttachment(PdsFileContext context, DynamicObject entryRow, DynamicObject attachRow, List<Map<String, Object>> attachList) {
        DynamicObject attachInfoObj = attachRow.getDynamicObject("fbasedataid");
        HashMap<String, Object> attachMap = new HashMap<String, Object>(16);
        AttachmentUtils.setAttachMapValue(attachMap, attachInfoObj);
        attachMap.put("fileobject", context.getCurrentFileObj());
        attachMap.put("filecatalogue", context.getCurrentFileCatalogue());
        attachMap.put("fileobjectdata", entryRow);
        attachList.add(attachMap);
    }
}

