/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.archive.gather;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.scm.pds.common.archive.PdsFileContext;
import kd.scm.pds.common.archive.PdsFileFacade;
import kd.scm.pds.common.archive.gather.IPdsFileCommonGather;
import kd.scm.pds.common.util.PdsReportUtils;

public class PdsFileReportGather
implements IPdsFileCommonGather {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(PdsFileContext context) {
        DynamicObjectCollection reportAttachRows = context.getCurrentFileObj().getDynamicObjectCollection("reportattachments");
        if (null == reportAttachRows || reportAttachRows.size() == 0) {
            return;
        }
        for (DynamicObject reportAttachRow : reportAttachRows) {
            if (!PdsFileFacade.isMatchSrctypeOrSrcflow(context, reportAttachRow, "reportsrctype", "reportsrcflow")) continue;
            String prtTplId = reportAttachRow.getString("reportattach.id");
            for (DynamicObject currentFileData : context.getCurrentFileDatas()) {
                this.createFieldAttachment(context, currentFileData, prtTplId);
            }
        }
    }

    private void createFieldAttachment(PdsFileContext context, DynamicObject currentFileData, String prtTplId) {
        ArrayList<Map<String, Object>> attachList = new ArrayList<Map<String, Object>>(16);
        List<Map<String, Object>> attachMaps = PdsReportUtils.createFieldAttachment(currentFileData, prtTplId, null);
        for (Map<String, Object> attachMap : attachMaps) {
            attachMap.put("fileobject", context.getCurrentFileObj());
            attachMap.put("filecatalogue", context.getCurrentFileCatalogue());
            attachMap.put("fileobjectdata", currentFileData);
            attachList.add(attachMap);
        }
        context.getAttachments().addAll(attachList);
    }
}

