/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.archive.getdata;

import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.archive.PdsFileContext;
import kd.scm.pds.common.archive.getdata.IPdsFileGetData;

public class PdsFileGetData
implements IPdsFileGetData {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(PdsFileContext context) {
        HashMap<Long, DynamicObject[]> dataMap = new HashMap<Long, DynamicObject[]>(context.getFileObjectRows().size());
        for (DynamicObject row : context.getFileObjectRows()) {
            QFilter qfilter;
            DynamicObject fileObject = row.getDynamicObject("fileobject");
            if (null == fileObject) continue;
            long fileObjectId = SrmCommonUtil.getPkValue((DynamicObject)fileObject);
            String entityName = fileObject.getString("bizobject.number");
            DynamicObject[] data = PdsFileGetData.getObjs(entityName, this.getRows(entityName, qfilter = context.getQfilterMap().get(fileObjectId)));
            if (null == data || data.length <= 0) continue;
            dataMap.put(fileObjectId, data);
        }
        context.setDataMap(dataMap);
    }

    private DynamicObjectCollection getRows(String entityName, QFilter qfilter) {
        if (null == entityName || null == qfilter) {
            return null;
        }
        return QueryServiceHelper.query((String)entityName, (String)"id", (QFilter[])qfilter.toArray());
    }

    public static DynamicObject[] getObjs(String entityName, DynamicObjectCollection rows) {
        if (null == rows || rows.size() == 0) {
            return null;
        }
        List<Long> idList = rows.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
        Object[] pkIds = idList.toArray(new Long[0]);
        DynamicObject[] objs = BusinessDataServiceHelper.load((Object[])pkIds, (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)entityName).getDynamicObjectType());
        return objs;
    }
}

