/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.archive.getdata;

import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pds.common.archive.IPdsFileHandler;
import kd.scm.pds.common.archive.PdsFileContext;
import org.apache.commons.lang3.StringUtils;

public class PdsFileGetQFilterByParent
implements IPdsFileHandler {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(PdsFileContext context) {
        String pentitykey = context.getCurrentFileObj().getString("pentitykey.number");
        String pkeyfield = context.getCurrentFileObj().getString("pkeyfield");
        if (StringUtils.isBlank((CharSequence)pentitykey) || StringUtils.isBlank((CharSequence)pkeyfield)) {
            return;
        }
        QFilter pQFilter = new QFilter(pkeyfield, "=", (Object)context.getKeyValue());
        DynamicObjectCollection rows = QueryServiceHelper.query((String)pentitykey, (String)"id", (QFilter[])pQFilter.toArray());
        if (null == rows || rows.size() == 0) {
            return;
        }
        Set billIds = rows.stream().map(e -> e.getString("id")).collect(Collectors.toSet());
        String entitykey = context.getCurrentFileObj().getString("bizobject.number");
        QFilter qfilter = new QFilter("parentid", "in", billIds);
        if ("src_purlist".equals(pentitykey)) {
            qfilter.and(new QFilter("pentitykey", "=", (Object)pentitykey).or("pentitykey", "=", (Object)"src_project"));
        } else {
            qfilter.and("pentitykey", "=", (Object)pentitykey);
        }
        qfilter.and("entitykey", "=", (Object)entitykey);
        context.setCurrentQFilter(qfilter);
    }
}

