/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.archive.save;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.servicehelper.attachment.AttachmentFieldServiceHelper;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.archive.PdsFileContext;
import kd.scm.pds.common.archive.save.IPdsFileSaveResult;
import kd.scm.pds.common.attach.AttachmentUtils;
import kd.scm.pds.common.util.MultiBasedataUtils;

public class PdsFileBeforeSaveResult
implements IPdsFileSaveResult {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(PdsFileContext context) {
        this.beforeSaveResult(context);
    }

    protected void beforeSaveResult(PdsFileContext context) {
        DynamicObject archiveObj = context.getArchiveFileObj();
        DynamicObjectCollection rows = archiveObj.getDynamicObjectCollection("entryentity");
        rows.removeAll((Collection)rows);
        for (Map<String, Object> attachment : context.getAttachments()) {
            DynamicObject fileObject = (DynamicObject)attachment.get("fileobject");
            DynamicObject fileObjectData = (DynamicObject)attachment.get("fileobjectdata");
            DynamicObject fileCatalogue = (DynamicObject)attachment.get("filecatalogue");
            DynamicObject attObj = AttachmentFieldServiceHelper.getAttCreatorByUID((String)((String)attachment.get("uid")));
            if (null == attObj) {
                attObj = AttachmentUtils.createBdAttachment(attachment);
            }
            if (null == attObj) continue;
            DynamicObject row = this.getBelongtoRow(context, fileCatalogue, fileObject, rows);
            if (null == row) {
                row = rows.addNew();
                if ("3".equals(context.getBelongtoType())) {
                    row.set("attachment", attObj.getPkValue());
                    if (null != fileObjectData.getDynamicObjectType().getProperties().get((Object)"package")) {
                        row.set("package", fileObjectData.get("package"));
                    }
                    if (null != fileObjectData.getDynamicObjectType().getProperties().get((Object)"suppliertype")) {
                        row.set("suppliertype", fileObjectData.get("suppliertype"));
                    }
                    if (null != fileObjectData.getDynamicObjectType().getProperties().get((Object)"supplier")) {
                        row.set("supplier", fileObjectData.get("supplier"));
                    }
                }
                if ("2".equals(context.getBelongtoType()) || "3".equals(context.getBelongtoType())) {
                    row.set("fileobject", (Object)fileObject);
                }
                row.set("filecatalogue", (Object)fileCatalogue);
            }
            if (MultiBasedataUtils.getBasedataIdSet(row, "fileattach").contains(attObj.getPkValue())) continue;
            DynamicObjectCollection attachRows = row.getDynamicObjectCollection("fileattach");
            DynamicObject attachRow = attachRows.addNew();
            attachRow.set("fbasedataid", attObj.getPkValue());
        }
    }

    private DynamicObject getBelongtoRow(PdsFileContext context, DynamicObject fileCatalogue, DynamicObject fileObject, DynamicObjectCollection rows) {
        String groupType;
        List belongtoRows = null;
        switch (groupType = context.getFileSchemeObj().getString("type")) {
            case "1": {
                belongtoRows = rows.stream().filter(e -> e.getLong("filecatalogue.id") == SrmCommonUtil.getPkValue((DynamicObject)fileCatalogue)).collect(Collectors.toList());
                break;
            }
            case "2": {
                belongtoRows = rows.stream().filter(e -> e.getLong("fileobject.id") == SrmCommonUtil.getPkValue((DynamicObject)fileObject)).collect(Collectors.toList());
                break;
            }
            case "3": {
                break;
            }
        }
        if (null == belongtoRows || belongtoRows.size() == 0) {
            return null;
        }
        return (DynamicObject)belongtoRows.get(0);
    }
}

