/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.attach;

import java.io.InputStream;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.IFormView;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.print.service.BosPrintServiceHelper;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.attachment.AttachmentFieldServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.FileNameUtils;
import kd.bos.web.actions.utils.FilePathUtil;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.archive.PdsFileContext;
import kd.scm.pds.common.archive.PdsFileFacade;
import kd.scm.pds.common.archive.schemefilter.IFileSchemeFilter;
import kd.scm.pds.common.attach.IPdsAttachHandler;
import kd.scm.pds.common.attach.PdsAttachContext;
import kd.scm.pds.common.enums.ProjectStatusEnums;
import kd.scm.pds.common.extfilter.SchemeFilterUtils;
import kd.scm.pds.common.extplugin.ExtPluginFactory;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.PdsReportUtils;

public class AttachmentUtils {
    private static final Log log = LogFactory.getLog(AttachmentUtils.class);

    public static String getAttachFileName(DynamicObjectCollection attachRows) {
        if (null == attachRows || attachRows.size() == 0) {
            return "";
        }
        ArrayList<DynamicObject> attachObjs = new ArrayList<DynamicObject>(attachRows.size());
        for (DynamicObject attachRow : attachRows) {
            DynamicObject attachObj = attachRow.getDynamicObject("fbasedataid");
            attachObjs.add(attachObj);
        }
        return AttachmentUtils.getAttachFileName(attachObjs);
    }

    public static String getAttachFileName(List<DynamicObject> attachObjs) {
        if (null == attachObjs || attachObjs.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (DynamicObject attachObj : attachObjs) {
            String fileName;
            if (null == attachObj || StringUtils.isBlank((CharSequence)attachObj.getString("name")) || StringUtils.isEmpty((CharSequence)(fileName = attachObj.getString("name")))) continue;
            try {
                fileName = fileName.substring(0, fileName.lastIndexOf(46) <= 0 ? fileName.length() : fileName.lastIndexOf(46));
                fileName = fileName.replace('&', '_').replace('/', '_').replace('\\', '_').replace('\'', '_').replace(':', '_').replace('|', '_').replace('*', '_').replace('?', '_').replace('<', '_').replace('>', '_').replace('\uff01', '_').replace('@', '_').replace('#', '_').replace('\uffe5', '_').replace('%', '_').replace('\u2026', '_').replace('\uff08', '(').replace('\uff09', ')').replace('\u2014', '_').replace('+', '_').replace('=', '_').replace('-', '_').replace('.', '_').replace('\'', '_').replace(':', '_').replace('\uff1f', '_').replace('~', '_').replace('\u00b7', '_').replace(';', '_').replace('\u201c', '_').replace('\u2018', '_');
                sb.append(fileName).append(';');
            }
            catch (Exception e) {}
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static String getAttachFileName(IFormView view, String attachField, int index) {
        return AttachmentUtils.getAttachFileName((DynamicObjectCollection)view.getModel().getValue(attachField, index));
    }

    public static void setAttachFileName(IFormView view, int index) {
        view.getModel().setValue("packfilename", (Object)AttachmentUtils.getAttachFileName((DynamicObjectCollection)view.getModel().getValue("bidattach", index)), index);
    }

    public static void setAttachFileName(IFormView view, String attachNameField, String attachField, int index) {
        view.getModel().setValue(attachNameField, (Object)AttachmentUtils.getAttachFileName((DynamicObjectCollection)view.getModel().getValue(attachField, index)), index);
    }

    public static List<Map<String, Object>> getEntryAttachments(String entityName, QFilter qfilter, String attachName, long billId) {
        String selectFields = DynamicObjectUtil.getSelectfields((String)entityName, (boolean)true);
        DynamicObject[] entryRows = BusinessDataServiceHelper.load((String)entityName, (String)selectFields, (QFilter[])qfilter.toArray());
        if (null == entryRows || entryRows.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Map<String, Object>> attachList = new ArrayList<Map<String, Object>>(16);
        for (DynamicObject entryRow : entryRows) {
            DynamicObjectCollection attachRows = entryRow.getDynamicObjectCollection(attachName);
            if (null == attachRows || attachRows.size() == 0) continue;
            for (DynamicObject attachRow : attachRows) {
                DynamicObject attachInfo = attachRow.getDynamicObject("fbasedataid");
                if (null == attachInfo) continue;
                HashMap<String, Object> attachMap = new HashMap<String, Object>(16);
                attachMap.put("billPkId", String.valueOf(billId));
                attachMap.put("suppliername", AttachmentUtils.getSupplierName(entryRow, selectFields));
                AttachmentUtils.setAttachMapValue(attachMap, attachInfo);
                attachList.add(attachMap);
            }
        }
        return attachList;
    }

    private static String getSupplierName(DynamicObject entryRow, String selectFields) {
        DynamicObject supplierObj;
        String supplierName = "";
        if (selectFields.contains("supplier") && null != (supplierObj = entryRow.getDynamicObject("supplier"))) {
            supplierName = supplierObj.getString("name");
        }
        return supplierName;
    }

    public static void setAttachMapValue(Map<String, Object> attachMap, DynamicObject attachInfo) {
        attachMap.put("attPkId", attachInfo.get("id"));
        attachMap.put("creator", attachInfo.get("creator"));
        attachMap.put("createdate", attachInfo.get("createtime"));
        attachMap.put("type", attachInfo.get("type"));
        attachMap.put("url", AttachmentUtils.getFullUrl(attachInfo.get("url")));
        AttachmentUtils.setPreviewUrl(attachMap, attachInfo.get("previewurl"), attachInfo.get("url"));
        attachMap.put("uid", attachInfo.get("uid"));
        attachMap.put("size", attachInfo.get("size"));
        attachMap.put("name", String.valueOf(attachInfo.get("name")));
        attachMap.put("status", "success");
        attachMap.put("description", String.valueOf(attachInfo.get("description")));
    }

    public static String getFullUrl(Object urlObj) {
        String domainUrl;
        if (null == urlObj) {
            return null;
        }
        String url = urlObj.toString();
        if (url.contains(domainUrl = UrlService.getDomainContextUrl())) {
            return url;
        }
        return UrlService.getAttachmentFullUrl((String)url);
    }

    public static List<IPdsAttachHandler> getAttachHandlers(PdsAttachContext context) {
        return ExtPluginFactory.getInstance().getExtPluginInstancesSingle(context.getInterfaceName(), null);
    }

    public static void handleAttachments(PdsAttachContext context) {
        List<IPdsAttachHandler> attachHandlers = AttachmentUtils.getAttachHandlers(context);
        for (IPdsAttachHandler attachHandler : attachHandlers) {
            attachHandler.buildAttachments(context);
        }
    }

    public static List<Map<String, Object>> getAttachments(IFormView view, long billId, String interfaceName) {
        PdsAttachContext context = new PdsAttachContext();
        context.setView(view);
        context.setBillId(billId);
        context.setInterfaceName(interfaceName);
        AttachmentUtils.handleAttachments(context);
        if (null == context.getAttachments()) {
            return Collections.emptyList();
        }
        return context.getAttachments();
    }

    public static List<Map<String, Object>> getArchiveAttachments(long billId) {
        DynamicObject billObj = BusinessDataServiceHelper.loadSingle((Object)billId, (String)"src_archivefile");
        if (null == billObj) {
            return null;
        }
        ArrayList<Map<String, Object>> attachList = new ArrayList<Map<String, Object>>(16);
        DynamicObjectCollection rows = billObj.getDynamicObjectCollection("entryentity");
        for (DynamicObject row : rows) {
            DynamicObjectCollection attachRows = row.getDynamicObjectCollection("fileattach");
            for (DynamicObject attachRow : attachRows) {
                DynamicObject attachInfo = attachRow.getDynamicObject("fbasedataid");
                if (null == attachInfo) continue;
                HashMap<String, Object> attachMap = new HashMap<String, Object>(16);
                attachMap.put("billPkId", String.valueOf(billId));
                attachMap.put("suppliername", row.getString("supplier.name"));
                attachMap.put("filecatalogue", row.getString("filecatalogue.name"));
                AttachmentUtils.setAttachMapValue(attachMap, attachInfo);
                attachList.add(attachMap);
            }
        }
        AttachmentUtils.setAttachmentFileName(attachList);
        AttachmentUtils.sortAttachment(attachList, "name");
        return attachList;
    }

    public static List<Map<String, Object>> setAttachmentType(List<Map<String, Object>> attachs, String attachType) {
        for (Map<String, Object> attach : attachs) {
            Object attachName = attach.get("name");
            Object supplierName = attach.get("suppliername");
            if (StringUtils.isBlank((Object)attachName)) {
                attachName = attachType;
            } else {
                StringBuilder attachNameSb = new StringBuilder();
                if (StringUtils.isBlank((Object)supplierName)) {
                    attachNameSb.append(attachType).append("--").append(attachName.toString());
                } else {
                    attachNameSb.append(attachType).append("--").append(supplierName.toString()).append("--").append(attachName.toString());
                }
                attachName = attachNameSb.toString();
            }
            attach.put("name", attachName);
        }
        return attachs;
    }

    public static List<Map<String, Object>> setAttachmentFileName(List<Map<String, Object>> attachs) {
        int index = 1;
        for (Map<String, Object> attach : attachs) {
            Object attachType = attach.get("filecatalogue");
            Object attachName = attach.get("name");
            Object supplierName = attach.get("suppliername");
            if (StringUtils.isBlank((Object)attachName)) {
                attachName = attachType;
            } else {
                StringBuilder attachNameSb = new StringBuilder();
                if (StringUtils.isBlank((Object)supplierName)) {
                    attachNameSb.append(attachType).append("--").append(attachName.toString());
                } else {
                    attachNameSb.append(attachType).append("--").append(supplierName.toString()).append("--").append(attachName.toString());
                }
                attachName = attachNameSb.toString();
            }
            String seq = null;
            seq = index < 10 ? "00" + String.valueOf(index++) : (index < 100 ? "0" + String.valueOf(index++) : String.valueOf(index++));
            attach.put("name", seq + " " + attachName);
        }
        return attachs;
    }

    public static List<Map<String, Object>> sortAttachment(List<Map<String, Object>> attachs, String sortField) {
        if (null == attachs || attachs.size() == 0) {
            return attachs;
        }
        Collections.sort(attachs, (o1, o2) -> {
            String name1 = (String)o1.get(sortField);
            String name2 = (String)o2.get(sortField);
            return name1.compareTo(name2);
        });
        return attachs;
    }

    public static void cloneAttachments(String sourceBillType, Set<String> sourceBillIds, String targetBillType, DynamicObject targetBillObj, String attachPanelName) {
        QFilter qfilters = new QFilter("FBillType", "=", (Object)sourceBillType);
        qfilters.and("FInterID", "in", sourceBillIds);
        if (attachPanelName != null) {
            qfilters.and("fattachmentpanel", "=", (Object)attachPanelName);
        }
        String selectFileds = DynamicObjectUtil.getSelectfields((String)"bos_attachment", (boolean)false);
        DynamicObject[] attachs = BusinessDataServiceHelper.load((String)"bos_attachment", (String)selectFileds, (QFilter[])qfilters.toArray());
        ArrayList<DynamicObject> targetAttchList = new ArrayList<DynamicObject>(attachs.length);
        for (DynamicObject attach : attachs) {
            DynamicObject targetAttach = (DynamicObject)OrmUtils.clone((IDataEntityBase)attach, (boolean)true, (boolean)true);
            AttachmentUtils.setPrimaryKey(targetAttach);
            targetAttach.set("fnumber", (Object)AttachmentServiceHelper.generateUid());
            targetAttach.set("FBillType", (Object)targetBillType);
            targetAttach.set("FInterID", (Object)String.valueOf(targetBillObj.get("id")));
            targetAttach.set("fattachmentpanel", attach.get("fattachmentpanel"));
            targetAttchList.add(targetAttach);
        }
        PdsCommonUtils.saveDynamicObjects(targetAttchList);
    }

    private static void setPrimaryKey(DynamicObject targetAttach) {
        ORM.create().setPrimaryKey(targetAttach);
    }

    public static DynamicObject createBdAttachment(Map<String, Object> attachment) {
        DynamicObject attObj;
        String formId = PdsCommonUtils.object2String(attachment.get("formid"), "");
        String pageId = PdsCommonUtils.object2String(attachment.get("pageid"), "");
        if (!StringUtils.isBlank((CharSequence)pageId) && null != (attObj = QueryServiceHelper.queryOne((String)"bd_attachment", (String)"uid", (QFilter[])new QFilter[]{new QFilter("pageid", "=", (Object)pageId)}))) {
            attachment.put("uid", attObj.get("uid"));
        }
        ArrayList<Map<String, Object>> attachments = new ArrayList<Map<String, Object>>();
        attachments.add(attachment);
        List attObjs = AttachmentFieldServiceHelper.saveAttachments((String)formId, (String)pageId, attachments);
        return (DynamicObject)attObjs.get(0);
    }

    public static List<Map<String, Object>> getAttachmentsByArchiveScheme(IFormView view, DynamicObject billObj) {
        long fileSchemeId = SchemeFilterUtils.getFirstSchemeIdByBizObject(view.getEntityId(), billObj, "pds_filescheme", IFileSchemeFilter.class.getSimpleName(), null);
        if (fileSchemeId == 0L) {
            return null;
        }
        PdsFileContext fileContext = new PdsFileContext();
        fileContext.setBillObj(billObj);
        fileContext.setFileSchemeId(fileSchemeId);
        PdsFileFacade.fileGatherUnsave(fileContext);
        List<Map<String, Object>> attachs = fileContext.getAttachments();
        if (null == attachs || attachs.size() == 0) {
            return null;
        }
        return PdsReportUtils.fieldAttach2PanelAttach(attachs, SrmCommonUtil.getPkValue((DynamicObject)billObj));
    }

    public static List<Map<String, Object>> getAttachmentsByArchiveScheme(String entityName, long projectId) {
        DynamicObject billObj = BusinessDataServiceHelper.loadSingle((Object)projectId, (String)entityName);
        long fileSchemeId = SchemeFilterUtils.getFirstSchemeIdByBizObject(entityName, billObj, "pds_filescheme", IFileSchemeFilter.class.getSimpleName(), null);
        if (fileSchemeId == 0L) {
            return null;
        }
        PdsFileContext fileContext = new PdsFileContext();
        fileContext.setBillObj(billObj);
        fileContext.setFileSchemeId(fileSchemeId);
        PdsFileFacade.fileGatherUnsave(fileContext);
        List<Map<String, Object>> attachs = fileContext.getAttachments();
        if (null == attachs || attachs.size() == 0) {
            return null;
        }
        return attachs;
    }

    public static void setQuoteBillAttachment(IFormView currView, QFilter qfilters, String sourceAttachPanel, String targetAttachPanel) {
        String selectFields = "project,suppliertype,supplier,billdate,billno";
        DynamicObject[] rows = BusinessDataServiceHelper.load((String)"tnd_quotebill", (String)selectFields, (QFilter[])qfilters.toArray(), (String)"supplier,billdate");
        if (rows == null || rows.length == 0) {
            return;
        }
        ArrayList allAttachments = new ArrayList(rows.length);
        for (DynamicObject row : rows) {
            long billId = row.getLong("id");
            List attachments = AttachmentServiceHelper.getAttachments((String)"tnd_quotebill", (Object)billId, (String)sourceAttachPanel, (boolean)false);
            if (null == attachments || attachments.size() == 0) continue;
            if (!currView.getEntityId().equals("tnd_vie_attachment")) {
                String supplierName = row.getString("supplier.name");
                AttachmentUtils.setAttachmentType(attachments, supplierName);
            }
            allAttachments.addAll(attachments);
        }
        if (null != allAttachments && allAttachments.size() > 0) {
            AttachmentPanel attachmentPanel = (AttachmentPanel)currView.getControl(targetAttachPanel);
            attachmentPanel.bindData(allAttachments);
        }
    }

    public static void setMultiBasedataForModel(IDataModel model, DynamicObjectCollection rows, String multiFieldName, int rowIndex) {
        if (null == rows || rows.size() == 0) {
            return;
        }
        Object[] basedataIds = new Object[rows.size()];
        int index = 0;
        for (DynamicObject row : rows) {
            basedataIds[index++] = row.get("fbasedataid.id");
        }
        model.setValue(multiFieldName, (Object)basedataIds, rowIndex);
    }

    public static boolean convertTempAttachments(List<Map<String, Object>> attachments) {
        boolean convertSuccess = true;
        StringBuilder logSb = new StringBuilder("###convertTempAttachments--->");
        for (Map<String, Object> map : attachments) {
            String relativeUrl = PdsCommonUtils.object2String(map.get("relativeUrl"), "");
            String url = PdsCommonUtils.object2String(map.get("url"), "");
            String name = PdsCommonUtils.object2String(map.get("name"), "");
            if (!StringUtils.isBlank((CharSequence)(url = AttachmentUtils.uploadTempFile(url, name, relativeUrl))) && (url.contains("tempfile/download.do?configKey") || url.contains("tempfile/preview.do?configKey"))) {
                convertSuccess = false;
                if (logSb.length() > 0) {
                    logSb.append(';').append("url:").append(url);
                } else {
                    logSb.append("url:").append(url);
                }
            }
            map.put("url", url);
            map.put("creator", UserServiceHelper.getCurrentUserId());
            map.put("modifytime", TimeServiceHelper.now().getTime());
            map.put("lastModified", TimeServiceHelper.now().getTime());
        }
        log.info(logSb.toString());
        return convertSuccess;
    }

    public static boolean convertTempAttachments(DynamicObjectCollection attachRows) {
        boolean convertSuccess = true;
        StringBuilder logSb = new StringBuilder("###convertTempAttachments--->");
        ArrayList<DynamicObject> attachInfoList = new ArrayList<DynamicObject>(attachRows.size());
        for (DynamicObject attachRow : attachRows) {
            DynamicObject attachInfo = attachRow.getDynamicObject("fbasedataid");
            if (null == attachInfo) continue;
            String url = attachInfo.getString("url");
            String name = String.valueOf(attachInfo.get("name"));
            if (!StringUtils.isBlank((CharSequence)(url = AttachmentUtils.uploadTempFile(url, name, ""))) && (url.contains("tempfile/download.do?configKey") || url.contains("tempfile/preview.do?configKey"))) {
                convertSuccess = false;
                if (logSb.length() > 0) {
                    logSb.append(';').append("url:").append(url);
                } else {
                    logSb.append("url:").append(url);
                }
            }
            DynamicObject attachObj = BusinessDataServiceHelper.loadSingle((Object)attachInfo.getLong("id"), (String)"bd_attachment");
            attachObj.set("tempfile", (Object)1);
            attachObj.set("url", (Object)url);
            attachInfoList.add(attachObj);
        }
        log.info(logSb.toString());
        SaveServiceHelper.save((DynamicObject[])((DynamicObject[])attachInfoList.stream().filter(item -> item.getPkValue() instanceof Long && (Long)item.getPkValue() == 0L).toArray(DynamicObject[]::new)));
        SaveServiceHelper.update((DynamicObject[])((DynamicObject[])attachInfoList.stream().filter(item -> item.getPkValue() instanceof Long && (Long)item.getPkValue() != 0L).toArray(DynamicObject[]::new)));
        return convertSuccess;
    }

    public static String uploadTempFile(String url, String name, String relativeUrl) {
        if (!(StringUtils.isBlank((CharSequence)relativeUrl) || relativeUrl.contains("tempfile/download.do?configKey") || relativeUrl.contains("tempfile/preview.do?configKey"))) {
            return relativeUrl;
        }
        if (!(StringUtils.isBlank((CharSequence)url) || url.contains("tempfile/download.do?configKey") || url.contains("tempfile/preview.do?configKey"))) {
            return AttachmentUtils.getRelativeUrlfromDownloadUrl(url);
        }
        try {
            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            InputStream in = cache.getInputStream(url);
            FileService service = FileServiceFactory.getAttachmentFileService();
            RequestContext requestContext = RequestContext.get();
            String uuid = UUID.randomUUID().toString().replace("-", "");
            String pathParam = FileNameUtils.getAttachmentFileName((String)requestContext.getTenantId(), (String)requestContext.getAccountId(), (Object)uuid, (String)name);
            FileItem fileItem = new FileItem(name, pathParam, in);
            return service.upload(fileItem);
        }
        catch (Exception e) {
            return url;
        }
    }

    public static String rebuildUrl(String url, String name) {
        FileService fs = FileServiceFactory.getAttachmentFileService();
        InputStream is = BosPrintServiceHelper.getFileInputStream((String)url);
        if (null == fs || null == is) {
            return null;
        }
        RequestContext requestContext = RequestContext.get();
        String uuid = UUID.randomUUID().toString().replace("-", "");
        String pathParam = FileNameUtils.getAttachmentFileName((String)requestContext.getTenantId(), (String)requestContext.getAccountId(), (Object)uuid, (String)name);
        FileItem fileItem = new FileItem(name, pathParam, is);
        return fs.upload(fileItem);
    }

    public static void deleteAttachments(String billType, Set<String> billIds, String attachPanelName) {
        QFilter qfilters = new QFilter("FBillType", "=", (Object)billType);
        qfilters.and("FInterID", "in", billIds);
        if (attachPanelName != null) {
            qfilters.and("fattachmentpanel", "=", (Object)attachPanelName);
        }
        DeleteServiceHelper.delete((String)"bos_attachment", (QFilter[])qfilters.toArray());
    }

    public static int getBillAttachCount(String billType, long projectId, long supplierId, String attachPanelName) {
        QFilter billFilter = new QFilter("project", "=", (Object)projectId);
        billFilter.and("billstatus", "!=", (Object)BillStatusEnum.SAVE.getVal());
        if (supplierId > 0L) {
            billFilter.and("supplier", "=", (Object)supplierId);
        }
        DynamicObjectCollection rows = QueryServiceHelper.query((String)billType, (String)"id", (QFilter[])billFilter.toArray());
        Set billIds = rows.stream().map(e -> e.getString("id")).collect(Collectors.toSet());
        QFilter qfilters = new QFilter("FBillType", "=", (Object)billType);
        qfilters.and("FInterID", "in", billIds);
        if (attachPanelName != null) {
            qfilters.and("fattachmentpanel", "=", (Object)attachPanelName);
        }
        rows = QueryServiceHelper.query((String)"bos_attachment", (String)"id", (QFilter[])qfilters.toArray());
        return rows.size();
    }

    public static Map<String, Integer> getPurlistAttachCount(long projectId, long supplierId, long packageId, String attachField) {
        DynamicObject[] purlistRows;
        HashMap<String, Integer> resultMap = new HashMap<String, Integer>(16);
        QFilter qfilter = new QFilter("project", "=", (Object)projectId);
        qfilter.and("supplier", ">", (Object)0L);
        qfilter.and("billtype", "=", (Object)"2");
        qfilter.and("entrystatus", "!=", (Object)ProjectStatusEnums.TOQUOTE.getValue());
        qfilter.and(attachField + '.' + "fbasedataid", ">", (Object)0L);
        if (supplierId > 0L) {
            qfilter.and("supplier", "=", (Object)supplierId);
        }
        if (packageId > 0L) {
            qfilter.and("package", "=", (Object)packageId);
        }
        if ((purlistRows = BusinessDataServiceHelper.load((String)"src_purlistf7", (String)("supplier,package," + attachField), (QFilter[])qfilter.toArray(), (String)"supplier")) == null || purlistRows.length == 0) {
            return resultMap;
        }
        Map<String, List<DynamicObject>> attachMap = Arrays.asList(purlistRows).stream().collect(Collectors.groupingBy(e -> e.getString("supplier.id") + '_' + e.getString("package.id")));
        for (Map.Entry<String, List<DynamicObject>> entry : attachMap.entrySet()) {
            int count = 0;
            for (DynamicObject row : entry.getValue()) {
                count += row.getDynamicObjectCollection(attachField).size();
            }
            resultMap.put(entry.getKey(), count);
        }
        return resultMap;
    }

    public static void setAttachPreviewUrl(List<Map<String, Object>> allAttachs) {
        for (Map<String, Object> attachMap : allAttachs) {
            AttachmentUtils.setPreviewUrl(attachMap, attachMap.get("previewurl"), attachMap.get("url"));
        }
    }

    public static void setPreviewUrl(Map<String, Object> attachMap, Object previewurl, Object url) {
        if (!StringUtils.isBlank((Object)previewurl)) {
            attachMap.put("previewurl", AttachmentUtils.getFullUrl(previewurl));
        } else {
            String fullUrl = AttachmentUtils.getFullUrl(url);
            if (null != fullUrl && !StringUtils.isBlank((CharSequence)fullUrl)) {
                attachMap.put("previewurl", fullUrl.replace("/download.do?", "/preview.do?"));
            }
        }
    }

    public static List<Map<String, Object>> getAllAttachList(IFormView view, IFormView parentView, String attachEntityId) {
        List<Map<String, Object>> attachList = null;
        DynamicObject projectObj = parentView.getModel().getDataEntity();
        long projectId = SrmCommonUtil.getPkValue((DynamicObject)projectObj);
        if (parentView.getEntityId().equals("src_placeonfile")) {
            attachList = AttachmentUtils.getArchiveAttachments(projectId);
        } else {
            attachList = AttachmentUtils.getAttachmentsByArchiveScheme(parentView, projectObj);
            if (null == attachList || attachList.size() == 0) {
                attachList = AttachmentUtils.getAttachments(view, projectId, attachEntityId);
            }
        }
        return attachList;
    }

    public static String getRelativeUrlfromDownloadUrl(String url) {
        try {
            String path = url;
            if (url.contains("path=")) {
                path = StringUtils.substringAfter((String)url, (String)"path=");
            }
            path = URLDecoder.decode(path, "UTF-8");
            return FilePathUtil.dealPath((String)path, (String)"attach");
        }
        catch (Exception e) {
            return url;
        }
    }

    public static void batchFillAttach(IFormView view, String entityName, String attachField) {
        int currIndex = view.getModel().getEntryCurrentRowIndex(entityName);
        if (currIndex < 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5f85\u590d\u5236\u7684\u5206\u5f55\u884c\u3002", (String)"AttachmentUtils_0", (String)"scm-pds-common", (Object[])new Object[0]));
            return;
        }
        DynamicObject currRow = view.getModel().getEntryRowEntity(entityName, currIndex);
        if (null == currRow || currRow.getDynamicObjectCollection(attachField).size() == 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5f85\u590d\u5236\u7684\u9644\u4ef6\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u8fdb\u884c\u590d\u5236\u3002", (String)"AttachmentUtils_1", (String)"scm-pds-common", (Object[])new Object[0]));
            return;
        }
        view.getModel().beginInit();
        for (int index = currIndex + 1; index < view.getModel().getEntryRowCount(entityName); ++index) {
            DynamicObject nextRow = view.getModel().getEntryRowEntity(entityName, index);
            nextRow.set(attachField, (Object)PdsCommonUtils.cloneAttachment(PdsCommonUtils.cloneAttachment(currRow, attachField)));
        }
        view.getModel().endInit();
        view.updateView(entityName);
    }

    public static List<Map<String, Object>> getBillAttachment(String entityName, QFilter qfilters, String attachPanelName) {
        ArrayList<Map<String, Object>> allAttachments = new ArrayList<Map<String, Object>>();
        String selectFields = "suppliertype,supplier,billdate,billno";
        DynamicObject[] rows = BusinessDataServiceHelper.load((String)entityName, (String)selectFields, (QFilter[])qfilters.toArray(), (String)"supplier,billdate");
        if (rows == null || rows.length == 0) {
            return allAttachments;
        }
        for (DynamicObject row : rows) {
            String supplierName = row.getString("supplier.name");
            List attachments = AttachmentServiceHelper.getAttachments((String)entityName, (Object)row.getLong("id"), (String)attachPanelName, (boolean)false);
            if (null == attachments || attachments.size() == 0) continue;
            AttachmentUtils.setAttachmentType(attachments, supplierName);
            allAttachments.addAll(attachments);
        }
        return allAttachments;
    }

    public static void createAttachments(DynamicObject billObj, String attachPanelName, Map<String, Object> attachMap) {
        QFilter qfilters = new QFilter("FBillType", "=", (Object)billObj.getDataEntityType().getName());
        qfilters.and("FInterID", "=", (Object)billObj.getString("id"));
        if (attachPanelName != null) {
            qfilters.and("fattachmentpanel", "=", (Object)attachPanelName);
        }
        if (QueryServiceHelper.exists((String)"bos_attachment", (QFilter[])qfilters.toArray())) {
            return;
        }
        DynamicObject attachObj = BusinessDataServiceHelper.newDynamicObject((String)"bos_attachment");
        AttachmentUtils.setPrimaryKey(attachObj);
        attachObj.set("fnumber", (Object)AttachmentServiceHelper.generateUid());
        attachObj.set("FBillType", (Object)billObj.getDataEntityType().getName());
        attachObj.set("FInterID", (Object)String.valueOf(billObj.get("id")));
        attachObj.set("fattachmentpanel", (Object)(StringUtils.isBlank((CharSequence)attachPanelName) ? "attachmentpanel" : attachPanelName));
        attachObj.set("FCREATEMEN", (Object)RequestContext.get().getCurrUserId());
        attachObj.set("fcreatetime", (Object)TimeServiceHelper.now());
        attachObj.set("FModifyTime", (Object)TimeServiceHelper.now());
        for (Map.Entry<String, Object> entry : attachMap.entrySet()) {
            attachObj.set(entry.getKey(), entry.getValue());
        }
        PdsCommonUtils.saveDynamicObjects(attachObj);
    }
}

