/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.biddoctool;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.servicehelper.attachment.AttachmentFieldServiceHelper;
import kd.scm.pds.common.attach.AttachmentUtils;
import kd.scm.pds.common.biddoctool.IPdsDocToolHandler;
import kd.scm.pds.common.biddoctool.PdsDocToolContext;
import kd.scm.pds.common.util.MultiBasedataUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.PdsReportUtils;

public class PdsDocToolCreatePdfAttach
implements IPdsDocToolHandler {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(PdsDocToolContext context) {
        this.createPdfAttach(context);
    }

    protected void createPdfAttach(PdsDocToolContext context) {
        Map<String, Object> resultMap = this.verifyData(context);
        if (null == resultMap || resultMap.size() == 0) {
            return;
        }
        Map<String, Object> attachment = this.createAttachMap(context, resultMap);
        if (null == attachment) {
            return;
        }
        DynamicObject attachObj = this.createAttachObj(context, attachment);
        if (null == attachObj) {
            return;
        }
        this.setBidDocEntryAttach(context, attachObj, attachment);
    }

    protected Map<String, Object> verifyData(PdsDocToolContext context) {
        IDataModel model = context.getView().getModel();
        DynamicObject bidDocObj = model.getDataEntity().getDynamicObject("biddoc");
        if (null == bidDocObj) {
            context.setSucced(false);
            context.setMessage(ResManager.loadKDString((String)"\u6807\u4e66\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PdsDocToolCreatePdfAttach_0", (String)"scm-pds-common", (Object[])new Object[0]));
            return null;
        }
        String prtId = PdsReportUtils.getPrintTplIdByNumber(bidDocObj, "pds_biddocentryf7_prtpl");
        if (StringUtils.isBlank((CharSequence)prtId)) {
            context.setMessage(ResManager.loadKDString((String)"\u672a\u627e\u5230\u6807\u4e66\u7f16\u5236F7\u5bf9\u5e94\u7684\u5957\u6253\u6a21\u677f\u3002", (String)"PdsDocToolCreatePdfAttach_1", (String)"scm-pds-common", (Object[])new Object[0]));
            context.setSucced(false);
            return null;
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>(2);
        resultMap.put("id", prtId);
        resultMap.put("value", bidDocObj);
        return resultMap;
    }

    protected Map<String, Object> createAttachMap(PdsDocToolContext context, Map<String, Object> resultMap) {
        String filename;
        String prtId = (String)resultMap.get("id");
        DynamicObject bidDocObj = (DynamicObject)resultMap.get("value");
        List<Map<String, Object>> attachMaps = PdsReportUtils.createFieldAttachment(bidDocObj, prtId, filename = PdsCommonUtils.object2String(context.getView().getModel().getValue("filename"), null));
        if (null == attachMaps || attachMaps.size() == 0) {
            context.setMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u751f\u6210pdf\u62a5\u8868\u3002", (String)"PdsDocToolCreatePdfAttach_2", (String)"scm-pds-common", (Object[])new Object[0]));
            context.setSucced(false);
            return null;
        }
        return attachMaps.get(0);
    }

    protected DynamicObject createAttachObj(PdsDocToolContext context, Map<String, Object> attachment) {
        DynamicObject attachObj = AttachmentFieldServiceHelper.getAttCreatorByUID((String)((String)attachment.get("uid")));
        if (null == attachObj) {
            attachObj = AttachmentUtils.createBdAttachment(attachment);
        }
        if (null == attachObj) {
            context.setMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u751f\u6210\u9644\u4ef6\u57fa\u7840\u8d44\u6599\u3002", (String)"PdsDocToolCreatePdfAttach_3", (String)"scm-pds-common", (Object[])new Object[0]));
            context.setSucced(false);
        }
        return attachObj;
    }

    protected void setBidDocEntryAttach(PdsDocToolContext context, DynamicObject attachObj, Map<String, Object> attachment) {
        int index = PdsCommonUtils.object2Integer(context.getView().getModel().getDataEntity().get("currentrow"));
        IFormView parentView = context.getView().getParentView();
        if (Objects.isNull(parentView) || !PdsCommonUtils.isValidBillType(parentView)) {
            return;
        }
        DynamicObject row = parentView.getModel().getEntryRowEntity("entryentity", index);
        Set<Long> idSet = MultiBasedataUtils.getBasedataIdSet(row, "bidattach");
        if (idSet.add(PdsCommonUtils.object2Long(attachObj.getPkValue()))) {
            parentView.getModel().setValue("bidattach", (Object)idSet.toArray(), index);
        }
        parentView.updateView("entryentity");
        context.getView().sendFormAction(parentView);
    }
}

