/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.biddoctool;

import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.RichTextEditor;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.pds.common.biddoctool.IPdsDocToolHandler;
import kd.scm.pds.common.biddoctool.PdsDocToolContext;
import kd.scm.pds.common.noticetpl.IPdsNoticeInterface;
import kd.scm.pds.common.noticetpl.PdsNoticeTplContext;
import kd.scm.pds.common.noticetpl.PdsNoticeTplFactory;
import kd.scm.pds.common.util.PdsCommonUtils;

public class PdsDocToolDecorateContent
implements IPdsDocToolHandler {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(PdsDocToolContext context) {
        this.decorateContent(context);
    }

    protected void decorateContent(PdsDocToolContext context) {
        IDataModel model = context.getView().getModel();
        Object newValue = context.getPropertyArgs().getChangeSet()[0].getNewValue();
        RichTextEditor richTextEditor = (RichTextEditor)context.getView().getControl("richtexteditorap");
        if (Objects.isNull(newValue)) {
            model.setValue("content", null);
            richTextEditor.setText(null);
            return;
        }
        long billId = PdsCommonUtils.object2Long(model.getValue("billid"));
        if (billId == 0L) {
            return;
        }
        String entityName = PdsCommonUtils.object2String(model.getValue("entityname"), "src_project");
        DynamicObject billObj = BusinessDataServiceHelper.loadSingle((Object)billId, (String)entityName);
        PdsNoticeTplContext noticeContext = new PdsNoticeTplContext((DynamicObject)newValue, billObj);
        IPdsNoticeInterface pdsNoticePlugin = PdsNoticeTplFactory.getPdsNoticePluginInstance(noticeContext);
        String contents = pdsNoticePlugin.decorateContent(noticeContext);
        richTextEditor.setText(contents);
        model.setValue("content", (Object)contents);
    }
}

