/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.biddoctool;

import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.RichTextEditor;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.pds.common.biddoctool.IPdsDocToolHandler;
import kd.scm.pds.common.biddoctool.PdsDocToolContext;
import kd.scm.pds.common.util.PdsCommonUtils;

public class PdsDocToolSaveBidDoc
implements IPdsDocToolHandler {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(PdsDocToolContext context) {
        this.saveBidDoc(context);
    }

    protected void saveBidDoc(PdsDocToolContext context) {
        IDataModel model = context.getView().getModel();
        String operateKey = ((AbstractOperate)context.getBeforeDoOperationArgs().getSource()).getOperateKey();
        if (!this.verifyData(context)) {
            return;
        }
        RichTextEditor richTextEditor = (RichTextEditor)context.getView().getControl("richtexteditorap");
        String text = richTextEditor.getText();
        model.setValue("content", (Object)text);
        DynamicObject biddocObj = null;
        long biddocId = model.getDataEntity().getLong("biddoc.id");
        if (biddocId == 0L || "saveas".equals(operateKey)) {
            biddocObj = BusinessDataServiceHelper.newDynamicObject((String)"pds_biddocentryf7");
            biddocObj.set("billid", model.getValue("billid"));
            biddocObj.set("project", (Object)model.getDataEntity().getLong("project.id"));
            biddocObj.set("creator", (Object)RequestContext.get().getCurrUserId());
            biddocObj.set("org", (Object)model.getDataEntity().getLong("project.org.id"));
        } else {
            biddocObj = BusinessDataServiceHelper.loadSingle((Object)biddocId, (String)"pds_biddocentryf7");
        }
        biddocObj.set("filename", (Object)PdsCommonUtils.object2String(model.getValue("filename"), ""));
        biddocObj.set("biddoctpl", (Object)model.getDataEntity().getLong("biddoctpl.id"));
        biddocObj.set("createtime", (Object)TimeServiceHelper.now());
        biddocObj.set("content_tag", model.getValue("content"));
        PdsCommonUtils.saveDynamicObjects(biddocObj);
        model.setValue("biddoc", biddocObj.getPkValue());
    }

    protected boolean verifyData(PdsDocToolContext context) {
        IDataModel model = context.getView().getModel();
        if (model.getDataEntity().getLong("biddoctpl.id") == 0L) {
            context.setMessage(ResManager.loadKDString((String)"\u6807\u4e66\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PdsDocToolSaveBidDoc_0", (String)"scm-pds-common", (Object[])new Object[0]));
            context.setSucced(false);
            context.getBeforeDoOperationArgs().setCancel(true);
            return false;
        }
        if (StringUtils.isBlank((CharSequence)PdsCommonUtils.object2String(model.getValue("filename"), ""))) {
            context.setMessage(ResManager.loadKDString((String)"\u6807\u4e66\u6587\u4ef6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PdsDocToolSaveBidDoc_1", (String)"scm-pds-common", (Object[])new Object[0]));
            context.setSucced(false);
            context.getBeforeDoOperationArgs().setCancel(true);
            return false;
        }
        return true;
    }
}

