/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.bizop;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.pds.common.util.MultiBasedataUtils;
import kd.scm.pds.common.util.OpenFormUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import org.apache.commons.lang3.StringUtils;

public class PdsBizOperateLogUtils {
    public static void openOperateLog(IFormView currView, String callbackClassName, String opType, String description, long billId, long projectId, String entitykey, String opKey, Set<Long> suppliers, Set<Long> bizUsers) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(8);
        paramMap.put("optype", opType);
        paramMap.put("opkey", opKey);
        paramMap.put("description", description);
        paramMap.put("billid", billId);
        paramMap.put("project", projectId);
        paramMap.put("entitykey", entitykey);
        paramMap.put("supplier", suppliers);
        paramMap.put("bizuser", bizUsers);
        OpenFormUtils.openDynamicPage(currView, "pds_bizoperate", ShowType.Modal, paramMap, new CloseCallBack(callbackClassName, "bizoperatelog"));
    }

    public static void logQurry(IFormView currView, long billId, long projectId, String entitykey, String opKey, Set<Long> suppliers, Set<Long> bizUsers) {
        QFilter qFilter = PdsBizOperateLogUtils.getQFilter(billId, projectId, entitykey, opKey, suppliers, bizUsers);
        OpenFormUtils.openListPage(currView, "pds_bizoperatelog", ShowType.MainNewTabPage, null, qFilter, null);
    }

    private static QFilter getQFilter(long billId, long projectId, String entitykey, String opKey, Set<Long> suppliers, Set<Long> bizUsers) {
        QFilter qFilter = new QFilter("billid", "=", (Object)billId);
        qFilter.and("opkey", "=", (Object)opKey);
        if (!StringUtils.isBlank((CharSequence)entitykey)) {
            qFilter.and("entitykey", "=", (Object)entitykey);
        }
        if (projectId > 0L) {
            qFilter.and("project", "=", (Object)projectId);
        }
        if (null != suppliers && suppliers.size() > 0) {
            qFilter.and("supplier.fbasedataid", "in", suppliers);
        }
        if (null != bizUsers && bizUsers.size() > 0) {
            qFilter.and("bizuser.fbasedataid", "in", bizUsers);
        }
        return qFilter;
    }

    public static DynamicObject recordBizOpLog(Map<String, Object> paramMap) {
        DynamicObject logObj = BusinessDataServiceHelper.newDynamicObject((String)"pds_bizoperatelog");
        logObj.set("project", paramMap.get("project"));
        logObj.set("billid", paramMap.get("billid"));
        logObj.set("entitykey", paramMap.get("entitykey"));
        logObj.set("opkey", paramMap.get("opkey"));
        logObj.set("optype", paramMap.get("optype"));
        if (null != paramMap.get("supplier")) {
            Set supplierIds = (Set)paramMap.get("supplier");
            MultiBasedataUtils.setMultiBasedataForBillObj(logObj, supplierIds, "supplier");
        }
        logObj.set("turns", paramMap.get("turns"));
        logObj.set("vieturns", paramMap.get("vieturns"));
        logObj.set("reason", paramMap.get("reason"));
        logObj.set("createtime", (Object)TimeServiceHelper.now());
        logObj.set("creator", (Object)RequestContext.get().getCurrUserId());
        PdsCommonUtils.saveDynamicObjects(logObj);
        return logObj;
    }
}

