/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.card;

import java.util.EventObject;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.BillOperationStatus;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.pluginnew.GridCardPlugin;
import kd.scm.pds.common.extfilter.ExtFilterUtils;
import kd.scm.pds.common.extfilter.FilterGridUtils;
import kd.scm.pds.common.util.OpenFormUtils;

public class PdsCardTemplatePlugin
extends GridCardPlugin
implements HyperLinkClickListener {
    protected ShowType showType = ShowType.MainNewTabPage;
    protected String pageKey = null;
    protected QFilter qFilter = null;

    public void initialize() {
        super.initialize();
        this.setShowType();
        this.setQFilterParams();
    }

    protected void setShowType() {
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        if (StringUtils.equals((CharSequence)"pc_main_console", (CharSequence)parentView.getEntityId())) {
            this.showType = ShowType.NewWindow;
        }
    }

    protected void setQFilterParams() {
        QFilter plugQFilter;
        Map<String, Object> qFilterMap = FilterGridUtils.getQFilter("pds_extfilter", this.getView().getEntityId());
        if (!Objects.isNull(qFilterMap.get("name"))) {
            this.pageKey = (String)qFilterMap.get("name");
        }
        if (!Objects.isNull(qFilterMap.get("qfilter"))) {
            this.qFilter = (QFilter)qFilterMap.get("qfilter");
        }
        if ((plugQFilter = ExtFilterUtils.getExtFilterByPlugin("pds_extfilter", this.getView().getEntityId(), this.getView(), null)) != null) {
            if (this.qFilter == null) {
                this.qFilter = plugQFilter;
            } else {
                this.qFilter.and(plugQFilter);
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"labelap"});
        BillList billList = (BillList)this.getView().getControl("billlistap");
        billList.addHyperClickListener((HyperLinkClickListener)this);
    }

    protected void refreshCard(Map<String, String> allConfigMap) {
        super.refreshCard(allConfigMap);
        BillList billList = (BillList)this.getControl("billlistap");
        if (this.qFilter != null) {
            billList.getFilterParameter().setFilter(this.qFilter);
            billList.refresh();
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "labelap": {
                if (this.pageKey == null || this.qFilter == null) break;
                OpenFormUtils.openListPage(this.getView(), this.pageKey, this.showType, null, this.qFilter, null);
                break;
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent heperLinkEvent) {
        BillList grid = (BillList)heperLinkEvent.getSource();
        if (this.pageKey != null && this.qFilter != null) {
            OpenFormUtils.openBillPage(this.getView(), this.pageKey, grid.getFocusRowPkId(), BillOperationStatus.EDIT, this.showType, null, null);
        }
    }
}

