/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.change;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.scm.pds.common.change.HandleEvent;
import kd.scm.pds.common.change.HandleResult;
import kd.scm.pds.common.change.IDataHandleService;

public class DataHandleFactory {
    private List<String> pluginList;
    private Map<String, String> pluginMap;
    private HandleEvent handleEvent = new HandleEvent();
    private static DataHandleFactory factory;
    private static Log log;

    public DataHandleFactory() {
        this.pluginList = new ArrayList<String>();
        this.pluginMap = new HashMap<String, String>();
    }

    public static DataHandleFactory create() {
        if (null == factory) {
            factory = new DataHandleFactory();
        }
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HandleResult doHandle() {
        HandleResult result = new HandleResult();
        String currPlugin = null;
        try (TXHandle tx = TX.requiresNew();){
            HashSet<String> exectedPluginSet = new HashSet<String>(this.pluginList.size());
            for (String plugin : this.pluginList) {
                IDataHandleService service = this.getServiceInstance(plugin);
                currPlugin = plugin;
                if (null == service) {
                    result.setSuccess(false);
                    result.setMessage(String.format(ResManager.loadKDString((String)"%1$s\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u5b9e\u73b0\u7c7b\u3002", (String)"DataHandleFactory_0", (String)"scm-pds-common", (Object[])new Object[0]), plugin));
                    HandleResult handleResult = result;
                    return handleResult;
                }
                if (!exectedPluginSet.add(plugin)) continue;
                HandleResult handleResult = service.handle(this.handleEvent);
                handleResult.setHandlePlugin(plugin);
                String message = handleResult.getMessage();
                if (StringUtils.isNotEmpty((String)message)) {
                    StringBuilder msgSb = new StringBuilder();
                    String pluginName = this.getPluginMap().get(plugin);
                    if (null != pluginName) {
                        msgSb.append(pluginName).append("=>").append(message);
                        handleResult.setHandlePluginName(pluginName);
                    } else {
                        msgSb.append(plugin).append("=>").append(message);
                    }
                    handleResult.setMessage(msgSb.toString());
                }
                result.addResult(handleResult);
                if (handleResult.isSuccess()) continue;
                result.setSuccess(false);
                HandleResult handleResult2 = result;
                return handleResult2;
            }
        }
        log.info("DataHandleFactory@@@:" + result.getMessage());
        return result;
    }

    public HandleEvent getHandleEvent() {
        return this.handleEvent;
    }

    public void setHandleEvent(HandleEvent handleEvent) {
        this.handleEvent = handleEvent;
    }

    public void setPluginList(List<String> pluginList) {
        this.pluginList = pluginList;
    }

    public List<String> getPluginList() {
        return this.pluginList;
    }

    public Map<String, String> getPluginMap() {
        return this.pluginMap;
    }

    public void setPluginMap(Map<String, String> pluginMap) {
        this.pluginMap = pluginMap;
    }

    public IDataHandleService getServiceInstance(String plugin) {
        IDataHandleService service = null;
        if (null != plugin) {
            try {
                service = (IDataHandleService)Class.forName(plugin).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                return service;
            }
        }
        return service;
    }

    static {
        log = LogFactory.getLog(DataHandleFactory.class);
    }
}

