/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.change;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.pds.common.change.IDataValidateService;
import kd.scm.pds.common.change.ValidateEvent;
import kd.scm.pds.common.change.ValidateResult;

public class DataValidateFactory {
    private List<String> pluginList = new ArrayList<String>();
    private ValidateEvent validateEvent = new ValidateEvent();
    private static DataValidateFactory factory;
    private static Log log;

    public static DataValidateFactory create() {
        if (null == factory) {
            factory = new DataValidateFactory();
        }
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValidateResult doValidate() {
        HashSet<String> excutedPluginSet = new HashSet<String>(this.pluginList.size());
        ValidateResult result = new ValidateResult();
        String currPlugin = null;
        try (TXHandle tx = TX.requiresNew();){
            for (String plugin : this.pluginList) {
                if (!excutedPluginSet.add(plugin)) continue;
                IDataValidateService service = this.getServiceInstance(plugin);
                currPlugin = plugin;
                ValidateResult serviceResult = new ValidateResult();
                if (null == service) {
                    result.setSuccess(false);
                    serviceResult.setSuccess(false);
                    serviceResult.setMessage(String.format(ResManager.loadKDString((String)"%1$s\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u5b9e\u73b0\u7c7b\u3002", (String)"DataValidateFactory_2", (String)"scm-pds-common", (Object[])new Object[0]), plugin));
                } else {
                    serviceResult = service.validate(this.validateEvent);
                }
                if (!serviceResult.isSuccess()) {
                    result.setSuccess(false);
                }
                result.addResult(serviceResult);
            }
        }
        log.info("DataValidateFactory@@@:" + result.getMessage());
        return result;
    }

    public ValidateEvent getValidateEvent() {
        return this.validateEvent;
    }

    public void setValidateEvent(ValidateEvent validateEvent) {
        this.validateEvent = validateEvent;
    }

    public void setPluginList(List<String> pluginList) {
        this.pluginList = pluginList;
    }

    public List<String> getPluginList() {
        return this.pluginList;
    }

    public IDataValidateService getServiceInstance(String plugin) {
        IDataValidateService service = null;
        if (null != plugin) {
            try {
                service = (IDataValidateService)Class.forName(plugin).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                return service;
            }
        }
        return service;
    }

    static {
        log = LogFactory.getLog(DataValidateFactory.class);
    }
}

