/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.comptpl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.container.Tab;
import kd.bos.form.container.TabPage;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.logging.BizLog;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.bill.BillView;
import kd.bos.mvc.form.IFormController;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.BillFormUtil;
import kd.scm.pds.common.comptpl.IPdsCompTplService;
import kd.scm.pds.common.comptpl.PdsCompTplContext;
import kd.scm.pds.common.util.PdsBizNodeUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.PdsMetadataUtil;
import kd.scm.pds.common.util.TemplateUtil;
import org.apache.commons.lang.StringUtils;

public class PdsCompTplServiceImpl
implements IPdsCompTplService {
    IFormView view;
    IDataModel model;
    IPageCache pageCache;
    private static String CURRENTTABPAGE = "currenttabpage";
    private Map<String, String> layoutMap = null;
    private Map<String, Boolean> compHideMap = null;
    public static final String SUBMITANDAUDIT = "submitandaudit";

    @Override
    public void initParam(PdsCompTplContext context) {
        this.view = context.getView();
        this.model = context.getModel();
        this.pageCache = context.getCache();
    }

    public IFormView getView() {
        return this.view;
    }

    public IDataModel getModel() {
        return this.model;
    }

    public IPageCache getPageCache() {
        return this.pageCache;
    }

    @Override
    public void beforeDoOperation(PdsCompTplContext context) {
        String operateKey;
        this.initParam(context);
        BeforeDoOperationEventArgs evt = context.getBeforeDoOperationEventArgs();
        if (evt.isCancel()) {
            return;
        }
        AbstractOperate op = (AbstractOperate)evt.getSource();
        switch (operateKey = op.getOperateKey()) {
            case "refresh": {
                this.cacheCurrentTabPage();
                break;
            }
            case "refreshcomp": {
                DynamicObject template = this.model.getDataEntity().getDynamicObject("template");
                if (null == template) break;
                this.clearComponents();
                this.delTplentryData(template);
                this.createTplentryData(template);
                this.loadComponents(template);
                break;
            }
            case "reloadcomp": {
                this.reloadCompByTemplate();
                break;
            }
            default: {
                if (!this.continueDoOpByLoadedComp(evt)) break;
                if ("save".equals(operateKey) || "submit".equals(operateKey)) {
                    this.saveData();
                    this.setParentId();
                }
                if (null == op.getOption() || op.getOption().containsVariable("pds_op_isrepeat")) break;
                op.getOption().setVariableValue("pds_op_isrepeat", "1");
                if (this.doOperation(operateKey)) break;
                evt.setCancel(true);
                return;
            }
        }
    }

    public boolean continueDoOpByLoadedComp(BeforeDoOperationEventArgs evt) {
        String operateKey = ((AbstractOperate)evt.getSource()).getOperateKey();
        if (!this.isLoadedComp(operateKey)) {
            evt.setCancel(true);
            this.view.showSuccessNotification(ResManager.loadKDString((String)"\u6570\u636e\u6b63\u5728\u52a0\u8f7d\u4e2d\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"PdsCompTplServiceImpl_0", (String)"scm-pds-common", (Object[])new Object[0]), Integer.valueOf(6000));
            return false;
        }
        return true;
    }

    public boolean isDoOperation(String opKey) {
        switch (opKey) {
            case "save": 
            case "submit": 
            case "unsubmit": 
            case "unaudit": {
                return true;
            }
        }
        return false;
    }

    public void reloadCompByTemplate() {
        Object template = this.getModel().getValue("template");
        if (template != null) {
            DynamicObject templateObj = (DynamicObject)template;
            this.cacheCurrentTabPage();
            this.clearComponents();
            this.loadComponents(templateObj);
        }
    }

    @Override
    public void afterBindData(PdsCompTplContext context) {
        this.initParam(context);
    }

    @Override
    public void afterDoOperation(PdsCompTplContext context) {
        String opKey;
        AfterDoOperationEventArgs afterDoOperationEvt = context.getAfterDoOperationEventArgs();
        this.initParam(context);
        switch (opKey = afterDoOperationEvt.getOperateKey()) {
            case "save": 
            case "submit": 
            case "unsubmit": 
            case "audit": {
                if (this.isSubmitAndAudit() && "submit".equals(opKey)) break;
            }
            case "unaudit": {
                this.reloadCompByTemplate();
                break;
            }
            case "querycompconfig": {
                this.quereyComconfig();
            }
        }
    }

    public void quereyComconfig() {
        if (this.isPlain()) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u7ec4\u4ef6\u5e73\u94fa\u5c55\u793a\u4e0d\u652f\u6301\u67e5\u770b\u3002", (String)"PdsCompTplServiceImpl_9", (String)"scm-pds-common", (Object[])new Object[0]));
            return;
        }
        Tab tab = (Tab)this.getView().getControl("tabap");
        String currentTab = tab.getCurrentTab();
        String pageId = this.getPageCache().get(currentTab);
        BillView compView = (BillView)this.getView().getView(pageId);
        if (null == compView) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u7ec4\u4ef6\u672a\u521d\u59cb\u5316\u5b8c\u6210\u3002", (String)"PdsCompTplServiceImpl_10", (String)"scm-pds-common", (Object[])new Object[0]));
        } else {
            Object compConfig = compView.getModel().getValue("comppageconfig");
            if (null != compConfig) {
                DynamicObject compObj = (DynamicObject)compConfig;
                BillShowParameter param = BillFormUtil.assembleShowBillFormParam((String)"pds_compconfig", (ShowType)ShowType.MainNewTabPage, (OperationStatus)OperationStatus.VIEW, (long)PdsCommonUtils.object2Long(compObj.getPkValue()), null, null);
                this.getView().showForm((FormShowParameter)param);
            } else {
                this.getView().showMessage(ResManager.loadKDString((String)"\u672a\u627e\u5230\u914d\u7f6e\u3002", (String)"PdsCompTplServiceImpl_11", (String)"scm-pds-common", (Object[])new Object[0]));
            }
        }
    }

    @Override
    public void beforeBindData(PdsCompTplContext context) {
        this.initParam(context);
        if (this.setPreViewTemplate()) {
            return;
        }
        Object template = this.model.getValue("template");
        if (template != null) {
            DynamicObject templateObj = (DynamicObject)template;
            this.clearComponents();
            this.loadComponents(templateObj);
        } else {
            this.clearComponents();
        }
        this.initCreatorInfo();
    }

    @Override
    public void propertyChanged(PdsCompTplContext context) {
        this.initParam(context);
        PropertyChangedArgs e = context.getPropertyChangeArgs();
        if ("template".equals(e.getProperty().getName())) {
            Object newVal;
            ChangeData[] changeData = e.getChangeSet();
            Object oldVal = changeData[0].getOldValue();
            if (null != oldVal && oldVal instanceof DynamicObject) {
                this.delTplentryData((DynamicObject)oldVal);
            }
            if (null != (newVal = changeData[0].getNewValue()) && newVal instanceof DynamicObject) {
                DynamicObject template = (DynamicObject)newVal;
                this.clearComponents();
                this.delTplentryData(template);
                this.createTplentryData(template);
                this.loadComponents(template);
            } else {
                this.clearComponents();
            }
        }
    }

    public void cacheCurrentTabPage() {
        boolean isPalain = this.isPlain();
        if (!isPalain) {
            Tab tab = (Tab)this.getView().getControl("tabap");
            String currTab = tab.getCurrentTab();
            IPageCache cache = this.getPageCache();
            String pageId = cache.get(currTab);
            if (null != pageId) {
                String compKey = cache.get(pageId);
                cache.put(CURRENTTABPAGE, compKey);
            }
        }
    }

    public void initCreatorInfo() {
        DynamicObject obj = this.getModel().getDataEntity();
        DynamicObject creator = obj.getDynamicObject("creator");
        if (null == creator) {
            this.getModel().setValue("creator", (Object)RequestContext.get().getCurrUserId());
            this.getModel().setValue("createtime", (Object)TimeServiceHelper.now());
        }
    }

    public void hideTabPage(String tarKey) {
        this.hideContainer(tarKey);
    }

    public void hideContainer(String tarKey) {
        ArrayList<String> removePageList = new ArrayList<String>(8);
        String[] tragetPageArr = new String[this.getMaxComponentSize() + 1];
        IFormView view = this.getView();
        for (int i = 0; i <= this.getMaxComponentSize(); ++i) {
            String targetPage;
            tragetPageArr[i] = targetPage = tarKey + i;
            removePageList.add(targetPage);
        }
        if (removePageList.size() > 0) {
            view.setVisible(Boolean.FALSE, tragetPageArr);
            this.getPageCache().batchRemove(removePageList);
        }
    }

    public void loadComponents(DynamicObject compTpl) {
        if (compTpl == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6a21\u677f\u4e0d\u5b58\u5728\u3002", (String)"PdsCompTplServiceImpl_1", (String)"scm-pds-common", (Object[])new Object[0]));
            return;
        }
        IFormView view = this.getView();
        boolean isPlain = this.isPlain();
        String tarContainerKey = this.getShowCompPanelKey(isPlain);
        if (isPlain) {
            view.setVisible(Boolean.FALSE, new String[]{"pl_componentinfo"});
        } else {
            Container container = (Container)this.getView().getControl("pl_componentinfo");
            container.setCollapse(false);
            view.setVisible(Boolean.TRUE, new String[]{"pl_componentinfo"});
        }
        List<String> compKeyList = this.getShowCompKeyList();
        Set<String> compKeySet = this.removeUnShowCompKey(compKeyList);
        int i = 0;
        String currPage = null;
        int maxComponentSize = this.getMaxComponentSize();
        for (String compKey : compKeySet) {
            String targetPage = tarContainerKey + i;
            String compPageId = null;
            compPageId = this.showComponet(targetPage, compKey, isPlain);
            if (compPageId != null) {
                this.cacheComponentPageId(compKey, targetPage, compPageId);
                if (i == 0) {
                    currPage = targetPage;
                }
            }
            if (++i <= maxComponentSize) continue;
            view.showTipNotification(String.format(ResManager.loadKDString((String)"\u663e\u793a\u7ec4\u4ef6\u6700\u591a\u4e3a%1$s\u4e2a\u3002", (String)"PdsCompTplServiceImpl_2", (String)"scm-pds-common", (Object[])new Object[0]), maxComponentSize));
            return;
        }
        if (null != currPage && !isPlain) {
            String cacheTabPage = this.getCurrTabPageByCache();
            if (null != cacheTabPage) {
                currPage = cacheTabPage;
            }
            this.activeTab(currPage);
        }
    }

    public String getShowCompPanelKey(boolean isPlain) {
        String showCompPanelKey = null;
        showCompPanelKey = isPlain ? "compcontainer" : "tabpageap";
        return showCompPanelKey;
    }

    public boolean isPlain() {
        boolean isPlain = false;
        DynamicObject template = this.getModel().getDataEntity().getDynamicObject("template");
        if (null == template) {
            return false;
        }
        String showType = template.getString("showtype");
        if ("2".equals(showType)) {
            isPlain = true;
        }
        return isPlain;
    }

    public List<String> getShowCompKeyList() {
        this.getModel().updateCache();
        DynamicObject obj = this.getModel().getDataEntity(true);
        return TemplateUtil.getCompKeyListByTplEntry(obj);
    }

    public Set<String> removeUnShowCompKey(List<String> compKeyList) {
        LinkedHashSet<String> showCompKeySet = new LinkedHashSet<String>(16);
        for (String compKey : compKeyList) {
            if (!this.isShowComponent(compKey)) continue;
            showCompKeySet.add(compKey);
        }
        return showCompKeySet;
    }

    public boolean isShowComponent(String compKey) {
        return true;
    }

    public String showComponet(String targetPage, String compKey, boolean isPlain) {
        this.cacheUnLoadComp(compKey, 1);
        BillShowParameter bs = new BillShowParameter();
        bs.setFormId(this.getLaylout(compKey));
        bs.getOpenStyle().setShowType(ShowType.InContainer);
        bs.getOpenStyle().setTargetKey(targetPage);
        Map<String, Object> params = this.getCompParams(compKey);
        bs.setCustomParams(params);
        IFormView view = this.getView();
        view.setVisible(Boolean.TRUE, new String[]{targetPage});
        String compTitle = this.getShowCompTitle(compKey);
        if (isPlain) {
            Container container = (Container)view.getControl(targetPage);
            if (container != null) {
                HashMap<String, LocaleString> prop = new HashMap<String, LocaleString>(1);
                prop.put("text", new LocaleString(compTitle));
                this.getView().updateControlMetadata(targetPage, prop);
            }
        } else {
            TabPage tabpage = (TabPage)view.getControl(targetPage);
            if (tabpage != null) {
                tabpage.setText(new LocaleString(compTitle));
            }
        }
        this.setComponentStatus(bs);
        DynamicObject component = this.getComponentData(compKey);
        if (null != component) {
            bs.setPkId(component.getPkValue());
        }
        view.showForm((FormShowParameter)bs);
        String pageId = bs.getPageId();
        if (this.isHidenComp(compKey).booleanValue()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{targetPage});
            IFormView subView = this.getView().getView(pageId);
            IFormController formController = (IFormController)subView.getService(IFormController.class);
            formController.loadData();
            this.getView().sendFormAction(subView);
        }
        return pageId;
    }

    public String getLaylout(String compKey) {
        String layout;
        Object template = this.getModel().getValue("template");
        if (null == this.layoutMap) {
            this.layoutMap = new HashMap<String, String>(4);
            if (template != null) {
                DynamicObject templateObj = (DynamicObject)template;
                DynamicObjectCollection cols = (templateObj = BusinessDataServiceHelper.loadSingle((Object)templateObj.getPkValue(), (String)templateObj.getDynamicObjectType().getName())).getDynamicObjectCollection("layoutentry");
                if (cols.size() > 0) {
                    boolean isSup = this.isSup();
                    String layoutPro = isSup ? "layoutsup" : "layoutpur";
                    for (DynamicObject col : cols) {
                        String number = col.getString("layoutcomp.bizobject.number");
                        this.layoutMap.put(number, col.getString(layoutPro + ".number"));
                    }
                }
            }
        }
        if (!StringUtils.isBlank((String)(layout = this.layoutMap.get(compKey)))) {
            return layout;
        }
        return compKey;
    }

    public boolean isSup() {
        boolean isSupplier = false;
        String userType = RequestContext.get().getUserType();
        if (null != userType && userType.contains("3")) {
            boolean isExists;
            isSupplier = true;
            String entityKey = this.getView().getEntityId();
            if (userType.contains("1") && !(isExists = PdsBizNodeUtils.isSupplierNode(entityKey))) {
                isSupplier = false;
            }
        }
        return isSupplier;
    }

    public Boolean isHidenComp(String compKey) {
        Boolean isHidecomp;
        Object template = this.getModel().getValue("template");
        if (null == this.compHideMap) {
            this.compHideMap = new HashMap<String, Boolean>(4);
            if (template != null) {
                DynamicObject templateObj = (DynamicObject)template;
                DynamicObjectCollection cols = (templateObj = BusinessDataServiceHelper.loadSingle((Object)templateObj.getPkValue(), (String)templateObj.getDynamicObjectType().getName())).getDynamicObjectCollection("compentry");
                if (cols.size() > 0) {
                    for (DynamicObject col : cols) {
                        String number = col.getString("bizobject");
                        this.compHideMap.put(number, !col.getBoolean("isshowcomp"));
                    }
                }
            }
        }
        if (null != (isHidecomp = this.compHideMap.get(compKey))) {
            return isHidecomp;
        }
        return Boolean.FALSE;
    }

    public void setComponentStatus(BillShowParameter bs) {
        OperationStatus opStatus = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.VIEW.name().equals(opStatus.name())) {
            bs.setBillStatus(BillOperationStatus.VIEW);
            bs.setStatus(OperationStatus.VIEW);
        } else if (OperationStatus.EDIT.name().equals(opStatus.name()) || OperationStatus.ADDNEW.name().equals(opStatus.name())) {
            String billStatus = this.getModel().getDataEntity().getString("billstatus");
            if (BillStatusEnum.SAVE.getVal().equals(billStatus)) {
                bs.setBillStatus(BillOperationStatus.EDIT);
                bs.setStatus(OperationStatus.EDIT);
            } else if (BillStatusEnum.SUBMIT.getVal().equals(billStatus)) {
                bs.setBillStatus(BillOperationStatus.SUBMIT);
                bs.setStatus(OperationStatus.VIEW);
            } else if (BillStatusEnum.AUDIT.getVal().equals(billStatus)) {
                bs.setBillStatus(BillOperationStatus.AUDIT);
                bs.setStatus(OperationStatus.VIEW);
            } else {
                bs.setBillStatus(BillOperationStatus.ADDNEW);
                bs.setStatus(OperationStatus.ADDNEW);
            }
        }
    }

    public String getShowCompTitle(String compKey) {
        String entityKey = this.getView().getEntityId();
        return PdsCommonUtils.getShowCompTitle(entityKey, compKey, this.getCompRegData(entityKey, compKey));
    }

    public DynamicObject getCompRegData(String entityKey, String compKey) {
        return PdsCommonUtils.getCompRegData(entityKey, compKey);
    }

    public DynamicObject getComponentData(String compKey) {
        String selectProperties = "id";
        Object pkValue = this.getModel().getDataEntity().getPkValue();
        if (String.valueOf(pkValue).equals("0")) {
            return null;
        }
        String entityKey = this.getView().getEntityId();
        QFilter filter = this.getCompQfilter(pkValue, entityKey, compKey);
        return BusinessDataServiceHelper.loadSingle((String)compKey, (String)selectProperties, (QFilter[])new QFilter[]{filter});
    }

    public boolean isNeedFilterEntityKey(String entityKey, String compKey) {
        return false;
    }

    public QFilter getCompQfilter(Object pkValue, String entityKey, String compKey) {
        QFilter filter = null;
        boolean isNeddFilterEntityKey = this.isNeedFilterEntityKey(entityKey, compKey);
        filter = isNeddFilterEntityKey ? TemplateUtil.getComponentQfilter((Object)String.valueOf(pkValue), entityKey, compKey) : TemplateUtil.getComponentQfilter(String.valueOf(pkValue), compKey);
        BizLog.log((String)("###pdscomptplservice getComponetData filter:" + filter.toString()));
        return filter;
    }

    public Map<String, Object> getCompParams(String compKey) {
        HashMap<String, Object> params = new HashMap<String, Object>(1);
        String currDoOperationOpKey = this.getPageCache().get("currDoOperationKey");
        if (null != currDoOperationOpKey && currDoOperationOpKey.trim().length() > 0) {
            params.put("currDoOperationKey", currDoOperationOpKey);
        }
        return params;
    }

    public boolean removeComponent(String compKey) {
        IPageCache cache = this.getPageCache();
        String currPageId = cache.get(compKey);
        if (null == currPageId) {
            return false;
        }
        boolean isPlain = this.isPlain();
        String showCompPanelKey = this.getShowCompPanelKey(isPlain);
        for (int i = 0; i < this.getMaxComponentSize(); ++i) {
            String targetPage = showCompPanelKey + i;
            String pageId = cache.get(targetPage);
            if (!currPageId.equals(pageId)) continue;
            if (i - 1 >= 0) {
                this.activeTab(showCompPanelKey + (i - 1));
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{targetPage});
            ArrayList<String> removeKeyList = new ArrayList<String>(4);
            removeKeyList.add(targetPage);
            removeKeyList.add(compKey);
            removeKeyList.add(pageId);
            cache.batchRemove(removeKeyList);
            return true;
        }
        return false;
    }

    public boolean addComponent(String compKey) {
        IPageCache cache = this.getPageCache();
        boolean isPlain = this.isPlain();
        String showCompPanelKey = this.getShowCompPanelKey(isPlain);
        for (int i = 0; i < this.getMaxComponentSize(); ++i) {
            String targetPage = showCompPanelKey + i;
            String compPageId = cache.get(targetPage);
            if (null != compPageId) continue;
            compPageId = this.showComponet(targetPage, compKey, isPlain);
            if (compPageId != null) {
                this.activeTab(targetPage);
                this.cacheComponentPageId(compKey, targetPage, compPageId);
            }
            return true;
        }
        return false;
    }

    public void clearComponents() {
        this.hideTabPage("tabpageap");
        this.hideContainer("compcontainer");
    }

    public void delTplentryData(DynamicObject compTpl) {
        ArrayList<Integer> delRowIndex = new ArrayList<Integer>();
        DynamicObjectCollection compEntryCols = this.getModel().getEntryEntity("tplentry");
        int rowCount = compEntryCols.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            DynamicObject col = (DynamicObject)compEntryCols.get(i);
            DynamicObject template = col.getDynamicObject("tmp_template");
            if (null != template && !template.getPkValue().toString().equals(compTpl.getPkValue().toString())) continue;
            delRowIndex.add(i);
        }
        int[] delRows = new int[delRowIndex.size()];
        for (int i = 0; i < delRowIndex.size(); ++i) {
            delRows[i] = (Integer)delRowIndex.get(i);
        }
        this.getModel().deleteEntryRows("tplentry", delRows);
    }

    public void createTplentryData(DynamicObject compTpl) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        int i = 0;
        TableValueSetter ts = new TableValueSetter(new String[0]);
        DynamicObjectCollection compEntryCols = compTpl.getDynamicObjectCollection("compentry");
        for (DynamicObject col : compEntryCols) {
            DynamicObject component;
            ts.set("tmp_template", compTpl.getPkValue(), i);
            String bizObj = col.getString("bizobject");
            if (null != bizObj) {
                ts.set("tmp_bizobject", (Object)bizObj, i);
            }
            if (null != (component = col.getDynamicObject("component"))) {
                ts.set("tmp_component", component.getPkValue(), i);
            }
            ++i;
        }
        model.batchCreateNewEntryRow("tplentry", ts);
    }

    public boolean doOperation(String opKey) {
        if (!this.isDoOperation(opKey)) {
            return true;
        }
        boolean existsFailOperation = false;
        HashMap<String, String> reloadCompMap = new HashMap<String, String>(8);
        String realOpKey = opKey;
        this.getPageCache().put("currDoOperationKey", opKey);
        IFormView view = this.getView();
        boolean isPlain = this.isPlain();
        String showCompPanelKey = this.getShowCompPanelKey(isPlain);
        List<String> attachCompKeyList = this.getAttachCompKeyList();
        Map<String, String> operateMap = PdsMetadataUtil.getOpreateMap(this.getView().getEntityId());
        StringBuilder messageTipsSb = new StringBuilder();
        boolean isSubmitAndAudit = this.isSubmitAndAudit();
        for (int i = 0; i < this.getMaxComponentSize(); ++i) {
            String name;
            String message;
            Map<String, String> compOperateMap;
            BillView compView;
            String targetPage = showCompPanelKey + i;
            String pageId = this.getPageCache().get(targetPage);
            if (pageId == null || null == (compView = (BillView)this.getView().getView(pageId))) continue;
            String entityKey = compView.getEntityId();
            boolean isAttach = false;
            if (attachCompKeyList.contains(entityKey)) {
                isAttach = true;
            }
            opKey = realOpKey;
            String opName = operateMap.get(opKey);
            if ("submit".equals(opKey)) {
                if (this.isDataChangedNeedSave(opKey, (IFormView)compView) && compView.getModel().getDataChanged()) {
                    String name2 = this.getShowCompTitle(entityKey);
                    view.showMessage(String.format(ResManager.loadKDString((String)"%1$s\u5185\u5bb9\u5df2\u6539\u53d8\uff0c\u8bf7\u5148\u4fdd\u5b58\uff0c\u518d\u63d0\u4ea4\u3002", (String)"PdsCompTplServiceImpl_3", (String)"scm-pds-common", (Object[])new Object[0]), name2), MessageTypes.Default, null);
                    this.activeTab(targetPage);
                    return false;
                }
                compView.setBillStatus(BillOperationStatus.SUBMIT);
            }
            boolean onlyValidData = false;
            if (!this.isDoCompOperation(opKey, entityKey, isAttach)) {
                onlyValidData = this.onlyValidDataByDoOp(opKey, entityKey, isAttach);
                if (!onlyValidData) {
                    if (!this.isDonothingOperation(opKey, entityKey, isAttach)) continue;
                    opKey = "donothing";
                }
            } else {
                switch (realOpKey) {
                    case "audit": {
                        break;
                    }
                    default: {
                        opKey = realOpKey;
                        compView.setBillStatus(BillOperationStatus.EDIT);
                        boolean isSuccess = this.setCompDefaultVal((IFormView)compView, entityKey);
                        if (isSuccess) break;
                        return false;
                    }
                }
            }
            if (null == (compOperateMap = PdsMetadataUtil.getOpreateMap(entityKey)).get(opKey)) {
                opKey = "donothing";
            }
            OperateOption option = OperateOption.create();
            option.setVariableValue("currDoOperationKey", realOpKey);
            option.setVariableValue("component_onlyvaliddata", String.valueOf(onlyValidData));
            option.setVariableValue("isStrict", String.valueOf(false));
            option.setVariableValue("ishasright", String.valueOf(true));
            option.setVariableValue("WF", String.valueOf(false));
            this.setOperationOption(option, entityKey, opKey);
            OperationResult compOpResult = compView.invokeOperation(opKey, option);
            if (!compOpResult.isSuccess()) {
                StringBuilder errorMsg = new StringBuilder();
                compOpResult.getAllErrorOrValidateInfo().forEach(error -> errorMsg.append(error.getMessage()).append('\n'));
                message = compOpResult.getMessage();
                if (null != message && errorMsg.length() == 0) {
                    errorMsg.append(message).append('\n');
                }
                if (onlyValidData && "pdsCompTplServiceImpl_operationNeedCancel\n".equals(errorMsg.toString())) continue;
                existsFailOperation = true;
                name = this.getShowCompTitle(entityKey);
                view.showMessage(String.format(ResManager.loadKDString((String)"%1$s\u5185\u5bb9%2$s\u5931\u8d25\u3002", (String)"PdsCompTplServiceImpl_5", (String)"scm-pds-common", (Object[])new Object[0]), name, opName), errorMsg.toString(), MessageTypes.Default);
                this.activeTab(targetPage);
                compView.hideLoading();
                break;
            }
            boolean isReloadComp = true;
            if (isSubmitAndAudit && "audit".equals(realOpKey)) {
                isReloadComp = false;
            }
            if (isReloadComp) {
                reloadCompMap.put(entityKey, targetPage);
            }
            if (null == (message = compOpResult.getMessage())) continue;
            name = this.getShowCompTitle(entityKey);
            messageTipsSb.append(name).append(":\n");
            messageTipsSb.append(message).append('\n');
            view.sendFormAction((IFormView)compView);
        }
        this.refreshComponetByDoOp(reloadCompMap, realOpKey, existsFailOperation, isPlain);
        if (existsFailOperation) {
            return false;
        }
        if (messageTipsSb.length() > 0) {
            view.showMessage(ResManager.loadKDString((String)"\u6d88\u606f\u63d0\u793a", (String)"PdsCompTplServiceImpl_6", (String)"scm-pds-common", (Object[])new Object[0]), messageTipsSb.toString(), MessageTypes.Default);
        }
        return true;
    }

    public void refreshComponetByDoOp(Map<String, String> reloadCompMap, String opKey, boolean existsFailOperation, boolean isPlain) {
        if (existsFailOperation) {
            for (Map.Entry<String, String> reloadCompEntry : reloadCompMap.entrySet()) {
                this.reloadComponent(reloadCompEntry.getValue(), reloadCompEntry.getKey(), isPlain);
            }
        }
    }

    public boolean onlyValidDataByDoOp(String operateKey, String entityKey, boolean isAttach) {
        return isAttach && "submit".equals(operateKey);
    }

    private boolean setCompDefaultVal(IFormView compView, String entityKey) {
        try {
            IDataModel compModel = compView.getModel();
            compModel.setDataChanged(false);
            compModel.setValue("parentid", this.getModel().getDataEntity().getPkValue());
            compModel.setValue("entitykey", (Object)entityKey);
            compModel.setValue("pentitykey", (Object)this.view.getEntityId());
        }
        catch (Exception e) {
            BizLog.log((String)String.format(ResManager.loadKDString((String)"\u5bfb\u6e90\u9879\u76ee\u7ec4\u4ef6\u6709\u95ee\u9898\uff0c\u539f\u56e0\uff1a%1$s", (String)"PdsCompTplServiceImpl_7", (String)"scm-pds-common", (Object[])new Object[0]), e.getMessage()));
            return false;
        }
        return true;
    }

    @Deprecated
    public boolean doSaveOperation(String opKey) {
        return this.doOperation(opKey);
    }

    public boolean isDataChangedNeedSave(String operate, IFormView compView) {
        return false;
    }

    public boolean isDoCompOperation(String operateKey, String entityKey, boolean isAttach) {
        return !isAttach;
    }

    public boolean isDonothingOperation(String operateKey, String entityKey, boolean isAttach) {
        return true;
    }

    public List<String> getAttachCompKeyList() {
        DynamicObject obj = this.getModel().getDataEntity(true);
        return TemplateUtil.getCompKeyListByTplEntry(obj, true);
    }

    public void activeTab(String targetPage) {
        Tab tab = (Tab)this.getView().getControl("tabap");
        tab.activeTab(targetPage);
    }

    public void reloadComponent(String targetPage, String compKey, boolean isPlain) {
        String compPageId = this.showComponet(targetPage, compKey, isPlain);
        this.cacheComponentPageId(compKey, targetPage, compPageId);
    }

    private void cacheComponentPageId(String compKey, String targetPage, String compPageId) {
        IPageCache cache = this.getPageCache();
        if (compPageId != null) {
            String srcPageId = cache.get(compKey);
            if (null != srcPageId) {
                cache.remove(srcPageId);
            }
            cache.put(targetPage, compPageId);
            cache.put(compKey, compPageId);
            cache.put(compPageId, compKey);
        }
    }

    private String getCurrTabPageByCache() {
        IPageCache cache = this.getPageCache();
        String compKey = cache.get(CURRENTTABPAGE);
        if (null != compKey) {
            String currPageId = cache.get(compKey);
            if (null == currPageId) {
                return null;
            }
            int maxComponentSize = this.getMaxComponentSize();
            for (int i = 0; i < maxComponentSize; ++i) {
                String currTargetPage = "tabpageap" + i;
                String pageId = cache.get(currTargetPage);
                if (!currPageId.equals(pageId)) continue;
                return currTargetPage;
            }
        }
        return null;
    }

    public int getMaxComponentSize() {
        return 20;
    }

    public void cacheUnLoadComp(String compKey, int count) {
        this.getCache().put(this.getCacheKey(compKey), (Object)String.valueOf(count));
    }

    public String getCacheKey(String compKey) {
        String currPageId = this.getView().getPageId();
        return currPageId + "_" + compKey + "_" + "unloadcompcount";
    }

    public boolean isLoadedComp(String opKey) {
        Set<String> opkeySet = this.getLoadedCompOpkeySet();
        if (opkeySet.contains(opKey)) {
            List<String> compKeyList = this.getShowCompKeyList();
            Set<String> compKeySet = this.removeUnShowCompKey(compKeyList);
            for (String compKey : compKeySet) {
                String unloadComp_count = this.getUnloadCompByCache(compKey);
                if (null == unloadComp_count) continue;
                Integer compCount = Integer.parseInt(unloadComp_count);
                if (compCount > 0) {
                    return false;
                }
                String pageId = this.getPageCache().get(compKey);
                IFormView compView = SessionManager.getCurrent().getView(pageId);
                try {
                    if (null != compView && null != compView.getModel().getDataEntity(true)) continue;
                    return false;
                }
                catch (Exception e) {
                    return false;
                }
            }
        }
        return true;
    }

    private String getUnloadCompByCache(String compKey) {
        return (String)this.getCache().get(this.getCacheKey(compKey), String.class);
    }

    private Set<String> getLoadedCompOpkeySet() {
        HashSet<String> opkeySet = new HashSet<String>(8);
        opkeySet.add("save");
        opkeySet.add("submit");
        opkeySet.add("unsubmit");
        if (this.isSubmitAndAudit()) {
            opkeySet.remove("audit");
        } else {
            opkeySet.add("audit");
        }
        opkeySet.add("unaudit");
        opkeySet.add("querycompconfig");
        HashSet<String> customerOpkeySet = new HashSet<String>(8);
        this.addCustomerIsLoadedOpKey(customerOpkeySet);
        opkeySet.addAll(customerOpkeySet);
        return opkeySet;
    }

    public void addCustomerIsLoadedOpKey(Set<String> customerOpkeySet) {
    }

    public void saveData() {
        DynamicObject obj = this.getModel().getDataEntity(true);
        if (0L == obj.getLong("id")) {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
        }
    }

    public void setParentId() {
        DynamicObject obj = this.getModel().getDataEntity();
        obj.set("parentid", obj.getPkValue());
        if (Objects.equals("src_project", this.getView().getEntityId())) {
            obj.set("projectf7", obj.getPkValue());
        }
    }

    public void setOperationOption(OperateOption option, String comKey, String opKey) {
    }

    public IAppCache getCache() {
        return AppCache.get((String)"pds");
    }

    public boolean isSubmitAndAudit() {
        Object submitAndAudit = SystemParamServiceHelper.getBillParameter((String)this.getView().getEntityId(), (String)SUBMITANDAUDIT);
        return submitAndAudit instanceof Boolean && (Boolean)submitAndAudit != false;
    }

    public boolean setPreViewTemplate() {
        Object templateId = PdsCommonUtils.getCustomParamValue(this.view, "preview_templateid");
        if (null == templateId) {
            return false;
        }
        this.model.setValue("billstatus", (Object)BillStatusEnum.AUDIT.getVal());
        this.model.setValue("template", templateId);
        this.model.setDataChanged(false);
        DynamicObject templateObj = (DynamicObject)this.model.getValue("template");
        this.clearComponents();
        this.loadComponents(templateObj);
        Map<String, String> buttonMap = PdsMetadataUtil.getButtonMap(this.view.getEntityId()).get("businessop");
        if (buttonMap.size() > 0) {
            String[] buttonKeyArr = new String[buttonMap.size()];
            int index = 0;
            Iterator<String> iterator = buttonMap.keySet().iterator();
            while (iterator.hasNext()) {
                String key;
                buttonKeyArr[index] = key = iterator.next();
                ++index;
            }
            this.view.setVisible(Boolean.FALSE, buttonKeyArr);
        }
        this.view.setVisible(Boolean.TRUE, new String[]{"bar_close", "bar_exit"});
        return true;
    }

    @Override
    public void beforeClose(PdsCompTplContext context) {
        String changeDesc;
        this.initParam(context);
        String billStatus = this.getModel().getDataEntity().getString("billstatus");
        if (!BillStatusEnum.SAVE.getVal().equals(billStatus)) {
            return;
        }
        boolean isPlain = this.isPlain();
        StringBuilder msgSb = new StringBuilder();
        boolean dataChanged = this.getModel().getDataChanged();
        if (dataChanged && !StringUtils.isEmpty((String)(changeDesc = this.getModel().getChangeDesc()))) {
            msgSb.append(changeDesc);
        }
        String showCompPanelKey = this.getShowCompPanelKey(isPlain);
        for (int i = 0; i < this.getMaxComponentSize(); ++i) {
            String changeDesc2;
            String entityKey;
            BillView compView;
            String targetPage = showCompPanelKey + i;
            String pageId = this.getPageCache().get(targetPage);
            if (pageId == null || null == (compView = (BillView)this.getView().getView(pageId)) || !this.isValidDataChanged(entityKey = compView.getEntityId()) || StringUtils.isEmpty((String)(changeDesc2 = this.getChangeDesc(compView)))) continue;
            if (msgSb.length() > 0) {
                msgSb.append("\n");
            }
            String name = this.getShowCompTitle(entityKey);
            msgSb.append(name).append("->").append(changeDesc2);
        }
        if (msgSb.length() > 0) {
            context.getBeforeCloseEvent().setCancel(true);
            this.view.showConfirm(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"PdsCompTplServiceImpl_8", (String)"scm-pds-common", (Object[])new Object[0]), msgSb.toString(), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("pdsCompDataChangeCallBackKey"));
        }
    }

    public String getChangeDesc(BillView compView) {
        String changeDesc = "";
        if (compView.getModel().isDataLoaded() && compView.getModel().getDataChanged()) {
            changeDesc = compView.getModel().getChangeDesc();
        }
        return changeDesc;
    }

    public boolean isValidDataChanged(String entityKey) {
        return true;
    }
}

