/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.conform;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.ExtPluginFactory;
import kd.scm.pds.common.extplugin.IExtPluginHandler;
import kd.scm.pds.common.util.ExtParameterUtils;
import kd.scm.pds.common.util.PdsCommonUtils;

public class PdsConformUtils {
    public static ExtPluginContext conformQuery(DynamicObject projectObj, long extPluginId, String extPluginName) {
        ExtPluginContext context = new ExtPluginContext();
        HashMap fieldMap = new HashMap(8);
        context.getParamMap2().put("fieldid", fieldMap);
        context.setProjectObj(projectObj);
        context.setBillObj(projectObj);
        context.setProjectId(SrmCommonUtil.getPkValue((DynamicObject)projectObj));
        context.setBillId(extPluginId);
        IExtPluginHandler hander = (IExtPluginHandler)ExtPluginFactory.getInstance().getExtPluginInstanceSingle(extPluginName);
        hander.process(context);
        return context;
    }

    public static Map<String, String> getBudgetControlMap(String entityName, String pluginName) {
        HashMap<String, String> budgetControlMap = new HashMap<String, String>(4);
        String budgetSource = (String)ExtParameterUtils.getExtParameterValueByPluginname(entityName, pluginName, "budgetControlSource", "1");
        budgetControlMap.put("budgetSource", budgetSource);
        String budgetDimension = (String)ExtParameterUtils.getExtParameterValueByPluginname(entityName, pluginName, "budgetControlDimension", "1");
        budgetControlMap.put("budgetDimension", budgetDimension);
        String compareType = (String)ExtParameterUtils.getExtParameterValueByPluginname(entityName, pluginName, "budgetControlType", "<=");
        budgetControlMap.put("compareType", compareType);
        String budgetRatio = (String)ExtParameterUtils.getExtParameterValueByPluginname(entityName, pluginName, "budgetControlRatio", "100");
        budgetControlMap.put("budgetRatio", budgetRatio);
        return budgetControlMap;
    }

    public static BigDecimal getBudgetAmount(long projectId, Map<String, String> buggetControlMap) {
        String selectFields = "taxtype,sourceamount,amount,sceneamount,scenetaxamount";
        DynamicObject baseObj = QueryServiceHelper.queryOne((String)"src_project_base", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)projectId)});
        buggetControlMap.put("taxtype", baseObj.getString("taxtype"));
        boolean isNoTax = "2".equals(buggetControlMap.get("taxtype"));
        BigDecimal budgetAmount = BigDecimal.ZERO;
        budgetAmount = "1".equals(buggetControlMap.get("budgetSource")) ? (isNoTax ? baseObj.getBigDecimal("sceneamount") : baseObj.getBigDecimal("scenetaxamount")) : (isNoTax ? baseObj.getBigDecimal("sourceamount") : baseObj.getBigDecimal("amount"));
        return budgetAmount;
    }

    public static Map<String, BigDecimal> getDecisionAmount(long projectId, Map<String, String> buggetControlMap) {
        DynamicObject[] rows;
        HashMap<String, BigDecimal> decisionAmtMap = new HashMap<String, BigDecimal>();
        boolean isNoTax = "2".equals(buggetControlMap.get("taxtype"));
        if ("1".equals(buggetControlMap.get("budgetDimension"))) {
            DynamicObject decisoinObj = BusinessDataServiceHelper.loadSingle((String)"src_decision", (String)"sumamount,sumtaxamount", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)projectId)});
            String key = PdsCommonUtils.buildString(projectId, "|", "");
            BigDecimal amount = isNoTax ? decisoinObj.getBigDecimal("sumamount") : decisoinObj.getBigDecimal("sumtaxamount");
            decisionAmtMap.put(key, amount);
            return decisionAmtMap;
        }
        for (DynamicObject row : rows = BusinessDataServiceHelper.load((String)"src_decisionsumsup", (String)"suppliertype,supplier,amount,taxamount", (QFilter[])new QFilter[]{new QFilter("project", "=", (Object)projectId)})) {
            BigDecimal amount = isNoTax ? row.getBigDecimal("amount") : row.getBigDecimal("taxamount");
            String key = PdsCommonUtils.buildString(row.getLong("supplier.id"), "|", row.getString("supplier.name"));
            if (null == decisionAmtMap.get(key)) {
                decisionAmtMap.put(key, amount);
                continue;
            }
            decisionAmtMap.put(key, ((BigDecimal)decisionAmtMap.get(key)).add(amount));
        }
        return decisionAmtMap;
    }

    public static StringBuilder budgetVerify(Map<String, String> buggetControlMap, Map<String, BigDecimal> decisionAmtMap, BigDecimal budgetAmount) {
        StringBuilder message = new StringBuilder();
        for (Map.Entry<String, BigDecimal> entry : decisionAmtMap.entrySet()) {
            String name;
            String[] keys = entry.getKey().split("\\|");
            String string = name = keys.length > 1 ? PdsCommonUtils.object2String(keys[1], "") : "";
            BigDecimal decisionAmount = entry.getValue();
            if (PdsConformUtils.isVerifyOk(buggetControlMap, decisionAmount, budgetAmount)) continue;
            message.append(name).append(ResManager.loadKDString((String)"\u9884\u7b97\u91d1\u989d\u6821\u9a8c\u4e0d\u901a\u8fc7\uff1a", (String)"PdsConformUtils_19", (String)"scm-pds-common", (Object[])new Object[0]));
            message.append(ResManager.loadKDString((String)"\u9879\u76ee\u7684\u9884\u4f30\u91d1\u989d\uff1a", (String)"PdsConformUtils_20", (String)"scm-pds-common", (Object[])new Object[0])).append(budgetAmount).append(", ");
            message.append(ResManager.loadKDString((String)"\u5b9a\u6807\u7684\u4e2d\u6807\u91d1\u989d\uff1a", (String)"PdsConformUtils_21", (String)"scm-pds-common", (Object[])new Object[0])).append(decisionAmount).append(", ");
            message.append(ResManager.loadKDString((String)"\u63a7\u5236\u6bd4\u7387%\uff1a", (String)"PdsConformUtils_22", (String)"scm-pds-common", (Object[])new Object[0])).append(buggetControlMap.get("budgetRatio")).append(", ");
            message.append(ResManager.loadKDString((String)"\u63a7\u5236\u65b9\u5f0f\uff1a", (String)"PdsConformUtils_23", (String)"scm-pds-common", (Object[])new Object[0])).append(PdsConformUtils.getCompareTypeName(buggetControlMap));
        }
        return message;
    }

    public static boolean isVerifyOk(Map<String, String> buggetControlMap, BigDecimal decisionAmount, BigDecimal budgetAmount) {
        if (decisionAmount.compareTo(BigDecimal.ZERO) == 0 || budgetAmount.compareTo(BigDecimal.ZERO) == 0) {
            return true;
        }
        BigDecimal ratio = new BigDecimal(buggetControlMap.get("budgetRatio")).divide(BigDecimal.TEN).divide(BigDecimal.TEN);
        BigDecimal ratioAmount = budgetAmount.multiply(ratio);
        BigDecimal ratioAmount2 = budgetAmount.add(budgetAmount.multiply(BigDecimal.ONE.subtract(ratio)));
        switch (buggetControlMap.get("compareType")) {
            case "=": {
                return decisionAmount.compareTo(ratioAmount) == 0;
            }
            case "<=": {
                return decisionAmount.compareTo(ratioAmount) <= 0;
            }
            case "<": {
                return decisionAmount.compareTo(ratioAmount) < 0;
            }
            case ">=": {
                return decisionAmount.compareTo(ratioAmount) >= 0;
            }
            case ">": {
                return decisionAmount.compareTo(ratioAmount) > 0;
            }
            case "><": {
                return decisionAmount.compareTo(ratioAmount) > 0 && decisionAmount.compareTo(ratioAmount2) < 0;
            }
            case ">=<=": {
                return decisionAmount.compareTo(ratioAmount) >= 0 && decisionAmount.compareTo(ratioAmount2) <= 0;
            }
        }
        return true;
    }

    public static String getCompareTypeName(Map<String, String> buggetControlMap) {
        switch (buggetControlMap.get("compareType")) {
            case "=": {
                return ResManager.loadKDString((String)"\u4e2d\u6807\u91d1\u989d=\u9884\u4f30\u91d1\u989d\u00d7\u6bd4\u7387%", (String)"PdsConformUtils_12", (String)"scm-pds-common", (Object[])new Object[0]);
            }
            case "<=": {
                return ResManager.loadKDString((String)"\u4e2d\u6807\u91d1\u989d<=\u9884\u4f30\u91d1\u989d\u00d7\u6bd4\u7387%", (String)"PdsConformUtils_13", (String)"scm-pds-common", (Object[])new Object[0]);
            }
            case "<": {
                return ResManager.loadKDString((String)"\u4e2d\u6807\u91d1\u989d<\u9884\u4f30\u91d1\u989d\u00d7\u6bd4\u7387%", (String)"PdsConformUtils_14", (String)"scm-pds-common", (Object[])new Object[0]);
            }
            case ">=": {
                return ResManager.loadKDString((String)"\u4e2d\u6807\u91d1\u989d>=\u9884\u4f30\u91d1\u989d\u00d7\u6bd4\u7387%", (String)"PdsConformUtils_15", (String)"scm-pds-common", (Object[])new Object[0]);
            }
            case ">": {
                return ResManager.loadKDString((String)"\u4e2d\u6807\u91d1\u989d>\u9884\u4f30\u91d1\u989d\u00d7\u6bd4\u7387%", (String)"PdsConformUtils_16", (String)"scm-pds-common", (Object[])new Object[0]);
            }
            case "><": {
                return ResManager.loadKDString((String)"\u4e2d\u6807\u91d1\u989d>\u9884\u4f30\u91d1\u989d\u00d7\u6bd4\u7387% \u4e14 \u4e2d\u6807\u91d1\u989d<\u9884\u4f30\u91d1\u989d\u00d7(1+\u6bd4\u7387%)", (String)"PdsConformUtils_17", (String)"scm-pds-common", (Object[])new Object[0]);
            }
            case ">=<=": {
                return ResManager.loadKDString((String)"\u4e2d\u6807\u91d1\u989d>=\u9884\u4f30\u91d1\u989d\u00d7\u6bd4\u7387% \u4e14 \u4e2d\u6807\u91d1\u989d<=\u9884\u4f30\u91d1\u989d\u00d7(1+\u6bd4\u7387%)", (String)"PdsConformUtils_18", (String)"scm-pds-common", (Object[])new Object[0]);
            }
        }
        return "";
    }
}

