/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.conform.supplierip;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.IExtPluginHandler;

public interface IPdsSupplierIPVerify
extends IExtPluginHandler {
    default public QFilter getVerifyQFilter(long projectId, String projectField) {
        QFilter qfilters = new QFilter(projectField, "=", (Object)projectId);
        qfilters.and("supplier", ">", (Object)0);
        qfilters.and("supplierip", "!=", (Object)Character.valueOf(' '));
        qfilters.and("supplierip", "is not null", (Object)Character.valueOf(' '));
        return qfilters;
    }

    default public void verifySupplierIP(ExtPluginContext context) {
        String selectFields = DynamicObjectUtil.getSelectfields((String)context.getEntityId(), (boolean)false);
        DynamicObject[] rows = BusinessDataServiceHelper.load((String)context.getEntityId(), (String)selectFields, (QFilter[])context.getQfilters().toArray());
        if (null == rows || rows.length == 0) {
            return;
        }
        StringBuilder sb = this.verifySupplierIP(context, rows);
        if (null != sb && sb.length() > 0) {
            Object countObj = context.getParamMap().get("count");
            if (null == countObj) {
                context.getParamMap().put("count", 1);
            } else {
                context.getParamMap().put("count", (Integer)countObj + 1);
            }
            context.setSucced(false);
            context.setMessage(sb);
        }
    }

    default public StringBuilder verifySupplierIP(ExtPluginContext context, DynamicObject[] rows) {
        StringBuilder sb = new StringBuilder();
        Map<String, List<DynamicObject>> supMap = null;
        Map<String, List<DynamicObject>> ipMap = Arrays.asList(rows).stream().collect(Collectors.groupingBy(e -> e.getString("supplierip")));
        for (Map.Entry<String, List<DynamicObject>> entry : ipMap.entrySet()) {
            if (entry.getValue().size() <= 1 || (supMap = entry.getValue().stream().collect(Collectors.groupingBy(e -> e.getString("supplier.number") + '_' + e.getString("supplier.name")))).size() <= 1) continue;
            sb.append(entry.getKey()).append(":");
            StringBuilder supStr = new StringBuilder();
            for (String supKey : supMap.keySet()) {
                if (supStr.length() > 0) {
                    supStr.append(',');
                }
                supStr.append(supKey);
            }
            sb.append((CharSequence)supStr).append('\u3002');
        }
        if (sb.length() > 0) {
            return new StringBuilder(context.getOperationKey()).append((CharSequence)sb);
        }
        return sb;
    }
}

