/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.costdetail;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.IExtPluginHandler;
import kd.scm.pds.common.util.PdsCostDetailUtils;

public class PdsCostDetailCalcEntryAmount
implements IExtPluginHandler {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(ExtPluginContext context) {
        String entityType = context.getEntryEntityId();
        String entityName = context.getEntityId();
        switch (entityType) {
            case "EntryType": 
            case "EntryProp": {
                if ("2".equals(context.getView().getModel().getDataEntity().getString("type"))) {
                    this.calcEntryPrice(context, entityName);
                    break;
                }
                this.calcEntryAmount(context, entityName, "");
                break;
            }
            case "TreeEntryType": 
            case "TreeEntryProp": {
                this.calcEntryAmount(context, entityName, "");
                break;
            }
            case "SubEntryType": 
            case "SubEntryProp": {
                this.calcEntryAmount(context, entityName, "sub");
                this.calcParentEntryAmount(context, entityName, "sub");
                break;
            }
            default: {
                this.calcEntryAmount(context, "entryentity", "");
            }
        }
    }

    protected void calcEntryPrice(ExtPluginContext context, String entityName) {
        IDataModel model = context.getView().getModel();
        int priceprecision = null == model.getDataEntity().getDynamicObject("currencyid") ? 6 : model.getDataEntity().getInt("currencyid.priceprecision");
        int index = model.getEntryCurrentRowIndex(entityName);
        if (index < 0) {
            return;
        }
        DynamicObject row = model.getEntryRowEntity(entityName, index);
        BigDecimal qty = PdsCostDetailUtils.getQtyAndRatio(row.getBigDecimal("qty"), row.getBigDecimal("ratio"));
        if ("2".equals(context.getView().getModel().getDataEntity().getString("taxtype"))) {
            BigDecimal value = row.getBigDecimal("amount").divide(qty, priceprecision, RoundingMode.HALF_DOWN);
            model.setValue("price", (Object)value);
        } else {
            BigDecimal value = row.getBigDecimal("taxamount").divide(qty, priceprecision, RoundingMode.HALF_DOWN);
            model.setValue("taxprice", (Object)value);
        }
    }

    protected void calcEntryAmount(ExtPluginContext context, String entityName, String prefix) {
        IDataModel model = context.getView().getModel();
        int priceprecision = null == model.getDataEntity().getDynamicObject("currencyid") ? 6 : model.getDataEntity().getInt("currencyid.priceprecision");
        int index = model.getEntryCurrentRowIndex(entityName);
        if (index < 0) {
            return;
        }
        DynamicObject row = model.getEntryRowEntity(entityName, index);
        BigDecimal qty = PdsCostDetailUtils.getQtyAndRatio(row.getBigDecimal(prefix + "qty"), row.getBigDecimal(prefix + "ratio"));
        if (("TreeEntryType".equals(context.getEntryEntityId()) || "TreeEntryProp".equals(context.getEntryEntityId())) && row.getLong("childcount") > 0L) {
            if ("2".equals(context.getView().getModel().getDataEntity().getString("taxtype"))) {
                BigDecimal value = row.getBigDecimal(prefix + "amount").divide(qty, priceprecision, RoundingMode.HALF_DOWN);
                model.setValue(prefix + "price", (Object)value);
            } else {
                BigDecimal value = row.getBigDecimal(prefix + "taxamount").divide(qty, priceprecision, RoundingMode.HALF_DOWN);
                model.setValue(prefix + "taxprice", (Object)value);
            }
        } else if ("2".equals(context.getView().getModel().getDataEntity().getString("taxtype"))) {
            BigDecimal value = qty.multiply(row.getBigDecimal(prefix + "price"));
            model.setValue(prefix + "amount", (Object)value);
        } else {
            BigDecimal value = qty.multiply(row.getBigDecimal(prefix + "taxprice"));
            model.setValue(prefix + "taxamount", (Object)value);
        }
    }

    protected void calcParentEntryAmount(ExtPluginContext context, String entityName, String prefix) {
        IDataModel model = context.getView().getModel();
        int priceprecision = null == model.getDataEntity().getDynamicObject("currencyid") ? 6 : model.getDataEntity().getInt("currencyid.priceprecision");
        DynamicObjectCollection rows = model.getEntryEntity(entityName);
        BigDecimal sumAmount = BigDecimal.ZERO;
        String priceField = "price";
        String amountField = "amount";
        if (!"2".equals(context.getView().getModel().getDataEntity().getString("taxtype"))) {
            priceField = "taxprice";
            amountField = "taxamount";
        }
        for (DynamicObject row : rows) {
            sumAmount = sumAmount.add(row.getBigDecimal(prefix + amountField));
        }
        int index = model.getEntryCurrentRowIndex("entryentity");
        BigDecimal sumQty = PdsCostDetailUtils.getQtyAndRatio(model.getEntryRowEntity("entryentity", index).getBigDecimal("qty"), model.getEntryRowEntity("entryentity", index).getBigDecimal("ratio"));
        BigDecimal avgPrice = sumAmount.divide(sumQty, priceprecision, RoundingMode.HALF_DOWN);
        model.setValue(priceField, (Object)avgPrice, index);
        model.setValue(amountField, (Object)sumAmount, index);
    }
}

