/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.costdetail;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.IExtPluginHandler;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.TemplateUtil;

public class PdsCostDetailCalcTotalAmount
implements IExtPluginHandler {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(ExtPluginContext context) {
        this.deleteInValidData(context);
        BigDecimal sumAmount = this.calcTotalAmount(context);
        this.setTotalAmount(context, sumAmount);
    }

    protected BigDecimal calcTotalAmount(ExtPluginContext context) {
        long projectId = context.getBillObj().getLong("project.id");
        long purlistId = context.getBillObj().getLong("purlist.id");
        QFilter qfilter = new QFilter("project", "=", (Object)projectId);
        qfilter.and("purlist", "=", (Object)purlistId);
        qfilter.and("parententryid", "=", (Object)0);
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"pds_costdetailentryf7", (String)"amount,taxamount", (QFilter[])qfilter.toArray());
        BigDecimal sumAmount = BigDecimal.ZERO;
        String amountField = "amount";
        if (!"2".equals(context.getBillObj().getString("taxtype"))) {
            amountField = "taxamount";
        }
        for (DynamicObject row : rows) {
            sumAmount = sumAmount.add(row.getBigDecimal(amountField));
        }
        return sumAmount;
    }

    protected void setTotalAmount(ExtPluginContext context, BigDecimal sumAmount) {
        if ("2".equals(context.getBillObj().getString("taxtype"))) {
            context.getBillObj().set("sumamount", (Object)sumAmount);
        } else {
            context.getBillObj().set("sumtaxamount", (Object)sumAmount);
        }
        PdsCommonUtils.saveDynamicObjects(context.getBillObj());
    }

    protected void deleteInValidData(ExtPluginContext context) {
        QFilter qfilter = new QFilter("parentid", "=", (Object)context.getBillObj().getString("purlist.id"));
        qfilter.and("pentitykey", "=", (Object)context.getEntityId());
        qfilter.and("entitykey", "not in", TemplateUtil.getCompKeyList(context.getBillObj()));
        DeleteServiceHelper.delete((String)"pds_costdetailcomp1", (QFilter[])qfilter.toArray());
        DeleteServiceHelper.delete((String)"pds_costdetailcomp2", (QFilter[])qfilter.toArray());
        DeleteServiceHelper.delete((String)"pds_costdetailcomp3", (QFilter[])qfilter.toArray());
    }
}

