/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.costdetail;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.IExtPluginHandler;
import kd.scm.pds.common.util.PdsCostDetailUtils;

public class PdsCostDetailCalcTreeParentAmount
implements IExtPluginHandler {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(ExtPluginContext context) {
        String entityType;
        switch (entityType = context.getEntryEntityId()) {
            case "TreeEntryType": 
            case "TreeEntryProp": {
                this.calcTreeParentAmount(context, "entryentity");
                break;
            }
        }
    }

    protected void calcTreeParentAmount(ExtPluginContext context, String entityName) {
        DynamicObjectCollection rows = context.getView().getModel().getEntryEntity(entityName);
        Map<String, String> paramMap = this.getParamMap(context);
        this.initEntryValue(paramMap, rows);
        Map<Long, DynamicObject> entryId_ObjectMap = PdsCostDetailUtils.getEntryId_ObjectMap(rows);
        Map<Long, BigDecimal> amountMap = this.getAmountMap(paramMap, rows, entryId_ObjectMap);
        context.getView().getModel().beginInit();
        this.updateEntryValue(paramMap, rows, amountMap);
        context.getView().getModel().endInit();
        context.getView().updateView("entryentity");
    }

    private Map<String, String> getParamMap(ExtPluginContext context) {
        HashMap<String, String> paramMap = new HashMap<String, String>(8);
        String taxType = context.getView().getModel().getDataEntity().getString("taxtype");
        paramMap.put("taxtype", taxType);
        int priceprecision = context.getView().getModel().getDataEntity().getInt("currencyid.priceprecision");
        paramMap.put("priceprecision", String.valueOf(priceprecision));
        if ("2".equals(taxType)) {
            paramMap.put("price", "price");
            paramMap.put("amount", "amount");
        } else {
            paramMap.put("price", "taxprice");
            paramMap.put("amount", "taxamount");
        }
        return paramMap;
    }

    private void initEntryValue(Map<String, String> paramMap, DynamicObjectCollection rows) {
        for (DynamicObject row : rows) {
            if (row.getInt("childcount") > 0) {
                row.set(paramMap.get("amount"), (Object)0);
            }
            if (row.getLong("pid") == 0L) {
                row.set("number", (Object)-1);
                continue;
            }
            row.set("number", (Object)row.getInt("childcount"));
        }
    }

    private Map<Long, BigDecimal> getAmountMap(Map<String, String> paramMap, DynamicObjectCollection rows, Map<Long, DynamicObject> entryId_ObjectMap) {
        HashMap<Long, BigDecimal> amountMap = new HashMap<Long, BigDecimal>(rows.size());
        boolean isChanged = true;
        while (isChanged) {
            isChanged = false;
            for (int i = rows.size() - 1; i >= 0; --i) {
                DynamicObject row = (DynamicObject)rows.get(i);
                if (row.getInt("number") != 0) continue;
                long id = row.getLong("id");
                long pId = row.getLong("pid");
                BigDecimal amount = row.getBigDecimal(paramMap.get("amount"));
                if (null != amountMap.get(id)) {
                    amount = amount.add((BigDecimal)amountMap.get(id));
                }
                if (amountMap.get(pId) == null) {
                    amountMap.put(pId, amount);
                } else {
                    amountMap.put(pId, ((BigDecimal)amountMap.get(pId)).add(amount));
                }
                row.set("number", (Object)-1);
                DynamicObject pRow = entryId_ObjectMap.get(pId);
                if (null != pRow && pRow.getInt("number") > 0) {
                    pRow.set("number", (Object)0);
                }
                isChanged = true;
            }
        }
        return amountMap;
    }

    private void updateEntryValue(Map<String, String> paramMap, DynamicObjectCollection rows, Map<Long, BigDecimal> amountMap) {
        int priceprecision = Integer.parseInt(paramMap.get("priceprecision"));
        for (int i = rows.size() - 1; i >= 0; --i) {
            DynamicObject row = (DynamicObject)rows.get(i);
            if (row.getInt("childcount") <= 0) continue;
            BigDecimal qty = PdsCostDetailUtils.getQtyAndRatio(row.getBigDecimal("qty"), row.getBigDecimal("ratio"));
            BigDecimal amount = amountMap.get(row.getLong("id"));
            row.set(paramMap.get("price"), (Object)amount.divide(qty, priceprecision, RoundingMode.HALF_DOWN));
            row.set(paramMap.get("amount"), (Object)amount);
        }
    }
}

