/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.costdetail;

import java.math.BigDecimal;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.scm.common.util.cal.ICal;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.IExtPluginHandler;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.SrcCalImpl;

public class PdsCostDetailUpdatePurlist
implements IExtPluginHandler {
    private static final long serialVersionUID = 1L;
    private ICal cal = new SrcCalImpl();

    @Override
    public void process(ExtPluginContext context) {
        this.updatePurlistValue(context);
    }

    private void updatePurlistValue(ExtPluginContext context) {
        IFormView parentView = context.getView().getParentView();
        if (null == parentView) {
            return;
        }
        Object indexObj = PdsCommonUtils.getCustomParamValue(context.getView(), "index");
        if (null == indexObj) {
            return;
        }
        IDataModel model = parentView.getModel();
        int index = Integer.parseInt(indexObj.toString());
        String priceField = "price";
        String amountField = "sumamount";
        if (!"2".equals(context.getView().getModel().getDataEntity().getString("taxtype"))) {
            priceField = "taxprice";
            amountField = "sumtaxamount";
        }
        BigDecimal preValue = model.getValue(priceField, index) == null ? BigDecimal.ZERO : (BigDecimal)model.getValue(priceField, index);
        BigDecimal newValue = context.getView().getModel().getDataEntity().getBigDecimal(amountField);
        model.beginInit();
        model.setValue("costdetail", (Object)"1", index);
        if (preValue.compareTo(newValue) != 0) {
            model.setValue(priceField, (Object)newValue, index);
            this.cal.proChanged(model, "entryentity", priceField);
            parentView.updateView("entryentity", index);
        } else {
            parentView.updateView("costdetail", index);
        }
        model.endInit();
        context.getView().sendFormAction(parentView);
    }
}

