/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.dataimport;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pds.common.dataimport.DataImportResponse;
import kd.scm.pds.common.dataimport.DynamicObjectHandler;
import kd.scm.pds.common.dataimport.PdsDtsSymbol;
import kd.scm.pds.common.dataimport.handler.PdsDynamicObjHandler;
import kd.scm.pds.common.enums.ImportMode;
import kd.scm.pds.common.enums.ImportStatus;
import kd.scm.pds.common.extplugin.ExtPluginFactory;

public class DataImportService {
    public List<DataImportResponse> doImport(Reader reader, Map<String, Object> param) throws IOException {
        List<String> dts = this.readDts(reader);
        return this.doImport(dts, param);
    }

    public List<DataImportResponse> doImport(List<String> dts, Map<String, Object> param) {
        ArrayList<DataImportResponse> responses = new ArrayList<DataImportResponse>(dts.size());
        ArrayList<DynamicObject> successObjs = new ArrayList<DynamicObject>(dts.size());
        for (String dt : dts) {
            DataImportResponse response = new DataImportResponse(ImportStatus.SUCCESS);
            this.checkValid(response, dt);
            if (response.getStatus() == ImportStatus.FAILED) {
                response.setEntityTitle(String.valueOf(param.get("fileName")));
                responses.add(response);
                continue;
            }
            String[] split = dt.split("@PDS@");
            PdsDtsSymbol pdsDtsSymbol = new PdsDtsSymbol(split[0]);
            Object entityKey = param.get("entitykey");
            if (null != entityKey && !pdsDtsSymbol.isRef() && !String.valueOf(entityKey).equals(pdsDtsSymbol.getEntityName())) {
                response = new DataImportResponse(ImportStatus.FAILED, pdsDtsSymbol);
                response.setMessage(ResManager.loadKDString((String)"\u8d44\u6e90\u6587\u4ef6\u7c7b\u578b\u4e0e\u5bfc\u5165\u7684\u6570\u636e\u4e0d\u5339\u914d\uff0c\u8bf7\u786e\u8ba4\u8d44\u6e90\u662f\u5426\u6b63\u786e\u3002", (String)"DataImportService_0", (String)"scm-pds-common", (Object[])new Object[0]));
                responses.add(response);
                continue;
            }
            response = this.innerSaveObject(successObjs, pdsDtsSymbol, split[1], param == null ? Collections.emptyMap() : param);
            responses.add(response);
        }
        return responses;
    }

    private void checkValid(DataImportResponse response, String line) {
        if (!line.contains("@PDS@")) {
            response.setMessage(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u5b57\u7b26\u4e32\u4e0d\u5408\u6cd5\uff0c\u672a\u5305\u542b\u7279\u6b8a\u5206\u9694\u7b26", (String)"DataImportService_1", (String)"scm-pds-common", (Object[])new Object[0]));
            response.setStatus(ImportStatus.FAILED);
        }
    }

    private DataImportResponse innerSaveObject(List<DynamicObject> successObjs, PdsDtsSymbol pdsDtsSymbol, String dataJsonStr, Map<String, Object> param) {
        if (ImportMode.IGNORED == pdsDtsSymbol.getImportMode()) {
            return new DataImportResponse(ImportStatus.IGNORED, pdsDtsSymbol);
        }
        boolean isExisted = this.isExisted(pdsDtsSymbol.getId(), pdsDtsSymbol.getEntityName());
        boolean ignoredRef = pdsDtsSymbol.isRef();
        if (ignoredRef && isExisted) {
            return new DataImportResponse(ImportStatus.IGNORED, pdsDtsSymbol);
        }
        try {
            DataImportResponse response = new DataImportResponse(ImportStatus.SUCCESS, pdsDtsSymbol);
            if (isExisted && ImportMode.IGNORED.name().equals(param.get("IMPORT_MODE"))) {
                response.setStatus(ImportStatus.IGNORED);
                return response;
            }
            DynamicObject obj = this.saveObject(response, dataJsonStr, isExisted, param);
            if (response.getStatus() == ImportStatus.FAILED) {
                return response;
            }
            successObjs.add(obj);
            return response;
        }
        catch (Throwable e) {
            return new DataImportResponse(e, pdsDtsSymbol);
        }
    }

    private DynamicObject saveObject(DataImportResponse response, String dataStr, boolean isExisted, Map<String, Object> param) {
        String extNumber = String.format("IDataImport-%s", response.getEntityName());
        DynamicObjectHandler handler = (DynamicObjectHandler)ExtPluginFactory.getInstance().getExtPluginInstance(extNumber);
        if (null == handler) {
            handler = new PdsDynamicObjHandler();
        }
        handler.setResponse(response);
        DynamicObject object = handler.jsonToObject(dataStr);
        DynamicObject target = handler.beforeSave(object, !isExisted, param, response.isRef());
        handler.save(target, !isExisted, param);
        return target;
    }

    private boolean isExisted(Object id, String entityName) {
        QFilter qFilter = new QFilter("id", "=", id);
        return QueryServiceHelper.exists((String)entityName, (QFilter[])new QFilter[]{qFilter});
    }

    private List<String> readDts(Reader reader) throws IOException {
        String line;
        BufferedReader bufferedReader = new BufferedReader(reader);
        ArrayList<String> dts = new ArrayList<String>(16);
        while ((line = bufferedReader.readLine()) != null) {
            dts.add(line);
        }
        return dts;
    }
}

