/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.dataimport;

import kd.scm.pds.common.dataimport.PdsDtsSymbol;
import kd.scm.pds.common.enums.ImportStatus;

public class ImportResponse {
    private ImportStatus status;
    private String message;
    private Throwable err;
    private String entityName;
    private String entityTitle;
    private String number;
    private Object id;
    private StringBuilder detailMsg = new StringBuilder();

    public ImportResponse(ImportStatus status) {
        this.status = status;
    }

    public ImportResponse(PdsDtsSymbol pdsDtsSymbol) {
        this(ImportStatus.SUCCESS, pdsDtsSymbol);
    }

    public ImportResponse(Throwable err, PdsDtsSymbol pdsDtsSymbol) {
        this(ImportStatus.FAILED, pdsDtsSymbol);
        this.message = "";
        this.err = err;
    }

    public ImportResponse(ImportStatus status, PdsDtsSymbol pdsDtsSymbol) {
        this.status = status;
        this.entityName = pdsDtsSymbol.getEntityName();
        this.entityTitle = pdsDtsSymbol.getEntityTitle();
        this.id = pdsDtsSymbol.getId();
        this.number = pdsDtsSymbol.getNumber();
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getEntityTitle() {
        return this.entityTitle;
    }

    public Object getId() {
        return this.id;
    }

    public String getNumber() {
        return this.number;
    }

    public ImportStatus getStatus() {
        return this.status;
    }

    public String getMessage() {
        if (this.detailMsg.length() > 0) {
            this.message = null == this.message ? this.message + "\n" + this.detailMsg.toString() : this.detailMsg.toString();
        }
        return this.message;
    }

    public Throwable getErr() {
        return this.err;
    }

    public void setStatus(ImportStatus status) {
        this.status = status;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setErr(Throwable err) {
        this.err = err;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public void setEntityTitle(String entityTitle) {
        this.entityTitle = entityTitle;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public void setId(Object id) {
        this.id = id;
    }

    public void addDetailMessage(String info) {
        this.detailMsg.append(info);
    }
}

