/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.dataimport;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.exception.KDBizException;
import kd.bos.util.JSONUtils;
import kd.scm.pds.common.enums.ImportMode;

public class PdsDtsSymbol {
    public static final String SPLIT_TAG = "@PDS@";
    private Object id;
    private String number;
    private String entityName;
    private String entityTitle;
    private boolean isRef;
    private ImportMode importMode;

    public PdsDtsSymbol(String json) {
        try {
            Map prefixMap = (Map)JSONUtils.cast((String)json, Map.class);
            this.entityName = String.valueOf(prefixMap.get("entityName"));
            this.entityTitle = String.valueOf(prefixMap.get("entityTitle"));
            this.id = prefixMap.get("id");
            this.number = String.valueOf(prefixMap.get("number"));
            this.isRef = (Boolean)prefixMap.get("isRef");
        }
        catch (IOException e) {
            throw new KDBizException("cast exception:" + e.getMessage());
        }
    }

    public PdsDtsSymbol(Object id, String number, String entityName, String entityTitle, boolean isRef) {
        this.entityName = entityName;
        this.entityTitle = entityTitle;
        this.id = id;
        this.number = number;
        this.isRef = isRef;
    }

    public String toJson() {
        LinkedHashMap<String, Object> prefixMap = new LinkedHashMap<String, Object>();
        prefixMap.put("entityName", this.entityName);
        prefixMap.put("entityTitle", this.entityTitle);
        prefixMap.put("id", this.id);
        prefixMap.put("number", this.number);
        prefixMap.put("isRef", this.isRef);
        try {
            return JSONUtils.toString(prefixMap);
        }
        catch (IOException e) {
            throw new KDBizException("toString exception:" + e.getMessage());
        }
    }

    public ImportMode getImportMode() {
        return this.importMode;
    }

    public void setImportMode(ImportMode importMode) {
        this.importMode = importMode;
    }

    public Object getId() {
        return this.id;
    }

    public String getNumber() {
        return this.number;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getEntityTitle() {
        return this.entityTitle;
    }

    public boolean isRef() {
        return this.isRef;
    }
}

