/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.dataimport.handler;

import com.alibaba.fastjson.JSON;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.CreateDateProp;
import kd.bos.entity.property.CreaterProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.scm.common.util.JacksonJsonUtil;
import kd.scm.pds.common.dataimport.DataImportResponse;
import kd.scm.pds.common.dataimport.DynamicObjectHandler;
import kd.scm.pds.common.enums.ImportStatus;
import kd.scm.pds.common.util.DynamicObjectUtil;
import kd.scm.pds.common.util.ExportUtil;
import kd.scm.pds.common.util.PdsCommonUtils;

public class PdsDynamicObjHandler
implements DynamicObjectHandler {
    private Set<String> ignoreFields = new HashSet<String>(16);
    private String entity;
    private MainEntityType entityType;
    private DataImportResponse response;
    public Map<String, Object> notExistBdMap = new HashMap<String, Object>();

    public PdsDynamicObjHandler() {
        this.ignoreFields.addAll(ExportUtil.getIgnoreFields());
    }

    @Override
    public void forEntity(String entityKey) {
        this.entity = entityKey;
        this.entityType = EntityMetadataCache.getDataEntityType((String)this.entity);
    }

    public void initIngoreField() {
        this.ignoreFields.addAll(ExportUtil.getIgnoreFields());
    }

    public void addIgnoreField(String ... fieldNames) {
        if (fieldNames == null) {
            return;
        }
        this.ignoreFields.addAll(Arrays.asList(fieldNames));
    }

    public Set<String> excludedFields() {
        return this.ignoreFields;
    }

    @Override
    public String objectToJson(DynamicObject object) {
        List<Map<String, Object>> mapList = DynamicObjectUtil.serializeToMapWithOutDefaultValue(new DynamicObject[]{object}, (DynamicObjectType)this.entityType);
        return JSON.toJSONString(mapList);
    }

    @Override
    public DynamicObject jsonToObject(String json) {
        try {
            List mapList = (List)JacksonJsonUtil.fromJSON((String)json, List.class);
            return DynamicObjectUtil.deserializeFromMap(mapList, (DynamicObjectType)this.entityType).get(0);
        }
        catch (Throwable e) {
            String msg = ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e\uff08\u975e\u6b63\u5e38\u65b0\u589e\u6570\u636e\uff09\u53cd\u5e8f\u5217\u5316\u5931\u8d25->%1$s", (String)"PdsDynamicObjHandler_10", (String)"scm-pds-common", (Object[])new Object[0]);
            throw new KDBizException(String.format(msg, e.getMessage()));
        }
    }

    @Override
    public DynamicObject beforeSave(DynamicObject source, boolean isNew, Map<String, Object> param, boolean isRef) {
        DynamicObject target;
        if (isNew) {
            QFilter filter;
            String number;
            target = BusinessDataServiceHelper.newDynamicObject((String)this.entity);
            String numberPro = this.getNumberPro(target);
            IDataEntityProperty property = this.entityType.findProperty(numberPro);
            if (null != property && StringUtils.isNotBlank((CharSequence)(number = source.getString(property.getName()))) && QueryServiceHelper.exists((String)this.entity, (QFilter[])(filter = new QFilter(property.getName(), "=", (Object)number)).toArray())) {
                this.response.setStatus(ImportStatus.FAILED);
                String msg = ResManager.loadKDString((String)"%1$s\u91cd\u590d\uff0c\u65e0\u6cd5\u5bfc\u5165", (String)"PdsDynamicObjHandler_9", (String)"scm-pds-common", (Object[])new Object[0]);
                this.response.setMessage(String.format(msg, property.getDisplayName()));
                return target;
            }
        } else {
            target = BusinessDataServiceHelper.loadSingle((Object)source.getPkValue(), (String)this.entity);
        }
        DataEntityPropertyCollection properties = target.getDynamicObjectType().getProperties();
        this.copyProperty(source, target, properties, 1, isNew);
        return target;
    }

    @Override
    public void save(DynamicObject object, boolean isNew, Map<String, Object> param) {
        if (this.response.getStatus() == ImportStatus.FAILED) {
            return;
        }
        String numberPro = this.getNumberPro(object);
        String sourceNumber = object.getString(numberPro);
        OperationResult result = SaveServiceHelper.saveOperate((String)this.entity, (DynamicObject[])new DynamicObject[]{object}, (OperateOption)OperateOption.create());
        if (!result.isSuccess()) {
            StringBuilder errorMsg = new StringBuilder();
            result.getAllErrorOrValidateInfo().forEach(error -> errorMsg.append(error.getMessage()).append('\n'));
            String msg = ResManager.loadKDString((String)"\u6267\u884c\u4fdd\u5b58\u64cd\u4f5c\u5931\u8d25->%1$s", (String)"PdsDynamicObjHandler_11", (String)"scm-pds-common", (Object[])new Object[0]);
            this.response.setStatus(ImportStatus.FAILED);
            this.response.setMessage(String.format(msg, errorMsg.toString()));
        } else {
            String number = object.getString(numberPro);
            if (!sourceNumber.equals(number)) {
                object.set(numberPro, (Object)sourceNumber);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
            }
        }
    }

    @Override
    public void afterSave(List<DynamicObject> batch) {
    }

    private void copyProperty(DynamicObject source, DynamicObject target, DataEntityPropertyCollection properties, int level, boolean isNew) {
        if (level > 3) {
            return;
        }
        for (IDataEntityProperty property : properties) {
            if (PdsDynamicObjHandler.notIncludeProperty(property)) continue;
            if (property instanceof EntryProp || property instanceof SubEntryProp) {
                DynamicObjectCollection srcEntryList = source.getDynamicObjectCollection(property.getName());
                DynamicObjectCollection tarEntryList = target.getDynamicObjectCollection(property.getName());
                tarEntryList.clear();
                if (CollectionUtils.isEmpty((Collection)srcEntryList)) continue;
                DataEntityPropertyCollection entryProperties = null;
                boolean isFirst = true;
                for (DynamicObject srcEntry : srcEntryList) {
                    DynamicObject tarEntry = tarEntryList.addNew();
                    if (isFirst) {
                        isFirst = false;
                        entryProperties = tarEntry.getDataEntityType().getProperties();
                    }
                    this.copyProperty(srcEntry, tarEntry, entryProperties, level + 1, isNew);
                }
                continue;
            }
            if (level == 1) {
                if (isNew) {
                    if (property instanceof CreaterProp) {
                        target.set(property.getName(), (Object)PdsDynamicObjHandler.getContextUser());
                        continue;
                    }
                    if (property instanceof CreateDateProp) {
                        target.set(property.getName(), (Object)Timestamp.valueOf(LocalDateTime.now()));
                        continue;
                    }
                } else if ("id".equals(property.getName()) || property instanceof CreaterProp || property instanceof CreateDateProp) continue;
            }
            this.copyProperty(source, target, property);
        }
    }

    public void copyProperty(DynamicObject src, DynamicObject tar, IDataEntityProperty property) {
        Object val;
        if (this.ignoreFields.contains(property.getName())) {
            return;
        }
        if (property instanceof BasedataProp) {
            Object val2 = src.get(property.getName());
            if (val2 instanceof DynamicObject) {
                this.validData((DynamicObject)val2, property);
            }
        } else if (property instanceof MulBasedataProp && (val = src.get(property.getName())) instanceof DynamicObjectCollection) {
            DynamicObjectCollection cols = (DynamicObjectCollection)val;
            if (cols.size() == 0) {
                return;
            }
            boolean isFail = false;
            for (DynamicObject col : cols) {
                DynamicObject obj = col.getDynamicObject("fbasedataid");
                boolean isSuccess = this.validData(obj, property);
                if (isSuccess) continue;
                isFail = true;
            }
            if (!isFail) {
                tar.set(property.getName(), (Object)PdsCommonUtils.cloneCols(cols));
            }
            return;
        }
        tar.set(property.getName(), src.get(property.getName()));
    }

    public boolean validData(DynamicObject val, IDataEntityProperty property) {
        if (null == val) {
            return true;
        }
        String entityKey = val.getDynamicObjectType().getName();
        Object pkValue = val.getPkValue();
        StringBuilder bdKey = new StringBuilder();
        bdKey.append(entityKey).append('_').append(pkValue);
        if (null != this.notExistBdMap.get(bdKey.toString())) {
            return true;
        }
        boolean exists = QueryServiceHelper.exists((String)entityKey, (Object)pkValue);
        if (!exists) {
            this.notExistBdMap.put(bdKey.toString(), pkValue);
            this.response.addDetailMessage(String.format(ResManager.loadKDString((String)"%1$s{%2$s}\u5f15\u7528\u7684\u57fa\u7840\u8d44\u6599id->%3$s\u4e0d\u5b58\u5728\u3002", (String)"PdsDynamicObjHandler_8", (String)"scm-pds-common", (Object[])new Object[0]), property.getDisplayName(), property.getName(), pkValue));
            this.response.setStatus(ImportStatus.FAILED);
            return false;
        }
        return true;
    }

    private static DynamicObject getContextUser() {
        return BusinessDataServiceHelper.loadSingle((Object)RequestContext.get().getCurrUserId(), (String)"bos_user");
    }

    public static boolean notIncludeProperty(IDataEntityProperty property) {
        return "multilanguagetext".equals(property.getName()) || property instanceof PKFieldProp && ((PKFieldProp)property).isRefId();
    }

    @Override
    public void setResponse(DataImportResponse response) {
        this.response = response;
        this.forEntity(response.getEntityName());
    }

    @Override
    public DataImportResponse getResponse() {
        return this.response;
    }

    @Override
    public Set<String> getDirctEntityKey(String entityName) {
        HashSet<String> directEntityKey = new HashSet<String>(8);
        if ("pds_flowconfig".equals(entityName) || "pds_flowconfig_test".equals(entityName)) {
            directEntityKey.add("pds_biznode");
            directEntityKey.add("pds_tplconfig");
        } else if ("pds_tplconfig".equals(entityName)) {
            directEntityKey.add("pds_compreg");
        }
        return directEntityKey;
    }

    @Override
    public Set<String> loadRefrenceEntityKey(String entityName) {
        HashSet<String> refrenceEntityKey = new HashSet<String>(8);
        if ("pds_flowconfig".equals(entityName) || "pds_flowconfig_test".equals(entityName)) {
            refrenceEntityKey.add("pds_tplconfig");
        }
        return refrenceEntityKey;
    }
}

