/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.entity;

import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.BizLog;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.util.ParamUtil;
import org.apache.commons.lang3.StringUtils;

public class PdsObjectPools {
    private static Log log = LogFactory.getLog(PdsObjectPools.class);

    public static void putInstance(String key, Object object) {
        if (!PdsObjectPools.isObjectPool()) {
            return;
        }
        if (!StringUtils.isBlank((CharSequence)key) && null != object) {
            try {
                byte[] objectBytes = SerializationUtils.toByte((Object)object);
                PdsObjectPools.getCache().put(PdsObjectPools.getAccount_Key(key), objectBytes);
            }
            catch (Exception e) {
                log.info("PdsObjectPools@@@:" + e.getMessage());
            }
        }
    }

    public static <T> T getInstance(String key) {
        if (!PdsObjectPools.isObjectPool()) {
            return null;
        }
        byte[] objectBytes = null;
        try {
            objectBytes = PdsObjectPools.getCache().getByteValue(PdsObjectPools.getAccount_Key(key));
        }
        catch (Exception e) {
            log.info("PdsObjectPools@@@:" + e.getMessage());
            return null;
        }
        if (objectBytes == null || objectBytes.length == 0) {
            return null;
        }
        try {
            return (T)SerializationUtils.fromByte((byte[])objectBytes);
        }
        catch (Exception e) {
            log.info("PdsObjectPools@@@:" + e.getMessage());
            return null;
        }
    }

    public static void removeInstance(String key) {
        PdsObjectPools.getCache().remove(PdsObjectPools.getAccount_Key(key));
    }

    public static void removeEntryInstance(DynamicObjectCollection rows) {
        if (null == rows || rows.size() == 0) {
            return;
        }
        String[] keys = new String[rows.size()];
        int i = 0;
        for (DynamicObject row : rows) {
            String key = row.getString("pluginname");
            keys[i++] = PdsObjectPools.getAccount_Key(key);
        }
        PdsObjectPools.getCache().remove(keys);
    }

    public static DistributeSessionlessCache getCache() {
        return CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(RequestContext.get().getAccountId() + "_" + "src");
    }

    public static String getAccount_Key(String key) {
        return RequestContext.get().getAccountId() + '|' + key;
    }

    public static boolean isObjectPool() {
        Object isobjectpool = null;
        try {
            isobjectpool = ParamUtil.getParamObj((String)"0DUM2+6E41IA", (String)"isobjectpool");
            if (null == isobjectpool) {
                return false;
            }
        }
        catch (Exception e) {
            BizLog.log((String)("getParamException:" + e.getMessage()));
            isobjectpool = false;
        }
        return (Boolean)isobjectpool;
    }
}

