/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.entity;

import kd.scm.pds.common.enums.ResultEnums;

public class Result<T> {
    private String code;
    private String message;
    private T data;

    public Result(String code, String message, T data) {
        this.code = code;
        this.message = message;
        this.data = data;
    }

    public Result() {
    }

    public static Result success() {
        return Result.success(null);
    }

    public static <T> Result<T> success(T data) {
        return new Result<T>(ResultEnums.SUCCESS.getCode(), ResultEnums.SUCCESS.getContent(), data);
    }

    public static <T> Result<T> success(String code, String message) {
        return Result.success(code, message, null);
    }

    public static <T> Result<T> success(String code, String message, T data) {
        return new Result<T>(code, message, data);
    }

    public static Result failure() {
        return Result.failure(null);
    }

    public static <T> Result<T> failure(T data) {
        return new Result<T>(ResultEnums.FAIL.getCode(), ResultEnums.FAIL.getContent(), data);
    }

    public static <T> Result<T> failure(String code, String message) {
        return Result.failure(code, message, null);
    }

    public static <T> Result<T> failure(String code, String message, T data) {
        return new Result<T>(code, message, data);
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }
}

