/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.expertfilter.expertfilter;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.ParamUtil;
import kd.scm.pds.common.expertfilter.expertfilter.IExpertFilter;
import kd.scm.pds.common.expertfilter.schemefilter.ExpertSchemeUtils;
import kd.scm.pds.common.expertfilter.selecttool.ExpertContext;
import kd.scm.pds.common.expertfilter.selecttool.PdsExpertSelectUtils;
import kd.scm.pds.common.extfilter.ExtFilterFactory;
import kd.scm.pds.common.extfilter.ExtFilterUtils;
import kd.scm.pds.common.extfilter.FilterGridUtils;
import kd.scm.pds.common.extfilter.PdsQFilterHelper;
import kd.scm.pds.common.extfilter.SchemeFilterUtils;
import kd.scm.pds.common.util.ExtParameterUtils;
import kd.scm.pds.common.util.PdsCommonUtils;

public class ExpertFilterUtils {
    public static void getExpertQFilter(IFormView view, ExpertContext context) {
        QFilter schemeQfilter = ExpertSchemeUtils.getSchemeFilter(view);
        if (null == schemeQfilter) {
            return;
        }
        String orderBy = "basedata.number,matchfield desc,number";
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_expertscheme", (String)"id,number,matchfield,basedata.number,basedata.name,fieldid,maindata.number", (QFilter[])schemeQfilter.toArray(), (String)orderBy);
        if (null == rows || rows.size() == 0) {
            return;
        }
        Map<String, List<DynamicObject>> basedataMap = rows.stream().collect(Collectors.groupingBy(e -> e.getString("basedata.number")));
        context.setView(view);
        context.setEmpty(false);
        ExpertFilterUtils.getFilterParameter(context);
        Object[] basedataIds = new Object[basedataMap.size()];
        int index = 0;
        for (Map.Entry<String, List<DynamicObject>> entry : basedataMap.entrySet()) {
            basedataIds[index++] = entry.getValue().get(0).getLong("id");
            ExpertFilterUtils.setQueryConditionVisible(context, entry.getValue().get(0));
            ExpertFilterUtils.getExpertQFilterByScheme(context, entry.getValue().get(0));
            if (!context.isEmpty()) continue;
        }
        view.getModel().setValue("scheme", (Object)basedataIds);
    }

    private static void getExpertQFilterByScheme(ExpertContext context, DynamicObject schemeObj) {
        long schemeId = schemeObj.getLong("id");
        schemeObj = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"src_expertscheme");
        Map<String, Object> qfilterMap = FilterGridUtils.getQFilter("src_expertscheme", schemeId);
        context.setQfilter((QFilter)qfilterMap.get("qfilter"));
        context.setDescription(new StringBuilder(qfilterMap.get("description").toString()));
        ExtFilterUtils.getFieldMatchQFilter(context, schemeObj, context.getView().getModel().getDataEntity());
        List extFilters = ExtFilterFactory.getInstance().getExtFilterInstance("src_expertscheme", schemeId);
        if (null != extFilters && extFilters.size() > 0) {
            for (IExpertFilter extFilter : extFilters) {
                extFilter.buildQFilter(context);
            }
        }
        ExpertFilterUtils.buildExpertQFilter(context, schemeObj);
        PdsQFilterHelper.buildQFilterDescription(context);
    }

    private static void buildExpertQFilter(ExpertContext context, DynamicObject schemeObj) {
        QFilter qfilter = context.getQfilter();
        if (qfilter == null) {
            return;
        }
        context.getView().getPageCache().put(context.getBaseDataType(), qfilter.toSerializedString());
        String fieldName = schemeObj.getString("fieldid");
        if (StringUtils.isBlank((CharSequence)fieldName)) {
            fieldName = "user";
        }
        String fieldId = fieldName + "." + "id";
        if ("src_expert".equals(context.getBaseDataType()) || context.getBaseDataType().equals(context.getMainDataType())) {
            ExpertFilterUtils.linkExpertQFilter(context, qfilter);
            return;
        }
        DynamicObjectCollection rows = QueryServiceHelper.query((String)context.getBaseDataType(), (String)fieldId, (QFilter[])qfilter.toArray());
        if (rows == null || rows.size() == 0) {
            context.setEmpty(true);
        } else {
            Set userIds = rows.stream().map(e -> e.getLong(fieldId)).collect(Collectors.toSet());
            QFilter expertQfilter = new QFilter(fieldName, "in", userIds);
            ExpertFilterUtils.linkExpertQFilter(context, expertQfilter);
        }
    }

    private static void linkExpertQFilter(ExpertContext context, QFilter qfilter) {
        if (null == qfilter) {
            return;
        }
        if (context.getUltimateQFilter() == null) {
            context.setUltimateQFilter(qfilter);
        } else {
            context.setUltimateQFilter(context.getUltimateQFilter().and(qfilter));
        }
    }

    private static void setQueryConditionVisible(ExpertContext context, DynamicObject schemeObj) {
        String baseDataType = schemeObj.getString("basedata.number");
        context.setBaseDataType(baseDataType);
        String mainDataType = PdsCommonUtils.object2String(schemeObj.get("maindata.number"), "src_expert");
        context.setMainDataType(mainDataType);
        String baseDataName = schemeObj.getString("basedata.name");
        context.setBaseDataName(baseDataName);
        PdsExpertSelectUtils.setQueryConditionVisible(context.getView(), baseDataType, Boolean.TRUE);
        ExtFilterUtils.setProperiesVisibleByScheme(schemeObj.getLong("id"), "src_expertscheme", context.getView(), Boolean.TRUE);
    }

    public static void getFilterParameter(ExpertContext context) {
        context.setProjectObj(PdsCommonUtils.getProjectObj(context.getView()));
    }

    public static boolean isAutoQueryAndShow(ExpertContext context) {
        QFilter schemeQfilter = ExpertSchemeUtils.getSchemeFilter(context.getView());
        if (null == schemeQfilter) {
            return false;
        }
        String orderBy = "basedata.number,matchfield desc,number";
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_expertscheme", (String)"id,number,matchfield,basedata.number,basedata.name,fieldid", (QFilter[])schemeQfilter.toArray(), (String)orderBy);
        if (null == rows || rows.size() == 0) {
            return false;
        }
        for (DynamicObject row : rows) {
            if (!ExtParameterUtils.convertToBoolen(ExtParameterUtils.getExtParameterValueById("src_expertscheme", row.getLong("id"), "isautoquery", false, context.getProjectId()))) continue;
            return true;
        }
        return false;
    }

    public static String inviteExpertType() {
        Object invitetype = ParamUtil.getParamObj((String)"0DUM2+6E41IA", (String)"experttype");
        if (invitetype == null || "".equals(invitetype)) {
            return null;
        }
        if ("4".equals(invitetype)) {
            return "bos_user";
        }
        if ("5".equals(invitetype)) {
            return "src_expert";
        }
        return null;
    }

    public static void setExpertF7Filter(BeforeF7SelectEvent evt, DynamicObject billObj, String number, Map<String, Object> paramMap) {
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        ExpertContext context = new ExpertContext();
        context.setProjectObj(billObj);
        if (null != paramMap) {
            context.setParamMap(paramMap);
        }
        context.setNumber(number);
        List<Long> schemeIds = SchemeFilterUtils.getAllSchemeIds(context);
        if (schemeIds.size() == 0 && (null == paramMap || null == paramMap.get("ismustinput"))) {
            return;
        }
        QFilter qfilter = new QFilter("id", "in", schemeIds);
        showParameter.getListFilterParameter().setFilter(qfilter);
        String orderBy = context.getOrderBy().length() > 0 ? context.getOrderBy() : "createtime desc,number";
        showParameter.getListFilterParameter().setOrderBy(orderBy);
    }

    public static List<Long> getAllExpertIds(DynamicObject projectObj, String number, Map<String, Object> paramMap) {
        ExpertContext context = new ExpertContext();
        context.setProjectObj(projectObj);
        if (null != paramMap) {
            context.setParamMap(paramMap);
        }
        context.setNumber(number);
        return SchemeFilterUtils.getAllSchemeIds(context);
    }

    public static Date getDateFromContext(ExpertContext context, String fieldName, Date defaultValue) {
        Object dateObj = context.getParamMap().get(fieldName);
        if (null != dateObj) {
            return (Date)dateObj;
        }
        return defaultValue;
    }
}

