/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.expertfilter.expertfilter;

import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.pds.common.expertfilter.expertfilter.ExpertFilterUtils;
import kd.scm.pds.common.expertfilter.expertfilter.IExpertFilter;
import kd.scm.pds.common.expertfilter.selecttool.ExpertContext;
import kd.scm.pds.common.extfilter.PdsQFilterHelper;

public class PdsExpertFilterByLeavePeriod
implements IExpertFilter {
    private static final long serialVersionUID = 1L;

    @Override
    public Map<String, Object> getQFilter(ExpertContext context) {
        Map<String, Object> qfilterMap = PdsQFilterHelper.initQFilterMap();
        Date currentDate = TimeServiceHelper.now();
        Date datefrom = ExpertFilterUtils.getDateFromContext(context, "datefrom", currentDate);
        Date dateto = ExpertFilterUtils.getDateFromContext(context, "dateto", currentDate);
        QFilter qfilters = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal());
        QFilter fromFilters = new QFilter("datefrom", ">=", (Object)datefrom);
        fromFilters.and("datefrom", "<=", (Object)dateto);
        if (!dateto.equals(datefrom)) {
            QFilter toFilters = new QFilter("dateto", ">=", (Object)datefrom);
            toFilters.and("dateto", "<=", (Object)dateto);
            qfilters.and(fromFilters.or(toFilters));
        } else {
            qfilters.and(fromFilters);
        }
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_expertleave", (String)"expert.id", (QFilter[])qfilters.toArray());
        if (rows.size() == 0) {
            return qfilterMap;
        }
        Set idSet = rows.stream().map(e -> e.getLong("expert.id")).collect(Collectors.toSet());
        QFilter expertFilters = new QFilter("id", "not in", idSet);
        qfilterMap.put("qfilter", expertFilters);
        String description = "";
        qfilterMap.put("description", description);
        return qfilterMap;
    }
}

