/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.expertfilter.selecttool;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.scm.pds.common.expertfilter.selecttool.ExpertContext;
import kd.scm.pds.common.expertfilter.selecttool.IPdsExpertInitContext;
import kd.scm.pds.common.util.PdsCommonUtils;

public class PdsExpertInitContext
implements IPdsExpertInitContext<ExpertContext> {
    @Override
    public void initContext(ExpertContext context) {
        DynamicObject billObj = context.getView().getModel().getDataEntity();
        this.initProject(context, billObj);
        this.initPurOrg(context, billObj);
        this.initOtherInfo(context, billObj);
    }

    public void initProject(ExpertContext context, DynamicObject billObj) {
        context.setProjectId(billObj.getLong("project.id"));
        context.setPackageId(PdsCommonUtils.object2Long(context.getParamMap().get("packageid")));
        context.setManageType(billObj.getString("managetype"));
    }

    public void initPurOrg(ExpertContext context, DynamicObject billObj) {
        List<Long> purOrgIds = ((DynamicObjectCollection)context.getView().getModel().getValue("purorg")).stream().map(row -> row.getLong("fbasedataid.id")).collect(Collectors.toList());
        context.setPurorgIds(purOrgIds);
        List<String> purOrgNames = ((DynamicObjectCollection)context.getView().getModel().getValue("purorg")).stream().map(row -> row.getString("fbasedataid.name")).collect(Collectors.toList());
        context.setPurorgNames(purOrgNames);
    }

    public void initOtherInfo(ExpertContext context, DynamicObject billObj) {
        context.setRandomCount((Integer)context.getView().getModel().getValue("expertcount"));
        if (context.getRandomCount() == 0) {
            context.setRandomCount(10000);
        }
        context.getParamMap().put("datefrom", context.getView().getModel().getValue("datefrom"));
        context.getParamMap().put("dateto", context.getView().getModel().getValue("dateto"));
    }
}

